/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.logger;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import io.antmedia.logger.GoogleAnalyticsLogger;
import io.antmedia.logger.GoogleAnalyticsLoggerImp;
import io.antmedia.logger.LoggerEnvironment;

public class AntmediaAppender
extends AppenderBase<ILoggingEvent> {
    private final GoogleAnalyticsLogger googleAnalyticsLogger;

    public AntmediaAppender() {
        this.googleAnalyticsLogger = new GoogleAnalyticsLoggerImp(System.getProperty("red5.root") + "/conf/instanceId");
    }

    public AntmediaAppender(GoogleAnalyticsLogger googleAnalyticsLogger) {
        this.googleAnalyticsLogger = googleAnalyticsLogger;
    }

    protected void append(ILoggingEvent iLoggingEvent) {
        if (LoggerEnvironment.isManagingThread()) {
            return;
        }
        LoggerEnvironment.startManagingThread();
        try {
            IThrowableProxy throwbleProxy = iLoggingEvent.getThrowableProxy();
            if (throwbleProxy != null) {
                this.googleAnalyticsLogger.log(throwbleProxy);
            }
        }
        catch (Exception e) {
            this.addError("An exception occurred", e);
        }
        finally {
            LoggerEnvironment.stopManagingThread();
        }
    }

    public void stop() {
        LoggerEnvironment.startManagingThread();
        try {
            if (!this.isStarted()) {
                return;
            }
            super.stop();
        }
        catch (Exception e) {
            this.addError("An exception occurred", e);
        }
        finally {
            LoggerEnvironment.stopManagingThread();
        }
    }
}

