/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import io.antmedia.StreamIdValidator;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Playlist;
import io.antmedia.rest.RestServiceBase;
import io.antmedia.rest.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Contact;
import io.swagger.annotations.ExternalDocs;
import io.swagger.annotations.Info;
import io.swagger.annotations.License;
import io.swagger.annotations.SwaggerDefinition;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.stereotype.Component;

@Api(value="Playlist Rest Service")
@SwaggerDefinition(info=@Info(description="Ant Media Server REST API Reference", version="V2.0", title="Ant Media Server REST API Reference", contact=@Contact(name="Ant Media Info", email="contact@antmedia.io", url="https://antmedia.io"), license=@License(name="Apache 2.0", url="http://www.apache.org")), consumes={"application/json"}, produces={"application/json"}, schemes={SwaggerDefinition.Scheme.HTTP, SwaggerDefinition.Scheme.HTTPS}, externalDocs=@ExternalDocs(value="External Docs", url="https://antmedia.io"), basePath="/v2/Playlist")
@Component
@Path(value="/v2/playlists")
public class PlaylistRestService
extends RestServiceBase {
    @ApiOperation(value="Playlist list from database", response=Playlist.class)
    @GET
    @Path(value="/{playlistId}")
    @Produces(value={"application/json"})
    public Playlist getPlaylist(@ApiParam(value="id of the Playlist", required=true) @PathParam(value="playlistId") String playlistId) {
        Playlist playlist = null;
        if (playlistId != null) {
            playlist = this.getDataStore().getPlaylist(playlistId);
        }
        if (playlistId == null) {
            playlist = new Playlist();
        }
        return playlist;
    }

    @ApiOperation(value="Playlist list from database", response=Result.class)
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{playlistId}/stop")
    @Produces(value={"application/json"})
    public Result stopPlaylist(@ApiParam(value="id of the Playlist", required=true) @PathParam(value="playlistId") String playlistId) {
        Result result = new Result(false);
        if (playlistId != null) {
            Playlist playlist = this.getDataStore().getPlaylist(playlistId);
            if (playlist != null) {
                if (playlist.getBroadcastItemList().size() > playlist.getCurrentPlayIndex()) {
                    Broadcast broadcast = (Broadcast)playlist.getBroadcastItemList().get(playlist.getCurrentPlayIndex());
                    if (!broadcast.getStreamId().isEmpty() && broadcast.getStreamId() != null) {
                        result = this.getApplication().stopStreaming(broadcast);
                        playlist.setPlaylistStatus("finished");
                        this.getDataStore().editPlaylist(playlistId, playlist);
                    }
                } else {
                    result.setMessage("Playlist Current Broadcast not found. Playlist Broadcast Size: " + playlist.getBroadcastItemList().size() + " Playlist Current Broadcast Index: " + playlist.getCurrentPlayIndex());
                }
            } else {
                result.setMessage("Playlist not found");
            }
        }
        return result;
    }

    @ApiOperation(value="Playlist list from database", response=Result.class)
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{playlistId}/start")
    @Produces(value={"application/json"})
    public Result startPlaylist(@ApiParam(value="id of the Playlist", required=true) @PathParam(value="playlistId") String playlistId) {
        Result result = new Result(false);
        if (playlistId != null) {
            Playlist playlist = this.getDataStore().getPlaylist(playlistId);
            if (playlist != null) {
                if (playlist.getBroadcastItemList().size() > playlist.getCurrentPlayIndex()) {
                    Broadcast broadcast = (Broadcast)playlist.getBroadcastItemList().get(playlist.getCurrentPlayIndex());
                    if (!broadcast.getStreamId().isEmpty() && broadcast.getStreamId() != null) {
                        result = this.startPlaylistService(playlist);
                    }
                } else {
                    result.setMessage("Playlist Current Broadcast not found. Playlist Broadcast Size: " + playlist.getBroadcastItemList().size() + " Playlist Current Broadcast Index: " + playlist.getCurrentPlayIndex());
                }
            } else {
                result.setMessage("Playlist not found");
            }
        }
        return result;
    }

    @ApiOperation(value="Delete specific Playlist", response=Result.class)
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/{playlistId}")
    @Produces(value={"application/json"})
    public Result deletePlaylist(@ApiParam(value="the playlistId of the Playlist", required=true) @PathParam(value="playlistId") String playlistId) {
        Result result = new Result(false);
        if (playlistId != null) {
            Broadcast broadcast = this.getDataStore().get(playlistId);
            result.setSuccess(this.getDataStore().deletePlaylist(playlistId));
            this.getDataStore().delete(playlistId);
            this.getApplication().stopStreaming(broadcast);
            return result;
        }
        return result;
    }

    @ApiOperation(value="Create Playlist", notes="", response=Result.class)
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/create")
    @Produces(value={"application/json"})
    public Result createPlaylist(@ApiParam(value="the name of the Playlist File", required=false) Playlist playlist, @ApiParam(value="If it's true, it starts automatically pulling playlist broadcasts. Default value is false by default", required=false, defaultValue="false") @QueryParam(value="autoStart") boolean autoStart) {
        Result result = new Result(false);
        if (playlist.getPlaylistId() != null && !playlist.getPlaylistId().isEmpty()) {
            Playlist playlistTmp = this.getDataStore().getPlaylist(playlist.getPlaylistId());
            if (playlistTmp != null) {
                result.setMessage("Playlist id is already being used");
                return result;
            }
            if (!StreamIdValidator.isStreamIdValid((String)playlist.getPlaylistId())) {
                result.setMessage("Playlist id is not valid");
                return result;
            }
        } else {
            playlist.setPlaylistId(RandomStringUtils.randomNumeric((int)24));
        }
        this.checkBroadcastIdsInPlaylist(playlist);
        result.setSuccess(this.getDataStore().createPlaylist(playlist));
        if (result.isSuccess()) {
            PlaylistRestService.saveBroadcast((Broadcast)playlist.getBroadcastItemList().get(playlist.getCurrentPlayIndex()), "created", this.getScope().getName(), this.getDataStore(), this.getAppSettings().getListenerHookURL(), this.getServerSettings(), 0L);
            if (autoStart) {
                result = this.startPlaylistService(playlist);
            }
        }
        return result;
    }

    @ApiOperation(value="Edit Playlist", notes="", response=Result.class)
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/edit/{playlistId}")
    @Produces(value={"application/json"})
    public Result editPlaylist(@ApiParam(value="id of the Playlist") @PathParam(value="playlistId") String playlistId, @ApiParam(value="the name of the Playlist File", required=true) Playlist playlist) {
        Result result = new Result(false);
        if (playlistId != null && playlist.getPlaylistId() != null) {
            this.checkBroadcastIdsInPlaylist(playlist);
            result.setSuccess(this.getDataStore().editPlaylist(playlistId, playlist));
            return result;
        }
        return result;
    }
}

