/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import io.antmedia.datastore.db.types.VoD;
import io.antmedia.rest.BroadcastRestService;
import io.antmedia.rest.RestServiceBase;
import io.antmedia.rest.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Contact;
import io.swagger.annotations.ExternalDocs;
import io.swagger.annotations.Info;
import io.swagger.annotations.License;
import io.swagger.annotations.SwaggerDefinition;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;

@Api(value="VoD Rest Service")
@SwaggerDefinition(info=@Info(description="Ant Media Server REST API Reference", version="V2.0", title="Ant Media Server REST API Reference", contact=@Contact(name="Ant Media Info", email="contact@antmedia.io", url="https://antmedia.io"), license=@License(name="Apache 2.0", url="http://www.apache.org")), consumes={"application/json"}, produces={"application/json"}, schemes={SwaggerDefinition.Scheme.HTTP, SwaggerDefinition.Scheme.HTTPS}, externalDocs=@ExternalDocs(value="External Docs", url="https://antmedia.io"), basePath="/v2/VoD")
@Component
@Path(value="/v2/vods")
public class VoDRestService
extends RestServiceBase {
    @Override
    @ApiOperation(value="VoD file from database", response=VoD.class)
    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public VoD getVoD(@ApiParam(value="id of the VoD", required=true) @PathParam(value="id") String id) {
        return super.getVoD(id);
    }

    @Override
    @ApiOperation(value="Import VoDs to Stalker Portal", response=Result.class)
    @POST
    @Path(value="/import-to-stalker")
    @Produces(value={"application/json"})
    public Result importVoDsToStalker() {
        return super.importVoDsToStalker();
    }

    @ApiOperation(value=" Get the VoD list from database", responseContainer="List", response=VoD.class)
    @GET
    @Path(value="/list/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<VoD> getVodList(@ApiParam(value="offset of the list", required=true) @PathParam(value="offset") int offset, @ApiParam(value="Number of items that will be fetched", required=true) @PathParam(value="size") int size, @ApiParam(value="Field to sort", required=false) @QueryParam(value="sort_by") String sortBy, @ApiParam(value="asc for Ascending, desc Descening order", required=false) @QueryParam(value="order_by") String orderBy, @ApiParam(value="Id of the stream to filter the results by stream id", required=true) @QueryParam(value="streamId") String streamId) {
        return this.getDataStore().getVodList(offset, size, sortBy, orderBy, streamId);
    }

    @ApiOperation(value="Get the total number of VoDs", response=Long.class)
    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    public BroadcastRestService.SimpleStat getTotalVodNumber() {
        return new BroadcastRestService.SimpleStat(this.getDataStore().getTotalVodNumber());
    }

    @Override
    @ApiOperation(value="Delete specific VoD File", response=Result.class)
    @DELETE
    @Consumes(value={"application/json"})
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Result deleteVoD(@ApiParam(value="the id of the VoD file", required=true) @PathParam(value="id") String id) {
        return super.deleteVoD(id);
    }

    @Override
    @ApiOperation(value="Upload external VoD file to Ant Media Server", notes="", response=Result.class)
    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/create")
    @Produces(value={"application/json"})
    public Result uploadVoDFile(@ApiParam(value="the name of the VoD File", required=true) @QueryParam(value="name") String fileName, @ApiParam(value="file", required=true) @FormDataParam(value="file") InputStream inputStream) {
        return super.uploadVoDFile(fileName, inputStream);
    }

    @Override
    @ApiOperation(value="Synchronize VoD Folder and add them to VoD database if any file exist and create symbolic links to that folder", notes="Notes here", response=Result.class)
    @POST
    @Path(value="/synch-user-vod-list")
    @Produces(value={"application/json"})
    public Result synchUserVodList() {
        return super.synchUserVodList();
    }
}

