/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.shutdown;

import io.antmedia.shutdown.IShutdownListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMSShutdownManager {
    protected Logger logger = LoggerFactory.getLogger(AMSShutdownManager.class);
    private static AMSShutdownManager instance = new AMSShutdownManager();
    private volatile boolean isShuttingDown = false;
    private ArrayList<IShutdownListener> listeners = new ArrayList();

    public static AMSShutdownManager getInstance() {
        return instance;
    }

    private AMSShutdownManager() {
    }

    public void subscribe(IShutdownListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void notifyShutdown() {
        if (!this.isShuttingDown) {
            this.isShuttingDown = true;
            for (IShutdownListener listener : this.listeners) {
                try {
                    listener.serverShuttingdown();
                }
                catch (Exception e) {
                    this.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    public List<IShutdownListener> getListeners() {
        return this.listeners;
    }
}

