/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.social.endpoint;

import io.antmedia.api.periscope.AuthorizationEndpoints;
import io.antmedia.api.periscope.BroadcastEndpoints;
import io.antmedia.api.periscope.ChatEndpoints;
import io.antmedia.api.periscope.PeriscopeEndpointFactory;
import io.antmedia.api.periscope.RegionEndpoints;
import io.antmedia.api.periscope.UserEndpoints;
import io.antmedia.api.periscope.response.AuthorizationResponse;
import io.antmedia.api.periscope.response.CheckDeviceCodeResponse;
import io.antmedia.api.periscope.response.CreateBroadcastResponse;
import io.antmedia.api.periscope.response.CreateDeviceCodeResponse;
import io.antmedia.api.periscope.type.Broadcast;
import io.antmedia.api.periscope.type.IChatListener;
import io.antmedia.api.periscope.type.User;
import io.antmedia.api.periscope.type.chatEndpointTypes.ChatMessage;
import io.antmedia.api.periscope.type.chatEndpointTypes.ErrorMessage;
import io.antmedia.api.periscope.type.chatEndpointTypes.HeartMessage;
import io.antmedia.api.periscope.type.chatEndpointTypes.JoinMessage;
import io.antmedia.api.periscope.type.chatEndpointTypes.ScreenshotMessage;
import io.antmedia.api.periscope.type.chatEndpointTypes.ShareMessage;
import io.antmedia.api.periscope.type.chatEndpointTypes.SuperHeartMessage;
import io.antmedia.api.periscope.type.chatEndpointTypes.ViewerCountMessage;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.rest.model.Interaction;
import io.antmedia.social.LiveComment;
import io.antmedia.social.ResourceOrigin;
import io.antmedia.social.endpoint.VideoServiceEndpoint;
import io.vertx.core.Vertx;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriscopeEndpoint
extends VideoServiceEndpoint {
    private static final String FIRST_AUTHENTICATED_THE_SERVER = "First authenticated the server";
    private AuthorizationEndpoints authorizationEndpoint;
    private String device_code;
    private PeriscopeEndpointFactory periscopeEndpointFactory;
    private BroadcastEndpoints broadcastEndpoint;
    private RegionEndpoints regionEndpoint;
    private String accessToken;
    private String region;
    private long expireTimeMS;
    private UserEndpoints userEndpoint;
    private String refresh_token;
    private ChatEndpoints chatEndpoint;
    protected Map<String, Integer> viewerCountMap = new HashMap<String, Integer>();
    private Map<String, List<LiveComment>> commentMapList = new HashMap<String, List<LiveComment>>();
    private Map<String, Interaction> interactionMap = new HashMap<String, Interaction>();
    private static Logger logger = LoggerFactory.getLogger(PeriscopeEndpoint.class);

    public PeriscopeEndpoint(String clientId, String clientSecret, DataStore dataStore, SocialEndpointCredentials endpointCredentials, Vertx vertx) {
        super(clientId, clientSecret, dataStore, endpointCredentials, vertx);
    }

    @Override
    public String getName() {
        return "periscope";
    }

    @Override
    public VideoServiceEndpoint.DeviceAuthParameters askDeviceAuthParameters() throws Exception {
        AuthorizationEndpoints authorizationEndpointTmp = this.getAuthorizationEndpoint();
        CreateDeviceCodeResponse response = authorizationEndpointTmp.createDeviceCode(this.getClientId(), "chat");
        if (response != null) {
            this.authParameters = new VideoServiceEndpoint.DeviceAuthParameters();
            this.authParameters.device_code = response.device_code;
            this.device_code = response.device_code;
            this.authParameters.expires_in = response.expires_in;
            this.authParameters.interval = response.interval;
            this.authParameters.user_code = response.user_code;
            this.authParameters.verification_url = response.associate_url;
        }
        return this.getAuthParameters();
    }

    private AuthorizationEndpoints getAuthorizationEndpoint() {
        if (this.authorizationEndpoint == null) {
            this.authorizationEndpoint = new AuthorizationEndpoints();
        }
        return this.authorizationEndpoint;
    }

    @Override
    public boolean askIfDeviceAuthenticated() throws Exception {
        AuthorizationEndpoints authorizationEndpointTmp = this.getAuthorizationEndpoint();
        CheckDeviceCodeResponse checkDeviceCode = authorizationEndpointTmp.checkDeviceCode(this.device_code, this.getClientId());
        logger.warn("State: {}", (Object)checkDeviceCode.state);
        boolean result = false;
        if ("associated".equals(checkDeviceCode.state)) {
            this.init("", checkDeviceCode.access_token, checkDeviceCode.refresh_token, checkDeviceCode.expires_in, checkDeviceCode.token_type, System.currentTimeMillis());
            String accountName = "";
            String accountId = "";
            try {
                User userResponse = this.userEndpoint.get();
                accountName = userResponse.username;
                accountId = userResponse.id;
                logger.info("authenticated account name is {}", (Object)accountName);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            this.saveCredentials(accountName, checkDeviceCode.access_token, checkDeviceCode.refresh_token, String.valueOf(checkDeviceCode.expires_in), checkDeviceCode.token_type, accountId);
            result = true;
        }
        return result;
    }

    @Override
    public boolean isAuthenticated() {
        return this.periscopeEndpointFactory != null && this.accessToken != null && this.accessToken.length() > 0;
    }

    @Override
    public void resetCredentials() {
        super.resetCredentials();
        this.accessToken = null;
    }

    @Override
    public Endpoint createBroadcast(String name, String description, String serverStreamId, boolean is360, boolean isPublic, int videoHeight, boolean isLowLatency) throws IOException {
        if (this.broadcastEndpoint == null) {
            throw new NullPointerException(FIRST_AUTHENTICATED_THE_SERVER);
        }
        try {
            this.updateTokenIfRequired();
            CreateBroadcastResponse createBroadcastResponse = this.broadcastEndpoint.createBroadcast(this.getRegion(), is360, isLowLatency);
            String rtmpUrl = createBroadcastResponse.encoder.rtmp_url + "/" + createBroadcastResponse.encoder.stream_key;
            return new Endpoint(createBroadcastResponse.broadcast.id, null, name, rtmpUrl, this.getName(), this.getCredentials().getId(), serverStreamId);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new IOException(e.getMessage());
        }
    }

    private String getRegion() {
        if (this.region == null) {
            try {
                this.region = this.regionEndpoint.get();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return this.region;
    }

    @Override
    public void publishBroadcast(Endpoint endpoint) throws Exception {
        if (this.broadcastEndpoint == null) {
            throw new NullPointerException(FIRST_AUTHENTICATED_THE_SERVER);
        }
        if (endpoint.getBroadcastId() == null) {
            throw new NullPointerException("No broadcast is available, call createBroadcast function before calling publish broadcast");
        }
        this.updateTokenIfRequired();
        this.broadcastEndpoint.publishBroadcast(endpoint.getBroadcastId(), endpoint.getName(), false, "en_US", true);
        if (this.isCollectInteractivity()) {
            this.connectToChatEndpoint(endpoint);
        }
    }

    @Override
    public void stopBroadcast(Endpoint endpoint) throws Exception {
        if (this.broadcastEndpoint == null) {
            throw new NullPointerException(FIRST_AUTHENTICATED_THE_SERVER);
        }
        if (endpoint.getBroadcastId() == null) {
            throw new NullPointerException("No broadcast is available");
        }
        this.updateTokenIfRequired();
        this.broadcastEndpoint.stopBroadcast(endpoint.getBroadcastId());
        this.viewerCountMap.remove(endpoint.getServerStreamId());
        this.commentMapList.remove(endpoint.getServerStreamId());
        this.interactionMap.remove(endpoint.getServerStreamId());
    }

    private void updateTokenIfRequired() throws Exception {
        if (this.expireTimeMS < System.currentTimeMillis() + THREE_DAYS_IN_MS) {
            this.updateToken();
        }
    }

    public void updateToken() throws Exception {
        AuthorizationResponse token = this.periscopeEndpointFactory.refreshToken(this.clientId, this.clientSecret);
        if (token.refresh_token == null || token.refresh_token.length() == 0) {
            token.refresh_token = this.refresh_token;
        }
        this.saveCredentials(this.getCredentials().getAccountName(), token.access_token, token.refresh_token, String.valueOf(token.expires_in), token.token_type, this.getCredentials().getAccountId());
        this.init(this.getCredentials().getAccountName(), token.access_token, token.refresh_token, Long.valueOf(token.expires_in), token.token_type, System.currentTimeMillis());
    }

    @Override
    public void init(String accountName, String accessToken, String refreshToken, long expireTime, String tokenType, long authTimeInMS) {
        this.accessToken = accessToken;
        this.refresh_token = refreshToken;
        this.periscopeEndpointFactory = new PeriscopeEndpointFactory(tokenType, accessToken, refreshToken);
        this.expireTimeMS = authTimeInMS + expireTime * 1000L;
        this.broadcastEndpoint = this.periscopeEndpointFactory.getBroadcastEndpoints();
        this.regionEndpoint = this.periscopeEndpointFactory.getRegionEndpoints();
        this.userEndpoint = this.periscopeEndpointFactory.getUserEndpoints();
        this.chatEndpoint = this.periscopeEndpointFactory.getChatEndpoints();
    }

    @Override
    public String getBroadcast(Endpoint endpoint) throws Exception {
        Broadcast broadcast = this.broadcastEndpoint.getBroadcast(endpoint.getBroadcastId());
        return "running".equals(broadcast.state) ? "LIVE" : "UNPUBLISHED";
    }

    public void connectToChatEndpoint(Endpoint endpoint) {
        this.chatEndpoint.connect(endpoint.getBroadcastId(), this.getNewChatListener(endpoint));
    }

    public IChatListener getNewChatListener(Endpoint endpoint) {
        return new ChatListener(endpoint);
    }

    public String getAccountName() {
        return this.getCredentials().getAccountName();
    }

    public void setAccountName(String accountName) {
        this.getCredentials().setAccountName(accountName);
    }

    @Override
    public List<LiveComment> getComments(String streamId, int offset, int batch) {
        int size;
        List<LiveComment> comments = this.commentMapList.get(streamId);
        List<LiveComment> resultList = null;
        if (comments != null && offset < (size = comments.size())) {
            int toIndex = offset + batch;
            if (toIndex > size) {
                toIndex = size;
            }
            resultList = comments.subList(offset, toIndex);
        }
        return resultList;
    }

    @Override
    public Interaction getInteraction(String streamId) {
        return this.interactionMap.getOrDefault(streamId, null);
    }

    @Override
    public int getTotalCommentsCount(String streamId) {
        List<LiveComment> comments = this.commentMapList.get(streamId);
        if (comments != null) {
            return comments.size();
        }
        return 0;
    }

    @Override
    public long getLiveViews(String streamId) {
        return this.viewerCountMap.getOrDefault(streamId, 0).intValue();
    }

    public class ChatListener
    implements IChatListener {
        private Endpoint endpoint;

        public ChatListener(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public void viewerCountMessageReceived(ViewerCountMessage viewerCountMessage) {
            logger.debug("viewerCountMessageReceived live view {}", (Object)viewerCountMessage.live);
            if (viewerCountMessage.total < 0) {
                viewerCountMessage.total = 0;
            }
            PeriscopeEndpoint.this.viewerCountMap.put(this.endpoint.getServerStreamId(), viewerCountMessage.total);
        }

        public void screenshotMessageReceived(ScreenshotMessage screenshotMessage) {
        }

        public void errorMessageReceived(ErrorMessage errorMessage) {
            logger.error("errorMessageReceived  {} for stream {} ", (Object)errorMessage.description, (Object)this.endpoint.getStreamId());
        }

        public void chatMessageReceived(ChatMessage chatMessage) {
            logger.debug("chatMessageReceived {} from {} for stream {} ", new Object[]{chatMessage.text, chatMessage.user.display_name, this.endpoint.getStreamId()});
            ArrayList<LiveComment> list = (ArrayList<LiveComment>)PeriscopeEndpoint.this.commentMapList.get(this.endpoint.getServerStreamId());
            if (list == null) {
                list = new ArrayList<LiveComment>();
            }
            io.antmedia.rest.model.User from = new io.antmedia.rest.model.User();
            from.setId(chatMessage.user.id);
            from.setFullName(chatMessage.user.display_name);
            from.setPicture(((User.ProfileImageUrls)chatMessage.user.profile_image_urls.get((int)0)).url);
            list.add(new LiveComment(chatMessage.id, chatMessage.text, from, ResourceOrigin.PERISCOPE, System.currentTimeMillis()));
            PeriscopeEndpoint.this.commentMapList.put(this.endpoint.getServerStreamId(), list);
        }

        public void heartMessageReceived(HeartMessage heartMessage) {
            logger.debug("heart MessageReceived for stream {}", (Object)this.endpoint.getServerStreamId());
            Interaction interaction = (Interaction)PeriscopeEndpoint.this.interactionMap.get(this.endpoint.getServerStreamId());
            if (interaction == null) {
                interaction = new Interaction();
            }
            interaction.setLoveCount(interaction.getLoveCount() + 1);
            interaction.setOrigin(ResourceOrigin.PERISCOPE);
            PeriscopeEndpoint.this.interactionMap.put(this.endpoint.getServerStreamId(), interaction);
        }

        public void superheartMessageReceived(SuperHeartMessage heartMessage) {
        }

        public void joinMessageReceived(JoinMessage joinMessage) {
        }

        public void shareMessageReceived(ShareMessage shareMessage) {
        }
    }
}

