/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.statistic;

import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.nvml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPUUtils {
    private static Logger logger = LoggerFactory.getLogger(GPUUtils.class);
    private static GPUUtils instance;
    private static boolean noGPU;
    private Integer deviceCount = null;

    private GPUUtils() {
    }

    public static GPUUtils getInstance() {
        if (instance == null) {
            instance = new GPUUtils();
            try {
                Class.forName("org.bytedeco.javacpp.nvml");
                Loader.load(nvml.class);
                int result = nvml.nvmlInit_v2();
                if (result == 0) {
                    logger.info("cuda initialized {}", (Object)"");
                    noGPU = false;
                } else {
                    logger.warn("Nvml cannot be initialized {}", (Object)GPUUtils.class.getSimpleName());
                }
            }
            catch (UnsatisfiedLinkError e) {
                logger.warn("UnsatisfiedLinkError no cuda installed {}", (Object)e.getMessage());
            }
            catch (ClassNotFoundException e) {
                logger.warn("ClassNotFoundException nvml class not found {}", (Object)e.getMessage());
            }
        }
        return instance;
    }

    public int getDeviceCount() {
        if (noGPU) {
            return 0;
        }
        if (this.deviceCount == null) {
            IntPointer count = new IntPointer(1L);
            int result = nvml.nvmlDeviceGetCount_v2((IntPointer)count);
            this.deviceCount = result == 0 ? Integer.valueOf(count.get()) : Integer.valueOf(0);
        }
        return this.deviceCount;
    }

    public nvml.nvmlDevice_st getDevice(int deviceIndex) {
        nvml.nvmlDevice_st device;
        if (!noGPU && nvml.nvmlDeviceGetHandleByIndex_v2((int)deviceIndex, (nvml.nvmlDevice_st)(device = new nvml.nvmlDevice_st())) == 0) {
            return device;
        }
        return null;
    }

    private nvml.nvmlUtilization_t getUtilization(int deviceNo) {
        nvml.nvmlUtilization_t deviceUtilization;
        nvml.nvmlDevice_st device = null;
        device = this.getDevice(deviceNo);
        if (device != null && nvml.nvmlDeviceGetUtilizationRates((nvml.nvmlDevice_st)device, (nvml.nvmlUtilization_t)(deviceUtilization = new nvml.nvmlUtilization_t())) == 0) {
            return deviceUtilization;
        }
        return null;
    }

    public MemoryStatus getMemoryStatus(int deviceNo) {
        nvml.nvmlMemory_t nvmlMemory;
        nvml.nvmlDevice_st device = null;
        device = this.getDevice(deviceNo);
        if (device != null && nvml.nvmlDeviceGetMemoryInfo((nvml.nvmlDevice_st)device, (nvml.nvmlMemory_t)(nvmlMemory = new nvml.nvmlMemory_t())) == 0) {
            return new MemoryStatus(nvmlMemory.total(), nvmlMemory.used(), nvmlMemory.free());
        }
        return null;
    }

    public String getDeviceName(int deviceIndex) {
        byte[] nameByte;
        nvml.nvmlDevice_st device = null;
        device = this.getDevice(deviceIndex);
        if (device != null && nvml.nvmlDeviceGetName((nvml.nvmlDevice_st)device, (byte[])(nameByte = new byte[64]), (int)nameByte.length) == 0) {
            String name;
            int indexOf = (name = new String(nameByte, 0, nameByte.length)).indexOf("\u0000");
            return name.substring(0, indexOf > 0 ? indexOf : name.length());
        }
        return null;
    }

    public int getMemoryUtilization(int deviceNo) {
        nvml.nvmlUtilization_t utilization = this.getUtilization(deviceNo);
        if (utilization != null) {
            return utilization.memory();
        }
        return -1;
    }

    public int getGPUUtilization(int deviceNo) {
        nvml.nvmlUtilization_t utilization = this.getUtilization(deviceNo);
        if (utilization != null) {
            return utilization.gpu();
        }
        return -1;
    }

    static {
        noGPU = true;
    }

    public static class MemoryStatus {
        private long memoryTotal;
        private long memoryUsed;
        private long memoryFree;

        public MemoryStatus(long memoryTotal, long memoryUsed, long memoryFree) {
            this.memoryTotal = memoryTotal;
            this.memoryUsed = memoryUsed;
            this.memoryFree = memoryFree;
        }

        public long getMemoryTotal() {
            return this.memoryTotal;
        }

        public long getMemoryUsed() {
            return this.memoryUsed;
        }

        public long getMemoryFree() {
            return this.memoryFree;
        }
    }
}

