/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.streamsource;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.IApplicationAdaptorFactory;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.muxer.MuxAdaptor;
import io.antmedia.muxer.Muxer;
import io.antmedia.muxer.RtmpMuxer;
import io.antmedia.rest.model.Result;
import io.vertx.core.Vertx;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bytedeco.javacpp.avcodec;
import org.bytedeco.javacpp.avformat;
import org.bytedeco.javacpp.avutil;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFetcher {
    private static final String STREAM_TYPE_VOD = "VoD";
    protected static Logger logger = LoggerFactory.getLogger(StreamFetcher.class);
    private Broadcast stream;
    private WorkerThread thread;
    private int timeout;
    private boolean exceptionInThread = false;
    private long lastPacketReceivedTime = 0L;
    private boolean threadActive = false;
    private Result cameraError = new Result(false, "");
    private static final int PACKET_RECEIVED_INTERVAL_TIMEOUT = 3000;
    private IScope scope;
    private AntMediaApplicationAdapter appInstance;
    private long[] lastDTS;
    private MuxAdaptor muxAdaptor = null;
    private boolean restartStream = true;
    private volatile boolean stopRequestReceived = false;
    private int bufferTime = 0;
    private static final int COUNT_TO_LOG_BUFFER = 500;
    private int bufferLogCounter;
    private ConcurrentLinkedQueue<avcodec.AVPacket> availableBufferQueue = new ConcurrentLinkedQueue();
    private AppSettings appSettings;
    private Vertx vertx;
    IStreamFetcherListener streamFetcherListener;

    public IStreamFetcherListener getStreamFetcherListener() {
        return this.streamFetcherListener;
    }

    public void setStreamFetcherListener(IStreamFetcherListener streamFetcherListener) {
        this.streamFetcherListener = streamFetcherListener;
    }

    public StreamFetcher(Broadcast stream, IScope scope, Vertx vertx) {
        if (stream == null || stream.getStreamId() == null || stream.getStreamUrl() == null) {
            String streamId = null;
            if (stream != null) {
                streamId = stream.getStreamId();
            }
            String streamUrl = null;
            if (stream != null) {
                streamUrl = stream.getStreamUrl();
            }
            throw new NullPointerException("Stream is not initialized properly. Check stream(" + stream + "),  stream id (" + streamId + ") and stream url (" + streamUrl + ") values");
        }
        this.stream = stream;
        this.scope = scope;
        this.vertx = vertx;
        if (this.getAppSettings() == null) {
            throw new NullPointerException("App Settings is null in StreamFetcher");
        }
        this.bufferTime = this.getAppSettings().getStreamFetcherBufferTime();
    }

    public Result prepareInput(avformat.AVFormatContext inputFormatContext) {
        this.setConnectionTimeout(5000);
        Result result = new Result(false);
        if (inputFormatContext == null) {
            logger.info("cannot allocate input context for {}", (Object)this.stream.getStreamId());
            return result;
        }
        avutil.AVDictionary optionsDictionary = new avutil.AVDictionary();
        String streamUrl = this.stream.getStreamUrl();
        String transportType = this.appSettings.getRtspPullTransportType();
        if (streamUrl.startsWith("rtsp://") && !transportType.isEmpty()) {
            logger.info("Setting rtsp transport type to {} for stream source: {}", (Object)transportType, (Object)streamUrl);
            avutil.av_dict_set((avutil.AVDictionary)optionsDictionary, (String)"rtsp_transport", (String)transportType, (int)0);
        }
        String timeoutStr = String.valueOf(this.timeout);
        avutil.av_dict_set((avutil.AVDictionary)optionsDictionary, (String)"stimeout", (String)timeoutStr, (int)0);
        logger.debug("stream url: {}  ", (Object)this.stream.getStreamUrl());
        int ret = avformat.avformat_open_input((avformat.AVFormatContext)inputFormatContext, (String)this.stream.getStreamUrl(), null, (avutil.AVDictionary)optionsDictionary);
        if (ret < 0) {
            byte[] data = new byte[100];
            avutil.av_strerror((int)ret, (byte[])data, (long)data.length);
            String errorStr = new String(data, 0, data.length);
            result.setMessage(errorStr);
            logger.error("cannot open stream: {} with error:: {}", (Object)this.stream.getStreamUrl(), (Object)result.getMessage());
            avutil.av_dict_free((avutil.AVDictionary)optionsDictionary);
            optionsDictionary.close();
            return result;
        }
        avutil.av_dict_free((avutil.AVDictionary)optionsDictionary);
        optionsDictionary.close();
        ret = avformat.avformat_find_stream_info((avformat.AVFormatContext)inputFormatContext, (avutil.AVDictionary)null);
        if (ret < 0) {
            result.setMessage("Could not find stream information\n");
            logger.error(result.getMessage());
            return result;
        }
        this.lastDTS = new long[inputFormatContext.nb_streams()];
        for (int i = 0; i < this.lastDTS.length; ++i) {
            this.lastDTS[i] = -1L;
        }
        result.setSuccess(true);
        return result;
    }

    public Result prepare(avformat.AVFormatContext inputFormatContext) {
        Result result = this.prepareInput(inputFormatContext);
        this.setCameraError(result);
        return result;
    }

    public void startStream() {
        new Thread(){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (StreamFetcher.this.threadActive) {
                        Thread.sleep(100L);
                        if (i % 50 == 0) {
                            logger.info("waiting for thread to be finished for stream {}", (Object)StreamFetcher.this.stream.getStreamUrl());
                            i = 0;
                        }
                        ++i;
                    }
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                    Thread.currentThread().interrupt();
                }
                StreamFetcher.this.exceptionInThread = false;
                StreamFetcher.this.thread = new WorkerThread();
                StreamFetcher.this.thread.start();
                logger.info("StartStream called, new thread is started for {}", (Object)StreamFetcher.this.stream.getStreamId());
            }
        }.start();
    }

    public avcodec.AVPacket getAVPacket() {
        if (!this.availableBufferQueue.isEmpty()) {
            return this.availableBufferQueue.poll();
        }
        return new avcodec.AVPacket();
    }

    public boolean isStreamAlive() {
        return System.currentTimeMillis() - this.lastPacketReceivedTime < 3000L;
    }

    public boolean isStopped() {
        return this.thread.isInterrupted();
    }

    public void stopStream() {
        logger.warn("stop stream called for {}", (Object)this.stream.getStreamId());
        this.stopRequestReceived = true;
    }

    public boolean isStopRequestReceived() {
        return this.stopRequestReceived;
    }

    public WorkerThread getThread() {
        return this.thread;
    }

    public void setThread(WorkerThread thread) {
        this.thread = thread;
    }

    public Broadcast getStream() {
        return this.stream;
    }

    public void restart() {
        this.stopStream();
        new Thread(){

            @Override
            public void run() {
                try {
                    while (StreamFetcher.this.threadActive) {
                        Thread.sleep(100L);
                    }
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                    Thread.currentThread().interrupt();
                }
                StreamFetcher.this.startStream();
            }
        }.start();
    }

    public void setConnectionTimeout(int timeout) {
        this.timeout = timeout * 1000;
    }

    public boolean isExceptionInThread() {
        return this.exceptionInThread;
    }

    public void setThreadActive(boolean threadActive) {
        this.threadActive = threadActive;
    }

    public boolean isThreadActive() {
        return this.threadActive;
    }

    public Result getCameraError() {
        return this.cameraError;
    }

    public void setCameraError(Result cameraError) {
        this.cameraError = cameraError;
    }

    public IScope getScope() {
        return this.scope;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    public AntMediaApplicationAdapter getInstance() {
        if (this.appInstance == null) {
            this.appInstance = ((IApplicationAdaptorFactory)this.scope.getContext().getApplicationContext().getBean("web.handler")).getAppAdaptor();
        }
        return this.appInstance;
    }

    public MuxAdaptor getMuxAdaptor() {
        return this.muxAdaptor;
    }

    public void setMuxAdaptor(MuxAdaptor muxAdaptor) {
        this.muxAdaptor = muxAdaptor;
    }

    public boolean isRestartStream() {
        return this.restartStream;
    }

    public void setRestartStream(boolean restartStream) {
        this.restartStream = restartStream;
    }

    public void setStream(Broadcast stream) {
        this.stream = stream;
    }

    public int getBufferTime() {
        return this.bufferTime;
    }

    public void setBufferTime(int bufferTime) {
        this.bufferTime = bufferTime;
    }

    private AppSettings getAppSettings() {
        if (this.appSettings == null) {
            this.appSettings = (AppSettings)this.scope.getContext().getApplicationContext().getBean("app.settings");
        }
        return this.appSettings;
    }

    public void debugSetStopRequestReceived(boolean stopRequest) {
        this.stopRequestReceived = stopRequest;
    }

    public class WorkerThread
    extends Thread {
        private static final int PACKET_WRITER_PERIOD_IN_MS = 10;
        private static final long STREAM_FETCH_RE_TRY_PERIOD_MS = 3000L;
        private volatile boolean streamPublished = false;
        protected AtomicBoolean isJobRunning = new AtomicBoolean(false);
        avformat.AVFormatContext inputFormatContext = null;
        private volatile boolean buffering = false;
        private ConcurrentLinkedQueue<avcodec.AVPacket> bufferQueue = new ConcurrentLinkedQueue();
        private volatile long bufferingFinishTimeMs;
        private volatile long firstPacketReadyToSentTimeMs;
        private long lastPacketTimeMsInQueue;

        @Override
        public void run() {
            StreamFetcher.this.setThreadActive(true);
            long firstPacketTime = 0L;
            long bufferDuration = 0L;
            long timeOffset = 0L;
            avcodec.AVPacket pkt = null;
            long packetWriterJobName = -1L;
            try {
                this.inputFormatContext = new avformat.AVFormatContext(null);
                pkt = avcodec.av_packet_alloc();
                logger.info("Preparing the StreamFetcher for {}", (Object)StreamFetcher.this.stream.getStreamUrl());
                Result result = StreamFetcher.this.prepare(this.inputFormatContext);
                if (result.isSuccess()) {
                    boolean audioExist = false;
                    boolean videoExist = false;
                    for (int i = 0; i < this.inputFormatContext.nb_streams(); ++i) {
                        if (this.inputFormatContext.streams(i).codecpar().codec_type() == 1) {
                            audioExist = true;
                            continue;
                        }
                        if (this.inputFormatContext.streams(i).codecpar().codec_type() != 0) continue;
                        videoExist = true;
                    }
                    StreamFetcher.this.muxAdaptor = MuxAdaptor.initializeMuxAdaptor(null, (boolean)true, (IScope)StreamFetcher.this.scope);
                    StreamFetcher.this.muxAdaptor.setFirstKeyFrameReceivedChecked(!videoExist);
                    StreamFetcher.this.muxAdaptor.setEnableVideo(videoExist);
                    StreamFetcher.this.muxAdaptor.setEnableAudio(audioExist);
                    this.setUpEndPoints(StreamFetcher.this.stream.getStreamId(), StreamFetcher.this.muxAdaptor);
                    StreamFetcher.this.muxAdaptor.init(StreamFetcher.this.scope, StreamFetcher.this.stream.getStreamId(), false);
                    logger.info("{} stream count in stream {} is {}", new Object[]{StreamFetcher.this.stream.getStreamId(), StreamFetcher.this.stream.getStreamUrl(), this.inputFormatContext.nb_streams()});
                    if (StreamFetcher.this.muxAdaptor.prepareInternal(this.inputFormatContext)) {
                        long currentTime = System.currentTimeMillis();
                        StreamFetcher.this.muxAdaptor.setStartTime(currentTime);
                        StreamFetcher.this.getInstance().startPublish(StreamFetcher.this.stream.getStreamId(), 0L);
                        if (StreamFetcher.this.bufferTime > 0) {
                            packetWriterJobName = StreamFetcher.this.vertx.setPeriodic(10L, l -> StreamFetcher.this.vertx.executeBlocking(h -> {
                                this.writeBufferedPacket();
                                h.complete();
                            }, false, r -> {}));
                        }
                        while (avformat.av_read_frame((avformat.AVFormatContext)this.inputFormatContext, (avcodec.AVPacket)pkt) >= 0) {
                            this.streamPublished = true;
                            StreamFetcher.this.lastPacketReceivedTime = System.currentTimeMillis();
                            int packetIndex = pkt.stream_index();
                            if (StreamFetcher.this.lastDTS[packetIndex] >= pkt.dts()) {
                                logger.info("last dts{} is bigger than incoming dts {}", (Object)pkt.dts(), (Object)StreamFetcher.this.lastDTS[packetIndex]);
                                pkt.dts(StreamFetcher.this.lastDTS[packetIndex] + 1L);
                            }
                            ((StreamFetcher)StreamFetcher.this).lastDTS[packetIndex] = pkt.dts();
                            if (pkt.dts() > pkt.pts()) {
                                logger.info("dts ({}) is bigger than pts({})", (Object)pkt.dts(), (Object)pkt.pts());
                                pkt.pts(pkt.dts());
                            }
                            if (StreamFetcher.this.bufferTime > 0) {
                                avcodec.AVPacket packet = StreamFetcher.this.getAVPacket();
                                avcodec.av_packet_ref((avcodec.AVPacket)packet, (avcodec.AVPacket)pkt);
                                this.bufferQueue.add(packet);
                                avcodec.AVPacket pktHead = this.bufferQueue.peek();
                                if (pktHead != null) {
                                    this.lastPacketTimeMsInQueue = avutil.av_rescale_q((long)pkt.pts(), (avutil.AVRational)this.inputFormatContext.streams(pkt.stream_index()).time_base(), (avutil.AVRational)MuxAdaptor.TIME_BASE_FOR_MS);
                                    firstPacketTime = avutil.av_rescale_q((long)pktHead.pts(), (avutil.AVRational)this.inputFormatContext.streams(pktHead.stream_index()).time_base(), (avutil.AVRational)MuxAdaptor.TIME_BASE_FOR_MS);
                                    bufferDuration = this.lastPacketTimeMsInQueue - firstPacketTime;
                                    if (bufferDuration > (long)StreamFetcher.this.bufferTime) {
                                        if (this.buffering) {
                                            this.bufferingFinishTimeMs = System.currentTimeMillis();
                                            this.firstPacketReadyToSentTimeMs = firstPacketTime;
                                        }
                                        this.buffering = false;
                                    }
                                    this.logBufferStatus();
                                }
                            } else {
                                if (StreamFetcher.this.stream.getType().equals(StreamFetcher.STREAM_TYPE_VOD)) {
                                    if (firstPacketTime == 0L) {
                                        int streamIndex = pkt.stream_index();
                                        firstPacketTime = System.currentTimeMillis();
                                        long firstPacketDtsInMs = avutil.av_rescale_q((long)pkt.dts(), (avutil.AVRational)this.inputFormatContext.streams(streamIndex).time_base(), (avutil.AVRational)MuxAdaptor.TIME_BASE_FOR_MS);
                                        timeOffset = 0L - firstPacketDtsInMs;
                                    }
                                    long latestTime = System.currentTimeMillis();
                                    int streamIndex = pkt.stream_index();
                                    avutil.AVRational timeBase = this.inputFormatContext.streams(streamIndex).time_base();
                                    long pktTime = avutil.av_rescale_q((long)pkt.dts(), (avutil.AVRational)timeBase, (avutil.AVRational)MuxAdaptor.TIME_BASE_FOR_MS);
                                    long durationInMs = latestTime - firstPacketTime;
                                    long dtsInMS = timeOffset + pktTime;
                                    while (dtsInMS > durationInMs) {
                                        durationInMs = System.currentTimeMillis() - firstPacketTime;
                                        Thread.sleep(1L);
                                    }
                                }
                                StreamFetcher.this.muxAdaptor.writePacket(this.inputFormatContext.streams(pkt.stream_index()), pkt);
                            }
                            avcodec.av_packet_unref((avcodec.AVPacket)pkt);
                            if (!StreamFetcher.this.stopRequestReceived) continue;
                            logger.warn("Stop request received, breaking the loop for {} ", (Object)StreamFetcher.this.stream.getStreamId());
                            break;
                        }
                        logger.info("Leaving the stream fetcher loop for stream: {}", (Object)StreamFetcher.this.stream.getStreamId());
                    } else {
                        logger.error("MuxAdaptor.Prepare for {} returned false", (Object)StreamFetcher.this.stream.getName());
                    }
                    StreamFetcher.this.setCameraError(result);
                } else {
                    logger.error("Prepare for opening the {} has failed", (Object)StreamFetcher.this.stream.getStreamUrl());
                }
            }
            catch (Exception | OutOfMemoryError e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                StreamFetcher.this.exceptionInThread = true;
            }
            if (packetWriterJobName != -1L) {
                logger.info("Removing packet writer job {}", (Object)packetWriterJobName);
                StreamFetcher.this.vertx.cancelTimer(packetWriterJobName);
            }
            this.writeAllBufferedPackets();
            if (StreamFetcher.this.muxAdaptor != null) {
                logger.info("Writing trailer in Muxadaptor {}", (Object)StreamFetcher.this.stream.getStreamId());
                StreamFetcher.this.muxAdaptor.writeTrailer();
                StreamFetcher.this.appInstance.muxAdaptorRemoved(StreamFetcher.this.muxAdaptor);
                StreamFetcher.this.muxAdaptor = null;
            }
            if (pkt != null) {
                avcodec.av_packet_free((avcodec.AVPacket)pkt);
                pkt.close();
            }
            if (this.inputFormatContext != null) {
                try {
                    avformat.avformat_close_input((avformat.AVFormatContext)this.inputFormatContext);
                }
                catch (Exception e) {
                    logger.info(e.getMessage());
                }
                this.inputFormatContext = null;
            }
            if (this.streamPublished) {
                StreamFetcher.this.getInstance().closeBroadcast(StreamFetcher.this.stream.getStreamId());
                this.streamPublished = false;
            }
            StreamFetcher.this.setThreadActive(false);
            if (StreamFetcher.this.streamFetcherListener != null) {
                StreamFetcher.this.stopRequestReceived = true;
                StreamFetcher.this.restartStream = false;
                StreamFetcher.this.streamFetcherListener.streamFinished(StreamFetcher.this.streamFetcherListener);
            }
            if (!StreamFetcher.this.stopRequestReceived && StreamFetcher.this.restartStream) {
                logger.info("Stream fetcher will try to fetch source {} after {} ms", (Object)StreamFetcher.this.stream.getStreamUrl(), (Object)3000L);
                StreamFetcher.this.vertx.setTimer(3000L, l -> {
                    StreamFetcher.this.thread = new WorkerThread();
                    StreamFetcher.this.thread.start();
                });
            }
            logger.debug("Leaving thread for {}", (Object)StreamFetcher.this.stream.getStreamUrl());
            StreamFetcher.this.stopRequestReceived = false;
        }

        private void setUpEndPoints(String publishedName, MuxAdaptor muxAdaptor) {
            List endPointList;
            DataStore dataStore = StreamFetcher.this.getInstance().getDataStore();
            Broadcast broadcast = dataStore.get(publishedName);
            if (broadcast != null && (endPointList = broadcast.getEndPointList()) != null && !endPointList.isEmpty()) {
                for (Endpoint endpoint : endPointList) {
                    muxAdaptor.addMuxer((Muxer)new RtmpMuxer(endpoint.getRtmpUrl()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeAllBufferedPackets() {
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                avcodec.AVPacket pkt;
                logger.info("write all buffered packets for stream: {}", (Object)StreamFetcher.this.stream.getStreamId());
                while (!this.bufferQueue.isEmpty()) {
                    pkt = this.bufferQueue.poll();
                    StreamFetcher.this.muxAdaptor.writePacket(this.inputFormatContext.streams(pkt.stream_index()), pkt);
                    avcodec.av_packet_unref((avcodec.AVPacket)pkt);
                }
                while ((pkt = this.bufferQueue.poll()) != null) {
                    pkt.close();
                }
                while ((pkt = (avcodec.AVPacket)StreamFetcher.this.availableBufferQueue.poll()) != null) {
                    pkt.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeBufferedPacket() {
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                if (this.isJobRunning.compareAndSet(false, true)) {
                    if (!this.buffering) {
                        long now;
                        long passedTime;
                        avcodec.AVPacket tempPacket;
                        long pktTime;
                        long pktTimeDifferenceMs;
                        while (!this.bufferQueue.isEmpty() && (pktTimeDifferenceMs = (pktTime = avutil.av_rescale_q((long)(tempPacket = this.bufferQueue.peek()).pts(), (avutil.AVRational)this.inputFormatContext.streams(tempPacket.stream_index()).time_base(), (avutil.AVRational)MuxAdaptor.TIME_BASE_FOR_MS)) - this.firstPacketReadyToSentTimeMs) < (passedTime = (now = System.currentTimeMillis()) - this.bufferingFinishTimeMs)) {
                            StreamFetcher.this.muxAdaptor.writePacket(this.inputFormatContext.streams(tempPacket.stream_index()), tempPacket);
                            avcodec.av_packet_unref((avcodec.AVPacket)tempPacket);
                            this.bufferQueue.remove();
                            StreamFetcher.this.availableBufferQueue.offer(tempPacket);
                        }
                        this.buffering = this.bufferQueue.isEmpty();
                    }
                    this.logBufferStatus();
                    System.out.println("buffer log counter: " + StreamFetcher.this.bufferLogCounter);
                    this.isJobRunning.compareAndSet(true, false);
                }
            }
        }

        public void logBufferStatus() {
            StreamFetcher.this.bufferLogCounter++;
            if (StreamFetcher.this.bufferLogCounter % 500 == 0) {
                logger.info("WriteBufferedPacket -> Buffering status {}, buffer duration {}ms buffer time {}ms stream: {}", new Object[]{this.buffering, this.getBufferedDurationMs(), StreamFetcher.this.bufferTime, StreamFetcher.this.stream.getStreamId()});
                StreamFetcher.this.bufferLogCounter = 0;
            }
        }

        public long getBufferedDurationMs() {
            avcodec.AVPacket pktHead = this.bufferQueue.peek();
            if (pktHead != null) {
                long firstPacketInQueueTime = avutil.av_rescale_q((long)pktHead.pts(), (avutil.AVRational)this.inputFormatContext.streams(pktHead.stream_index()).time_base(), (avutil.AVRational)MuxAdaptor.TIME_BASE_FOR_MS);
                return this.lastPacketTimeMsInQueue - firstPacketInQueueTime;
            }
            return 0L;
        }
    }

    public static interface IStreamFetcherListener {
        public void streamFinished(IStreamFetcherListener var1);
    }
}

