/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.streamsource;

import io.antmedia.AppSettings;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Playlist;
import io.antmedia.rest.model.Result;
import io.antmedia.streamsource.StreamFetcher;
import io.vertx.core.Vertx;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.tika.utils.ExceptionUtils;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFetcherManager {
    protected static Logger logger = LoggerFactory.getLogger(StreamFetcherManager.class);
    private int streamCheckerCount = 0;
    private Queue<StreamFetcher> streamFetcherList = new ConcurrentLinkedQueue<StreamFetcher>();
    private int streamCheckerIntervalMs = 10000;
    private DataStore datastore;
    private IScope scope;
    private long streamFetcherScheduleJobName = -1L;
    protected AtomicBoolean isJobRunning = new AtomicBoolean(false);
    private boolean restartStreamAutomatically = true;
    private Vertx vertx;
    private int lastRestartCount;
    private AppSettings appSettings;

    public StreamFetcherManager(Vertx vertx, DataStore datastore, IScope scope) {
        this.vertx = vertx;
        this.datastore = datastore;
        this.scope = scope;
        this.appSettings = (AppSettings)scope.getContext().getBean("app.settings");
    }

    public StreamFetcher make(Broadcast stream, IScope scope, Vertx vertx) {
        return new StreamFetcher(stream, scope, vertx);
    }

    public int getStreamCheckerInterval() {
        return this.streamCheckerIntervalMs;
    }

    public void setStreamCheckerInterval(int streamCheckerInterval) {
        this.streamCheckerIntervalMs = streamCheckerInterval;
    }

    public boolean checkAlreadyFetch(Broadcast broadcast) {
        boolean alreadyFetching = false;
        for (StreamFetcher streamFetcher : this.streamFetcherList) {
            if (!streamFetcher.getStream().getStreamId().equals(broadcast.getStreamId())) continue;
            alreadyFetching = true;
            break;
        }
        return alreadyFetching;
    }

    public void alreadyFetchProcess(StreamFetcher streamScheduler) {
        streamScheduler.startStream();
        if (!this.streamFetcherList.contains(streamScheduler)) {
            this.streamFetcherList.add(streamScheduler);
        }
        if (this.streamFetcherScheduleJobName == -1L) {
            this.scheduleStreamFetcherJob();
        }
    }

    public StreamFetcher startStreaming(@Nonnull Broadcast broadcast) {
        boolean alreadyFetching = this.checkAlreadyFetch(broadcast);
        StreamFetcher streamScheduler = null;
        if (!alreadyFetching) {
            try {
                streamScheduler = this.make(broadcast, this.scope, this.vertx);
                streamScheduler.setRestartStream(this.restartStreamAutomatically);
                this.alreadyFetchProcess(streamScheduler);
            }
            catch (Exception e) {
                streamScheduler = null;
                logger.error(e.getMessage());
            }
        }
        return streamScheduler;
    }

    public StreamFetcher playlistStartStreaming(@Nonnull Broadcast broadcast, StreamFetcher streamScheduler) {
        boolean alreadyFetching = false;
        alreadyFetching = this.checkAlreadyFetch(broadcast);
        if (!alreadyFetching) {
            try {
                streamScheduler.setRestartStream(false);
                this.alreadyFetchProcess(streamScheduler);
            }
            catch (Exception e) {
                streamScheduler = null;
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return streamScheduler;
    }

    public Result stopStreaming(Broadcast stream) {
        logger.warn("inside of stopStreaming for {}", (Object)stream.getStreamId());
        Result result = new Result(false);
        for (StreamFetcher scheduler : this.streamFetcherList) {
            if (!scheduler.getStream().getStreamId().equals(stream.getStreamId())) continue;
            scheduler.stopStream();
            this.streamFetcherList.remove(scheduler);
            result.setSuccess(true);
            break;
        }
        return result;
    }

    public void stopCheckerJob() {
        if (this.streamFetcherScheduleJobName != -1L) {
            this.vertx.cancelTimer(this.streamFetcherScheduleJobName);
            this.streamFetcherScheduleJobName = -1L;
        }
    }

    public static Result checkStreamUrlWithHTTP(String url) {
        Result result = new Result(false);
        try {
            URL checkUrl = new URL(url);
            HttpURLConnection huc = (HttpURLConnection)checkUrl.openConnection();
            int responseCode = huc.getResponseCode();
            if (responseCode >= 200 && responseCode < 301) {
                result.setSuccess(true);
                return result;
            }
            result.setSuccess(false);
            return result;
        }
        catch (IOException e) {
            result.setSuccess(false);
            return result;
        }
    }

    public void startPlaylistThread(Playlist playlist) {
        Broadcast playlistBroadcastItem = (Broadcast)playlist.getBroadcastItemList().get(playlist.getCurrentPlayIndex());
        if (StreamFetcherManager.checkStreamUrlWithHTTP(playlistBroadcastItem.getStreamUrl()).isSuccess()) {
            StreamFetcher streamScheduler = new StreamFetcher(playlistBroadcastItem, this.scope, this.vertx);
            playlist.setPlaylistStatus("broadcasting");
            ((Broadcast)playlist.getBroadcastItemList().get(playlist.getCurrentPlayIndex())).setStatus("broadcasting");
            this.datastore.editPlaylist(playlist.getPlaylistId(), playlist);
            streamScheduler.setStreamFetcherListener(listener -> {
                this.stopStreaming(playlistBroadcastItem);
                Playlist newPlaylist = this.datastore.getPlaylist(playlistBroadcastItem.getStreamId());
                if (newPlaylist.getPlaylistStatus().equals("broadcasting") && newPlaylist.getPlaylistId() != null) {
                    newPlaylist = this.skipNextPlaylistQueue(newPlaylist);
                    int currentStreamIndex = newPlaylist.getCurrentPlayIndex();
                    if (StreamFetcherManager.checkStreamUrlWithHTTP(((Broadcast)newPlaylist.getBroadcastItemList().get(currentStreamIndex)).getStreamUrl()).isSuccess()) {
                        Broadcast fetchedBroadcast = (Broadcast)newPlaylist.getBroadcastItemList().get(currentStreamIndex);
                        Result result = new Result(false);
                        result.setSuccess(this.datastore.updateBroadcastFields(fetchedBroadcast.getStreamId(), fetchedBroadcast));
                        StreamFetcher newStreamScheduler = new StreamFetcher(fetchedBroadcast, this.scope, this.vertx);
                        newStreamScheduler.setStreamFetcherListener(listener);
                        this.playlistStartStreaming(playlistBroadcastItem, newStreamScheduler);
                    } else {
                        logger.info("Current Playlist Stream URL -> {} is invalid", (Object)((Broadcast)newPlaylist.getBroadcastItemList().get(currentStreamIndex)).getStreamUrl());
                        newPlaylist = this.skipNextPlaylistQueue(newPlaylist);
                        this.startPlaylistThread(newPlaylist);
                    }
                }
            });
            this.playlistStartStreaming(playlistBroadcastItem, streamScheduler);
        } else {
            logger.warn("Current Playlist Stream URL -> {} is invalid", (Object)playlistBroadcastItem.getStreamUrl());
            playlist = this.skipNextPlaylistQueue(playlist);
            if (StreamFetcherManager.checkStreamUrlWithHTTP(((Broadcast)playlist.getBroadcastItemList().get(playlist.getCurrentPlayIndex())).getStreamUrl()).isSuccess()) {
                this.startPlaylistThread(playlist);
            } else {
                playlist.setPlaylistStatus("finished");
                this.datastore.editPlaylist(playlist.getPlaylistId(), playlist);
            }
        }
    }

    public Playlist skipNextPlaylistQueue(Playlist playlist) {
        int currentStreamIndex = playlist.getCurrentPlayIndex() + 1;
        if (playlist.getBroadcastItemList().size() <= currentStreamIndex) {
            playlist.setCurrentPlayIndex(0);
            this.datastore.editPlaylist(playlist.getPlaylistId(), playlist);
        } else {
            playlist.setCurrentPlayIndex(currentStreamIndex);
            this.datastore.editPlaylist(playlist.getPlaylistId(), playlist);
        }
        return playlist;
    }

    public void startStreams(List<Broadcast> streams) {
        for (int i = 0; i < streams.size(); ++i) {
            this.startStreaming(streams.get(i));
        }
        this.scheduleStreamFetcherJob();
    }

    private void scheduleStreamFetcherJob() {
        if (this.streamFetcherScheduleJobName != -1L) {
            this.vertx.cancelTimer(this.streamFetcherScheduleJobName);
        }
        this.streamFetcherScheduleJobName = this.vertx.setPeriodic((long)this.streamCheckerIntervalMs, l -> {
            if (!this.streamFetcherList.isEmpty()) {
                ++this.streamCheckerCount;
                logger.debug("StreamFetcher Check Count:{}", (Object)this.streamCheckerCount);
                int countToRestart = 0;
                int restartStreamFetcherPeriodSeconds = this.appSettings.getRestartStreamFetcherPeriod();
                if (restartStreamFetcherPeriodSeconds > 0) {
                    int streamCheckIntervalSec = this.streamCheckerIntervalMs / 1000;
                    countToRestart = this.streamCheckerCount * streamCheckIntervalSec / restartStreamFetcherPeriodSeconds;
                }
                if (countToRestart > this.lastRestartCount) {
                    this.lastRestartCount = countToRestart;
                    logger.info("This is {} times that restarting streams", (Object)this.lastRestartCount);
                    this.restartStreamFetchers();
                } else {
                    this.checkStreamFetchersStatus();
                }
            }
        });
        logger.info("StreamFetcherSchedule job name {}", (Object)this.streamFetcherScheduleJobName);
    }

    public void checkStreamFetchersStatus() {
        for (StreamFetcher streamScheduler : this.streamFetcherList) {
            Broadcast stream = streamScheduler.getStream();
            if (streamScheduler.isStreamAlive() || this.datastore == null || stream.getStreamId() == null) continue;
            logger.info("Stream is not alive and setting quality to poor of stream: {} url: {}", (Object)stream.getStreamId(), (Object)stream.getStreamUrl());
            this.datastore.updateSourceQualityParameters(stream.getStreamId(), null, 0.0, 0);
        }
    }

    public void restartStreamFetchers() {
        for (StreamFetcher streamScheduler : this.streamFetcherList) {
            if (streamScheduler.isStreamAlive()) {
                logger.info("Calling stop stream {}", (Object)streamScheduler.getStream().getStreamId());
                streamScheduler.stopStream();
            } else {
                logger.info("Stream is not alive {}", (Object)streamScheduler.getStream().getStreamId());
            }
            streamScheduler.startStream();
        }
    }

    public DataStore getDatastore() {
        return this.datastore;
    }

    public void setDatastore(DataStore datastore) {
        this.datastore = datastore;
    }

    public Queue<StreamFetcher> getStreamFetcherList() {
        return this.streamFetcherList;
    }

    public void setStreamFetcherList(Queue<StreamFetcher> streamFetcherList) {
        this.streamFetcherList = streamFetcherList;
    }

    public boolean isRestartStreamAutomatically() {
        return this.restartStreamAutomatically;
    }

    public void setRestartStreamAutomatically(boolean restartStreamAutomatically) {
        this.restartStreamAutomatically = restartStreamAutomatically;
    }

    public int getStreamCheckerCount() {
        return this.streamCheckerCount;
    }

    public void setStreamCheckerCount(int streamCheckerCount) {
        this.streamCheckerCount = streamCheckerCount;
    }
}

