/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.rest.RestServiceBase;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import org.bytedeco.javacpp.avformat;
import org.bytedeco.javacpp.avutil;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.Red5;
import org.slf4j.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class Launcher {
    public static final String RED5_ROOT = "red5.root";
    private static Logger logger;
    private static String instanceId;
    private static final String INSTANCE_ID_DEFAULT_PATH = "conf/instanceId";
    private static String instanceIdFilePath;
    private static String implementationVersion;
    private static String versionType;

    public void launch() {
        avformat.av_register_all();
        avformat.avformat_network_init();
        avutil.av_log_set_level((int)16);
        boolean useLogback = Boolean.parseBoolean(System.getProperty("useLogback", "true"));
        if (useLogback && System.getProperty("logback.ContextSelector") == null) {
            System.setProperty("logback.ContextSelector", "org.red5.logging.LoggingContextSelector");
        }
        Red5LoggerFactory.setUseLogback((boolean)useLogback);
        SLF4JBridgeHandler.install();
        Logger log = Red5LoggerFactory.getLogger(Launcher.class);
        Launcher.setLog(log);
        log.info("Ant Media Server {} {}", (Object)Launcher.getVersionType(), (Object)Launcher.getVersion());
        this.printLogo();
        if (log.isDebugEnabled()) {
            log.debug("fmsVer: {}", (Object)Red5.getFMSVersion());
        }
        FileSystemXmlApplicationContext root = new FileSystemXmlApplicationContext(new String[]{"classpath:/red5.xml"}, false);
        root.setClassLoader(Thread.currentThread().getContextClassLoader());
        root.setId(RED5_ROOT);
        root.setBeanName(RED5_ROOT);
        log.trace("Refreshing root server context");
        root.refresh();
        log.trace("Root server context refreshed");
        log.debug("Launcher exit");
    }

    public void printLogo() {
        logger.info("\n {}", (Object)"\u001b[31m             `..-:/++oosssyyyyyyyysssoo++/::..`             \n        .:+osyyyyysooo++///::::::///++ooosyyyyyso+:.        \n     -+syyso/:-.`         ```````          `.-:/osyyy+-     \n   .oyyo:.    ``.-:/+oossyyyyyys:`.+o+: `..`      `-+yys.   \n   oyy-   `.-:://:::::///++ooo-`-oyo:../sys/`.::.    .yys   \n   syy+`                       `.-. -oys/..:oys+:`   :yyy   \n   syyyo-`                           `. `+so/.`   `-oyyyy   \n   syy+sys+:.`                           ``   `.:+syyoyyy   \n   syy``:+syyso`       `..`                 `osyyso:. syy   \n   syy`   `.oyy.      :syyso:.`             `yys.`    syy   \n   syy`     +yy.      syy:+syys+-`          `yyo      syy   \n   syy`     +yy.      yyy  `.:osyso/.`      `yyo      syy   \n   syy`     +yy.      yyy      `-/syys+.    `yyo      syy   \n   syy`     +yy.      yyy         `./yyy    `yyo      syy   \n   syy`     +yy.      yyy       `./oyys/    `yyo      syy   \n   syy`     +yy.      yyy    .:+syyo/-`     `yyo      syy   \n   syy`     +yy.      yyy`-/syys+:.         `yyo      syy   \n   syy`     +yy.      +yyyyyo/.`            `yyo      yyy   \n   /yy/     +yy.       -::-`                `yyo     :yy+   \n    +yyo:.  +yy.                            `yyo  .-oyy+`   \n     .+yyyysyyy.                            `yyysyyyy+-     \n        .:/+++/                              :+//:-.        \n\u001b[0m\n");
    }

    public static void writeToFile(String absolutePath, String content) {
        block2: {
            try {
                Files.write(new File(absolutePath).toPath(), content.getBytes(), StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                if (logger == null) break block2;
                logger.error(e.toString());
            }
        }
    }

    public static String getFileContent(String path) {
        try {
            byte[] data = Files.readAllBytes(new File(path).toPath());
            return new String(data);
        }
        catch (IOException e) {
            logger.error(e.toString());
            return null;
        }
    }

    public static String getInstanceId() {
        if (instanceId == null) {
            File idFile = new File(instanceIdFilePath);
            if (idFile.exists()) {
                instanceId = Launcher.getFileContent(idFile.getAbsolutePath());
            } else {
                instanceId = UUID.randomUUID().toString();
                Launcher.writeToFile(idFile.getAbsolutePath(), instanceId);
            }
        }
        return instanceId;
    }

    public static void setLog(Logger log) {
        logger = log;
    }

    public static void setInstanceIdFilePath(String instanceIdFilePath) {
        Launcher.instanceIdFilePath = instanceIdFilePath;
    }

    public static String getVersion() {
        if (implementationVersion == null) {
            implementationVersion = AntMediaApplicationAdapter.class.getPackage().getImplementationVersion();
        }
        return implementationVersion;
    }

    public static String getVersionType() {
        if (versionType == null) {
            versionType = RestServiceBase.isEnterprise() ? "Enterprise" : "Community";
        }
        return versionType;
    }

    static {
        instanceId = null;
        instanceIdFilePath = INSTANCE_ID_DEFAULT_PATH;
        versionType = null;
    }
}

