/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import javax.management.MBeanServer;
import org.bytedeco.javacpp.Pointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtils {
    public static final String HEAPDUMP_HPROF = "heapdump.hprof";
    public static final String osName = System.getProperty("os.name");
    public static final String osArch = System.getProperty("os.arch");
    public static final String jvmVersion = System.getProperty("java.specification.version");
    public static final int osProcessorX = Runtime.getRuntime().availableProcessors();
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static HotSpotDiagnosticMXBean hotspotMBean;
    protected static final Logger logger;
    public static final int MAC_OS_X = 0;
    public static final int LINUX = 1;
    public static final int WINDOWS = 2;
    public static final int OS_TYPE;

    public static long jvmMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    public static long jvmTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long jvmFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long jvmInUseMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static long osCommittedVirtualMemory() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        if (osBean instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)osBean).getCommittedVirtualMemorySize();
        }
        try {
            Method m = osBean.getClass().getDeclaredMethod("getCommittedVirtualMemorySize", new Class[0]);
            m.setAccessible(true);
            return (Long)m.invoke((Object)osBean, new Object[0]);
        }
        catch (Exception e) {
            SystemUtils.error(e);
            return -1L;
        }
    }

    public static long osTotalPhysicalMemory() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        if (osBean instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)osBean).getTotalPhysicalMemorySize();
        }
        try {
            Method m = osBean.getClass().getDeclaredMethod("getTotalPhysicalMemorySize", new Class[0]);
            m.setAccessible(true);
            return (Long)m.invoke((Object)osBean, new Object[0]);
        }
        catch (Exception e) {
            SystemUtils.error(e);
            return -1L;
        }
    }

    public static long osFreePhysicalMemory() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        if (osBean instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)osBean).getFreePhysicalMemorySize();
        }
        try {
            Method m = osBean.getClass().getDeclaredMethod("getFreePhysicalMemorySize", new Class[0]);
            m.setAccessible(true);
            return (Long)m.invoke((Object)osBean, new Object[0]);
        }
        catch (Exception e) {
            SystemUtils.error(e);
            return -1L;
        }
    }

    public static long osAvailableMemory() {
        return Pointer.availablePhysicalBytes();
    }

    public static long osInUsePhysicalMemory() {
        return SystemUtils.osTotalPhysicalMemory() - SystemUtils.osFreePhysicalMemory();
    }

    public static long osTotalSwapSpace() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        if (osBean instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)osBean).getTotalSwapSpaceSize();
        }
        try {
            Method m = osBean.getClass().getDeclaredMethod("getTotalSwapSpaceSize", new Class[0]);
            m.setAccessible(true);
            return (Long)m.invoke((Object)osBean, new Object[0]);
        }
        catch (Exception e) {
            SystemUtils.error(e);
            return -1L;
        }
    }

    public static long osFreeSwapSpace() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        if (osBean instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)osBean).getFreeSwapSpaceSize();
        }
        try {
            Method m = osBean.getClass().getDeclaredMethod("getFreeSwapSpaceSize", new Class[0]);
            m.setAccessible(true);
            return (Long)m.invoke((Object)osBean, new Object[0]);
        }
        catch (Exception e) {
            SystemUtils.error(e);
            return -1L;
        }
    }

    public static long osInUseSwapSpace() {
        return SystemUtils.osTotalSwapSpace() - SystemUtils.osFreeSwapSpace();
    }

    public static long osHDUsableSpace(String path) {
        File f;
        if (path == null) {
            path = File.listRoots()[0].getPath();
        }
        if ((f = new File(path)).getTotalSpace() != 0L) {
            return f.getUsableSpace();
        }
        SystemUtils.error(0, f.getPath());
        return -1L;
    }

    public static long osHDTotalSpace(String path) {
        File f;
        if (path == null) {
            path = File.listRoots()[0].getPath();
        }
        if ((f = new File(path)).getTotalSpace() != 0L) {
            return f.getTotalSpace();
        }
        SystemUtils.error(0, f.getPath());
        return -1L;
    }

    public static long osHDFreeSpace(String path) {
        File f;
        if (path == null) {
            path = File.listRoots()[0].getPath();
        }
        if ((f = new File(path)).getTotalSpace() != 0L) {
            return f.getFreeSpace();
        }
        SystemUtils.error(0, f.getPath());
        return -1L;
    }

    public static long osHDInUseSpace(String path) {
        File f;
        if (path == null) {
            path = File.listRoots()[0].getPath();
        }
        if ((f = new File(path)).getTotalSpace() == 0L) {
            SystemUtils.error(0, f.getPath());
            return -1L;
        }
        return f.getTotalSpace() - f.getFreeSpace();
    }

    public static String convertByteSize(Long bytes, String size, boolean txtByte) {
        return SystemUtils.convertByteSize(bytes, size, txtByte, false);
    }

    public static String convertByteSizeToDisk(Long bytes, String size, boolean txtByte) {
        return SystemUtils.convertByteSize(bytes, size, txtByte, true);
    }

    public static long convertByteSize(long bytes, String size) {
        Long num = 1024L;
        long convertB = (size = size.toUpperCase()).equals("PB") ? bytes / (num * num * num * num * num) : (size.equals("TB") ? bytes / (num * num * num * num) : (size.equals("GB") ? bytes / (num * num * num) : (size.equals("MB") ? bytes / (num * num) : (size.equals("KB") ? bytes / num : bytes))));
        return convertB;
    }

    public static String convertByteSize(Long bytes, String size, Boolean txtByte, boolean isDisk) {
        String convertB = null;
        if (bytes != null) {
            if (size != null) {
                size = size.toUpperCase();
            }
            if (txtByte == null) {
                txtByte = true;
            }
            Long num = 1024L;
            if (isDisk) {
                num = 1000L;
            }
            if (size == null || size.equals("AUTO")) {
                if (bytes > num * num * num * num * num) {
                    convertB = "" + bytes / (num * num * num * num * num);
                    size = "PB";
                } else if (bytes > num * num * num * num) {
                    convertB = "" + bytes / (num * num * num * num);
                    size = "TB";
                } else if (bytes > num * num * num) {
                    convertB = "" + bytes / (num * num * num);
                    size = "GB";
                } else if (bytes > num * num) {
                    convertB = "" + bytes / (num * num);
                    size = "MB";
                } else if (bytes > num) {
                    convertB = "" + bytes / num;
                    size = "KB";
                } else {
                    convertB = "" + bytes;
                    size = "B";
                }
            } else {
                convertB = size.equals("PB") ? "" + bytes / (num * num * num * num * num) : (size.equals("TB") ? "" + bytes / (num * num * num * num) : (size.equals("GB") ? "" + bytes / (num * num * num) : (size.equals("MB") ? "" + bytes / (num * num) : (size.equals("KB") ? "" + bytes / num : "" + bytes))));
            }
            if (txtByte.booleanValue()) {
                convertB = size.equals("PB") ? convertB + "PB" : (size.equals("TB") ? convertB + "TB" : (size.equals("GB") ? convertB + "GB" : (size.equals("MB") ? convertB + "MB" : (size.equals("KB") ? convertB + "KB" : convertB + "B"))));
            }
        }
        return convertB;
    }

    protected static void error(Exception e) {
        String preError = "SystemUtils: ";
        System.out.println(preError + e);
    }

    protected static void error(int error, String info) {
        String preError = "SystemUtils: ";
        if (error == 0) {
            System.out.println(preError + "Harddrive: " + info + ", doesn't appears to exist!");
        } else if (error == 1) {
            System.out.println(preError + "Your current JVM Version is " + info + ", this function required 1.6 or above!");
        } else {
            System.out.println(preError + "Unknown error #" + error);
        }
    }

    public static Integer getSystemCpuLoad() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        if (osBean instanceof UnixOperatingSystemMXBean) {
            return (int)(((UnixOperatingSystemMXBean)osBean).getSystemCpuLoad() * 100.0);
        }
        try {
            Method m = osBean.getClass().getDeclaredMethod("getSystemCpuLoad", new Class[0]);
            m.setAccessible(true);
            return (int)((Double)m.invoke((Object)osBean, new Object[0]) * 100.0);
        }
        catch (Exception e) {
            SystemUtils.error(e);
            return -1;
        }
    }

    public static double getSystemLoadAverageLastMinute() {
        return ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
    }

    public static Integer getProcessCpuLoad() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        if (osBean instanceof UnixOperatingSystemMXBean) {
            return (int)(((UnixOperatingSystemMXBean)osBean).getProcessCpuLoad() * 100.0);
        }
        try {
            Method m = osBean.getClass().getDeclaredMethod("getProcessCpuLoad", new Class[0]);
            m.setAccessible(true);
            return (int)((Double)m.invoke((Object)osBean, new Object[0]) * 100.0);
        }
        catch (Exception e) {
            SystemUtils.error(e);
            return -1;
        }
    }

    public static Long getProcessCpuTime() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        if (osBean instanceof UnixOperatingSystemMXBean) {
            return ((UnixOperatingSystemMXBean)osBean).getProcessCpuTime() / 1000L;
        }
        try {
            Method m = osBean.getClass().getDeclaredMethod("getProcessCpuTime", new Class[0]);
            m.setAccessible(true);
            return (Long)m.invoke((Object)osBean, new Object[0]) / 1000L;
        }
        catch (Exception e) {
            SystemUtils.error(e);
            return -1L;
        }
    }

    public static void getHeapDump(String filepath) {
        try {
            SystemUtils.getHotspotMBean().dumpHeap(filepath, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HotSpotDiagnosticMXBean getHotspotMBean() {
        try {
            Class<SystemUtils> clazz = SystemUtils.class;
            synchronized (SystemUtils.class) {
                if (hotspotMBean == null) {
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
        {
            return hotspotMBean;
        }
    }

    static {
        logger = LoggerFactory.getLogger(SystemUtils.class);
        String osName = SystemUtils.osName.toLowerCase();
        OS_TYPE = osName.startsWith("mac os x") || osName.startsWith("darwin") ? 0 : (osName.startsWith("windows") ? 2 : (osName.startsWith("linux") ? 1 : -1));
    }
}

