/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.component;

import java.beans.PropertyEditorSupport;
import java.util.HashMap;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AppConfig {
    public static final String INTERNAL_APP_CONFIG_LOCATION = "WEB-INF/application.xml";

    @Bean
    public static CustomEditorConfigurer customEditorConfigurer() {
        CustomEditorConfigurer configurer = new CustomEditorConfigurer();
        HashMap<Class<JSONObject>, Class<JSONObjectEditor>> customEditors = new HashMap<Class<JSONObject>, Class<JSONObjectEditor>>();
        customEditors.put(JSONObject.class, JSONObjectEditor.class);
        configurer.setCustomEditors(customEditors);
        return configurer;
    }

    public static class JSONObjectEditor
    extends PropertyEditorSupport {
        Logger logger = LoggerFactory.getLogger(JSONObjectEditor.class);

        @Override
        public void setAsText(String text) {
            JSONParser parser = new JSONParser();
            try {
                JSONObject jsonObject = (JSONObject)parser.parse(text);
                this.setValue(jsonObject);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Could not parse JSON string", e);
            }
        }
    }
}

