/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.datastore;

import com.google.gson.Gson;
import io.antmedia.console.datastore.AbstractConsoleDataStore;
import io.antmedia.datastore.db.types.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapBasedDataStore
extends AbstractConsoleDataStore {
    protected Map<String, String> userMap;
    protected Gson gson = new Gson();
    protected volatile boolean available = true;
    protected static Logger logger = LoggerFactory.getLogger(MapBasedDataStore.class);

    protected MapBasedDataStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addUser(User user) {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            boolean result = false;
            try {
                if (!this.userMap.containsKey(user.getEmail())) {
                    this.userMap.put(user.getEmail(), this.gson.toJson((Object)user));
                    result = true;
                } else {
                    logger.warn("user with {} already exist", (Object)user.getEmail());
                }
            }
            catch (Exception e) {
                logger.error("Add user error:{} trace:{}", (Object)user.getEmail(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
                result = false;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean editUser(User user) {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            boolean result = false;
            try {
                String username = user.getEmail();
                if (this.userMap.containsKey(username)) {
                    this.userMap.put(username, this.gson.toJson((Object)user));
                    result = true;
                }
            }
            catch (Exception e) {
                logger.error("Edit user error:{} trace:{}", (Object)user.getEmail(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
                result = false;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteUser(String username) {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            boolean result = false;
            if (username != null) {
                try {
                    if (this.userMap.containsKey(username)) {
                        this.userMap.remove(username);
                        result = true;
                    }
                }
                catch (Exception e) {
                    logger.error("Delete user error:{} trace:{}", (Object)username, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    result = false;
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesUsernameExist(String username) {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            return this.userMap.containsKey(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesUserExist(String username, String password) {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            boolean result = false;
            if (username != null && password != null) {
                try {
                    String value;
                    User user;
                    if (this.userMap.containsKey(username) && (user = (User)this.gson.fromJson(value = this.userMap.get(username), User.class)).getPassword().equals(password)) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    logger.error("Does not exist user error:{} trace:{}", (Object)username, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<User> getUserList() {
        ArrayList<User> list = new ArrayList<User>();
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            Collection<String> users = this.userMap.values();
            for (String userString : users) {
                User user = (User)this.gson.fromJson(userString, User.class);
                list.add(user);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUser(String username) {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            if (username != null) {
                try {
                    String user = this.userMap.get(username);
                    return (User)this.gson.fromJson(user, User.class);
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfUserRecords() {
        MapBasedDataStore mapBasedDataStore = this;
        synchronized (mapBasedDataStore) {
            return this.userMap.size();
        }
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }
}

