/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.console.servlet;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.console.AdminApplication;
import io.antmedia.filter.JWTFilter;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class WarDownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = -5206403831475536456L;
    private static final Logger logger = LoggerFactory.getLogger(WarDownloadServlet.class);

    public WebApplicationContext getContext(HttpServletRequest req) {
        return (WebApplicationContext)req.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
    }

    public AdminApplication getApplication(HttpServletRequest req) {
        WebApplicationContext ctxt = this.getContext(req);
        if (ctxt != null) {
            return (AdminApplication)ctxt.getBean("web.handler");
        }
        return null;
    }

    public AntMediaApplicationAdapter getAppAdaptor(String appName, HttpServletRequest req) {
        ApplicationContext context;
        AntMediaApplicationAdapter appAdaptor = null;
        AdminApplication application = this.getApplication(req);
        if (application != null && (context = application.getApplicationContext(appName)) != null) {
            appAdaptor = (AntMediaApplicationAdapter)context.getBean("web.handler");
        }
        return appAdaptor;
    }

    public void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestURI = request.getRequestURI().replaceAll("[\n|\r|\t]", "_");
        String appName = requestURI.substring(requestURI.lastIndexOf("/") + 1, requestURI.lastIndexOf("."));
        File warFileInTmpDirectory = AdminApplication.getWarFileInTmpDirectory(AdminApplication.getWarName(appName));
        if (warFileInTmpDirectory == null) {
            logger.info("No such war file in the tmp directory for app: {} ", (Object)appName);
            this.sendError(response, 404, "No such war file in the tmp directory");
            return;
        }
        AntMediaApplicationAdapter appAdaptor = this.getAppAdaptor(appName, request);
        if (appAdaptor == null) {
            logger.info("No such application: {} installed on this instance while trying to download ", (Object)appName, (Object)requestURI);
            this.sendError(response, 400, "No such application");
            return;
        }
        response.setContentLength((int)warFileInTmpDirectory.length());
        response.setStatus(200);
    }

    public void sendError(HttpServletResponse response, int status, String message) {
        try {
            response.sendError(status, message);
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String requestURI = request.getRequestURI().replaceAll("[\n|\r|\t]", "_");
        String token = request.getHeader("ClusterAuthorization");
        if (StringUtils.isEmpty((CharSequence)token)) {
            logger.info("Token parameter is missing while accessing to the resource {}", (Object)requestURI);
            this.sendError(response, 400, "Token parameter is missing");
            return;
        }
        String appName = requestURI.substring(requestURI.lastIndexOf("/") + 1, requestURI.lastIndexOf("."));
        AntMediaApplicationAdapter appAdaptor = this.getAppAdaptor(appName, request);
        if (appAdaptor == null) {
            logger.info("No such application: {} installed on this instance while trying to download ", (Object)appName, (Object)requestURI);
            this.sendError(response, 400, "No such application");
            return;
        }
        String jwtSecretKey = appAdaptor.getAppSettings().getClusterCommunicationKey();
        boolean jwtTokenValid = JWTFilter.isJWTTokenValid(jwtSecretKey, token);
        if (!jwtTokenValid) {
            logger.info("Token is not valid while trying to download {}", (Object)requestURI);
            this.sendError(response, 401, "Token is not valid");
            return;
        }
        File warFileInTmpDirectory = AdminApplication.getWarFileInTmpDirectory(AdminApplication.getWarName(appName));
        if (warFileInTmpDirectory == null) {
            logger.info("No such war file in the tmp directory for app: {} ", (Object)appName);
            this.sendError(response, 400, "No such war file in the tmp directory");
            return;
        }
        response.setContentType("application/octet-stream");
        response.setContentLength((int)warFileInTmpDirectory.length());
        response.setHeader("Content-Disposition", "attachment; filename=" + warFileInTmpDirectory.getName());
        response.setStatus(200);
        try (FileInputStream fileInputStream = new FileInputStream(warFileInTmpDirectory);){
            byte[] buffer = new byte[1024];
            int bytesRead = -1;
            while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                response.getOutputStream().write(buffer, 0, bytesRead);
            }
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            this.sendError(response, 500, "Error while reading the file");
        }
    }
}

