/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import io.antmedia.datastore.db.MapBasedDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.StreamInfo;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBStore
extends MapBasedDataStore {
    private DB db;
    private Vertx vertx;
    private long timerId;
    private AtomicBoolean committing = new AtomicBoolean(false);
    protected static Logger logger = LoggerFactory.getLogger(MapDBStore.class);
    private static final String MAP_NAME = "BROADCAST";
    private static final String VOD_MAP_NAME = "VOD";
    private static final String DETECTION_MAP_NAME = "DETECTION";
    private static final String TOKEN = "TOKEN";
    private static final String SUBSCRIBER = "SUBSCRIBER";
    private static final String CONFERENCE_ROOM_MAP_NAME = "CONFERENCE_ROOM";
    private static final String WEBRTC_VIEWER = "WEBRTC_VIEWER";
    private static final String SUBSCRIBER_METADATA = "SUBSCRIBER_METADATA";

    public MapDBStore(String dbName, Vertx vertx) {
        super(dbName);
        this.vertx = vertx;
        this.db = DBMaker.fileDB((String)dbName).fileMmapEnableIfSupported().checksumHeaderBypass().make();
        this.map = this.db.treeMap(MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.vodMap = this.db.treeMap(VOD_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.detectionMap = this.db.treeMap(DETECTION_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.tokenMap = this.db.treeMap(TOKEN).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.subscriberMap = this.db.treeMap(SUBSCRIBER).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.conferenceRoomMap = this.db.treeMap(CONFERENCE_ROOM_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.webRTCViewerMap = this.db.treeMap(WEBRTC_VIEWER).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.subscriberMetadataMap = this.db.treeMap(SUBSCRIBER_METADATA).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.timerId = vertx.setPeriodic(5000L, id -> vertx.executeBlocking(() -> {
            if (this.committing.compareAndSet(false, true)) {
                try {
                    MapDBStore mapDBStore = this;
                    synchronized (mapDBStore) {
                        if (this.available) {
                            this.db.commit();
                        }
                    }
                }
                finally {
                    this.committing.compareAndSet(true, false);
                }
            }
            return null;
        }, false));
        this.available = true;
        this.migrateConferenceRoomsToBroadcasts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean deleteDB) {
        Iterable dbFiles = this.db.getStore().getAllFiles();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            this.vertx.cancelTimer(this.timerId);
            this.db.commit();
            this.available = false;
            this.db.close();
        }
        if (deleteDB) {
            for (String fileName : dbFiles) {
                File file = new File(fileName);
                if (!file.exists()) continue;
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    @Override
    public long getLocalLiveBroadcastCount(String hostAddress) {
        return this.getActiveBroadcastCount();
    }

    @Override
    public List<Broadcast> getLocalLiveBroadcasts(String hostAddress) {
        return this.getActiveBroadcastList(null);
    }

    @Override
    public void clearStreamInfoList(String streamId) {
    }

    @Override
    public List<StreamInfo> getStreamInfoList(String streamId) {
        return new ArrayList<StreamInfo>();
    }

    @Override
    public void saveStreamInfo(StreamInfo streamInfo) {
    }
}

