/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import dev.morphia.utils.IndexType;
import io.antmedia.EncoderSettings;
import io.antmedia.datastore.db.types.Endpoint;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(description="The basic broadcast class")
@Entity(value="broadcast")
@Indexes(value={@Index(fields={@Field(value="name", type=IndexType.TEXT)}), @Index(fields={@Field(value="streamId")}), @Index(fields={@Field(value="status")})})
public class Broadcast {
    private static final Logger logger = LoggerFactory.getLogger(Broadcast.class);
    @JsonIgnore
    @Id
    private ObjectId dbId;
    @Schema(description="the id of the stream")
    private String streamId;
    @Schema(description="the status of the stream", allowableValues={"finished,broadcasting,created,preparing,error,failed"})
    private String status;
    @Schema(description="The status of the playlist. It's usable if type is playlist", allowableValues={"finished,broadcasting,created,preparing,error,failed"})
    private String playListStatus;
    @Schema(description="the type of the stream", allowableValues={"liveStream,ipCamera,streamSource,VoD,playlist"})
    private String type;
    @Schema(description="The publish type of the stream. It's read-only and its value updated on the server side", allowableValues={"WebRTC,RTMP,Pull"})
    private String publishType;
    @Schema(description="the name of the stream")
    private String name;
    @Schema(description="the description of the stream")
    private String description;
    @Schema(description="it is a video filter for the service, this value is controlled by the user, default value is true in the db")
    private boolean publish = true;
    @Schema(description="the date when record is created in milliseconds")
    private long date;
    @Schema(description="the planned start date")
    private long plannedStartDate;
    @Schema(description="the planned end date")
    private long plannedEndDate;
    @Schema(description="the duration of the stream in milliseconds")
    private long duration;
    @Schema(description="the list of endpoints such as Facebook, Twitter or custom RTMP endpoints  ")
    private List<Endpoint> endPointList;
    @Schema(description="the list broadcasts in the playlis. This list has values when the broadcast type is playlist")
    private List<PlayListItem> playListItemList;
    @Schema(description="the identifier of whether stream is public or not")
    private boolean publicStream = true;
    @Schema(description="the identifier of whether stream is 360 or not")
    private boolean is360 = false;
    @Schema(description="the url that will be notified when stream is published, ended and muxing finished")
    private String listenerHookURL;
    @Schema(description="the category of the stream")
    private String category;
    @Schema(description="the IP Address of the IP Camera or publisher")
    private String ipAddr;
    @Schema(description="the user name of the IP Camera")
    private String username;
    @Schema(description="the password of the IP Camera")
    private String password;
    @Schema(description="the quality of the incoming stream during publishing")
    private String quality;
    @Schema(description="the speed of the incoming stream, for better quality and performance it should be around 1.00")
    private double speed;
    @Schema(description="the stream URL for fetching stream, especially should be defined for IP Cameras or Cloud streams")
    private String streamUrl;
    @Schema(description="the origin address server broadcasting")
    private String originAdress;
    @Schema(description="MP4 muxing whether enabled or not for the stream, 1 means enabled, -1 means disabled, 0 means no settings for the stream")
    private int mp4Enabled = 0;
    @Schema(description="WebM muxing whether enabled or not for the stream, 1 means enabled, -1 means disabled, 0 means no settings for the stream")
    private int webMEnabled = 0;
    @Schema(description="Initial time to start playing. It can be used in VoD file or stream sources that has seek support")
    private long seekTimeInMs = 0L;
    @Schema(description="Conference mode. It's used if this broadcast has some specific modes. It's created for backward compatibility. It will be deleted.")
    @Deprecated(forRemoval=true, since="2.9.1")
    private String conferenceMode;
    @Schema(description="Number of subtracks that is allowed to be created for the broadcast. It's usefult for limiting number of conference attendees. Default value is -1  and it means no limit")
    private int subtracksLimit = -1;
    @Schema(description="the expire time in milliseconds For instance if this value is 10000 then broadcast should be started in 10 seconds after it is created.If expire duration is 0, then stream will never expire")
    private int expireDurationMS;
    @Schema(description="the RTMP URL where to publish live stream to")
    private String rtmpURL;
    @Schema(description="is true, if a broadcast that is not added to data store through rest service or management console It is false by default")
    private boolean zombi = false;
    @Schema(description="the number of audio and video packets that is being pending to be encoded in the queue ")
    private int pendingPacketSize = 0;
    @Schema(description="the number of HLS viewers of the stream")
    private int hlsViewerCount = 0;
    @Schema(description="the number of DASH viewers of the stream")
    private int dashViewerCount = 0;
    @Schema(description="the number of WebRTC viewers of the stream")
    private int webRTCViewerCount = 0;
    @Schema(description="the number of RTMP viewers of the stream")
    private int rtmpViewerCount = 0;
    @Schema(description="the publishing start time of the stream")
    private long startTime = 0L;
    @Schema(description="the received bytes until now")
    private long receivedBytes = 0L;
    @Schema(description="the received bytes / duration")
    private long bitrate = 0L;
    @Schema(description="User - Agent")
    private String userAgent = "N/A";
    @Schema(description="latitude of the broadcasting location")
    private String latitude;
    @Schema(description="longitude of the broadcasting location")
    private String longitude;
    @Schema(description="altitude of the broadcasting location")
    private String altitude;
    @Schema(description="If this broadcast is a track of a WebRTC stream. This variable is Id of that stream.")
    private String mainTrackStreamId;
    @Deprecated(forRemoval=true, since="2.10.1")
    @Schema(description="If this broadcast is main track. This variable hold sub track ids.")
    private List<String> subTrackStreamIds = new ArrayList<String>();
    @Schema(description="Absolute start time in milliseconds - unix timestamp. It's used for measuring the absolute latency")
    private long absoluteStartTimeMs;
    @Schema(description="Number of the allowed maximum WebRTC viewers for the broadcast")
    private int webRTCViewerLimit = -1;
    @Schema(description="Number of the allowed maximum HLS viewers for the broadcast")
    private int hlsViewerLimit = -1;
    @Schema(description="Number of the allowed maximum DASH viewers for the broadcast")
    private int dashViewerLimit = -1;
    @Schema(description="Name of the subfolder that will contain stream files")
    private String subFolder;
    @Schema(description="Current playing index for playlist types")
    private int currentPlayIndex = 0;
    @Schema(description="Meta data filed for the custom usage")
    private String metaData = null;
    @Schema(description="the identifier of playlist loop status")
    private boolean playlistLoopEnabled = true;
    private long updateTime = 0L;
    @Schema(description="Broadcast role for selective playback")
    private String role = null;
    @Schema(description="the HLS parameters of the broadcast")
    private HLSParameters hlsParameters = null;
    @Schema(description="The identifier of whether stream should start/stop automatically. It's effective for Stream Sources/IP Cameras. If there is no viewer after certain amount of seconds, it will stop. If there is an user want to watch the stream, it will start automatically")
    private boolean autoStartStopEnabled = false;
    @Schema(description="The list of encoder settings")
    private List<EncoderSettings> encoderSettingsList;

    public Broadcast() {
        this.type = "liveStream";
    }

    public Broadcast(String status, String name) {
        this.setStatus(status);
        this.setName(name);
        this.type = "liveStream";
    }

    public Broadcast(String name) {
        this.name = name;
        this.type = "liveStream";
    }

    public Broadcast(String name, String ipAddr, String username, String password, String streamUrl, String type) {
        this.name = name;
        this.ipAddr = ipAddr;
        this.username = username;
        this.password = password;
        this.streamUrl = streamUrl;
        this.type = type;
    }

    public String getStreamId() {
        if (this.streamId != null) {
            return this.streamId;
        }
        if (this.dbId == null) {
            return null;
        }
        return this.dbId.toString();
    }

    public void setStreamId(String id) throws Exception {
        if (id == null) {
            throw new Exception("stream id cannot be null");
        }
        this.streamId = id;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public String getQuality() {
        return this.quality;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPublish() {
        return this.publish;
    }

    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    public long getDate() {
        return this.date;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public long getPlannedStartDate() {
        return this.plannedStartDate;
    }

    public void setPlannedStartDate(long plannedStartDate) {
        this.plannedStartDate = plannedStartDate;
    }

    public long getPlannedEndDate() {
        return this.plannedEndDate;
    }

    public void setPlannedEndDate(long plannedEndDate) {
        this.plannedEndDate = plannedEndDate;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public List<Endpoint> getEndPointList() {
        return this.endPointList;
    }

    public void setEndPointList(List<Endpoint> endPointList) {
        this.endPointList = endPointList;
    }

    public boolean isIs360() {
        return this.is360;
    }

    public void setIs360(boolean is360) {
        this.is360 = is360;
    }

    public boolean isPublicStream() {
        return this.publicStream;
    }

    public void setPublicStream(boolean publicStream) {
        this.publicStream = publicStream;
    }

    public String getListenerHookURL() {
        return this.listenerHookURL;
    }

    public void setListenerHookURL(String listenerHookURL) {
        this.listenerHookURL = listenerHookURL;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public void setIpAddr(String ipAddr) {
        this.ipAddr = ipAddr;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getExpireDurationMS() {
        return this.expireDurationMS;
    }

    public void setExpireDurationMS(int expireDurationMS) {
        this.expireDurationMS = expireDurationMS;
    }

    public String getRtmpURL() {
        return this.rtmpURL;
    }

    public void setRtmpURL(String rtmpURL) {
        this.rtmpURL = rtmpURL;
    }

    public ObjectId getDbId() {
        return this.dbId;
    }

    public void setDbId(ObjectId dbId) {
        this.dbId = dbId;
    }

    public boolean isZombi() {
        return this.zombi;
    }

    public void setZombi(boolean zombi) {
        this.zombi = zombi;
    }

    public void resetStreamId() {
        this.streamId = null;
    }

    public String getStreamUrl() {
        return this.streamUrl;
    }

    public void setStreamUrl(String streamUrl) {
        this.streamUrl = streamUrl;
    }

    public int getHlsViewerCount() {
        return this.hlsViewerCount;
    }

    public void setHlsViewerCount(int hlsViewerCount) {
        this.hlsViewerCount = hlsViewerCount;
    }

    public int getWebRTCViewerCount() {
        return this.webRTCViewerCount;
    }

    public void setWebRTCViewerCount(int webRTCViewerCount) {
        this.webRTCViewerCount = webRTCViewerCount;
    }

    public int getRtmpViewerCount() {
        return this.rtmpViewerCount;
    }

    public void setRtmpViewerCount(int rtmpViewerCount) {
        this.rtmpViewerCount = rtmpViewerCount;
    }

    public int getPendingPacketSize() {
        return this.pendingPacketSize;
    }

    public void setPendingPacketSize(int pendingPacketSize) {
        this.pendingPacketSize = pendingPacketSize;
    }

    public String getOriginAdress() {
        return this.originAdress;
    }

    public void setOriginAdress(String originAdress) {
        this.originAdress = originAdress;
    }

    public int getMp4Enabled() {
        return this.mp4Enabled;
    }

    public void setMp4Enabled(int mp4Enabled) {
        this.mp4Enabled = mp4Enabled;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    public void setReceivedBytes(long receivedBytes) {
        this.receivedBytes = receivedBytes;
    }

    public long getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(long bitrate) {
        this.bitrate = bitrate;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getAltitude() {
        return this.altitude;
    }

    public void setAltitude(String altitude) {
        this.altitude = altitude;
    }

    public String getMainTrackStreamId() {
        return this.mainTrackStreamId;
    }

    public void setMainTrackStreamId(String mainTrackStreamId) {
        this.mainTrackStreamId = mainTrackStreamId;
    }

    @Deprecated(forRemoval=true, since="2.10.1")
    public List<String> getSubTrackStreamIds() {
        return this.subTrackStreamIds;
    }

    @Deprecated(forRemoval=true, since="2.10.1")
    public void setSubTrackStreamIds(List<String> subTrackStreamIds) {
        this.subTrackStreamIds = subTrackStreamIds;
    }

    public void setAbsoluteStartTimeMs(long absoluteStartTimeMs) {
        this.absoluteStartTimeMs = absoluteStartTimeMs;
    }

    public long getAbsoluteStartTimeMs() {
        return this.absoluteStartTimeMs;
    }

    public int getWebMEnabled() {
        return this.webMEnabled;
    }

    public void setWebMEnabled(int webMEnabled) {
        this.webMEnabled = webMEnabled;
    }

    public int getWebRTCViewerLimit() {
        return this.webRTCViewerLimit;
    }

    public void setWebRTCViewerLimit(int webRTCViewerLimit) {
        this.webRTCViewerLimit = webRTCViewerLimit;
    }

    public int getHlsViewerLimit() {
        return this.hlsViewerLimit;
    }

    public void setHlsViewerLimit(int hlsViewerLimit) {
        this.hlsViewerLimit = hlsViewerLimit;
    }

    public List<PlayListItem> getPlayListItemList() {
        return this.playListItemList;
    }

    public void setPlayListItemList(List<PlayListItem> playListItemList) {
        this.playListItemList = playListItemList;
    }

    public int getCurrentPlayIndex() {
        return this.currentPlayIndex;
    }

    public void setCurrentPlayIndex(int currentPlayIndex) {
        this.currentPlayIndex = currentPlayIndex;
    }

    public void setPlayListStatus(String playListStatus) {
        this.playListStatus = playListStatus;
    }

    public String getPlayListStatus() {
        return this.playListStatus;
    }

    public void setSubFolder(String subFolder) {
        this.subFolder = subFolder;
    }

    public String getSubFolder() {
        return this.subFolder;
    }

    public String getPublishType() {
        return this.publishType;
    }

    public void setPublishType(String publishType) {
        this.publishType = publishType;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String metaData) {
        this.metaData = metaData;
    }

    public int getDashViewerLimit() {
        return this.dashViewerLimit;
    }

    public void setDashViewerLimit(int dashViewerLimit) {
        this.dashViewerLimit = dashViewerLimit;
    }

    public int getDashViewerCount() {
        return this.dashViewerCount;
    }

    public void setDashViewerCount(int dashViewerCount) {
        this.dashViewerCount = dashViewerCount;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public HLSParameters getHlsParameters() {
        return this.hlsParameters;
    }

    public void setHlsParameters(HLSParameters hlsParameters) {
        this.hlsParameters = hlsParameters;
    }

    public boolean isAnyoneWatching() {
        return this.getDashViewerCount() != 0 || this.getWebRTCViewerCount() != 0 || this.getRtmpViewerCount() != 0 || this.getHlsViewerCount() != 0;
    }

    public boolean isAutoStartStopEnabled() {
        return this.autoStartStopEnabled;
    }

    public void setAutoStartStopEnabled(boolean autoStartStopEnabled) {
        this.autoStartStopEnabled = autoStartStopEnabled;
    }

    public long getSeekTimeInMs() {
        return this.seekTimeInMs;
    }

    public void setSeekTimeInMs(long seekTimeInMs) {
        this.seekTimeInMs = seekTimeInMs;
    }

    public String getConferenceMode() {
        return this.conferenceMode;
    }

    public void setConferenceMode(String conferenceMode) {
        this.conferenceMode = conferenceMode;
    }

    public int getSubtracksLimit() {
        return this.subtracksLimit;
    }

    public void setSubtracksLimit(int subtracksLimit) {
        this.subtracksLimit = subtracksLimit;
    }

    public List<EncoderSettings> getEncoderSettingsList() {
        return this.encoderSettingsList;
    }

    public void setEncoderSettingsList(List<EncoderSettings> encoderSettingsList) {
        this.encoderSettingsList = encoderSettingsList;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean isPlaylistLoopEnabled() {
        return this.playlistLoopEnabled;
    }

    public void setPlaylistLoopEnabled(boolean playlistLoopEnabled) {
        this.playlistLoopEnabled = playlistLoopEnabled;
    }

    @Entity
    public static class HLSParameters {
        @Schema(description="Duration of segments in m3u8 files in seconds")
        private String hlsTime;
        @Schema(description="Set the maximum number of playlist entries, If 0 the list file will contain all the segments")
        private String hlsListSize;
        @Schema(description="Playlist type of m3u8 files, Can be 'event' or 'vod' or empty")
        private String hlsPlayListType;

        public String getHlsTime() {
            return this.hlsTime;
        }

        public void setHlsTime(String hlsTime) {
            this.hlsTime = hlsTime;
        }

        public String getHlsListSize() {
            return this.hlsListSize;
        }

        public void setHlsListSize(String hlsListSize) {
            this.hlsListSize = hlsListSize;
        }

        public String getHlsPlayListType() {
            return this.hlsPlayListType;
        }

        public void setHlsPlayListType(String hlsPlayListType) {
            this.hlsPlayListType = hlsPlayListType;
        }
    }

    @Entity
    public static class PlayListItem {
        String streamUrl;
        String type;
        String name;
        private long durationInMs;
        private long seekTimeInMs = 0L;

        public PlayListItem() {
        }

        public PlayListItem(String streamUrl, String type) {
            this.streamUrl = streamUrl;
            this.type = type;
        }

        public String getStreamUrl() {
            return this.streamUrl;
        }

        public void setStreamUrl(String streamUrl) {
            this.streamUrl = streamUrl;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public long getSeekTimeInMs() {
            return this.seekTimeInMs;
        }

        public void setSeekTimeInMs(long seekTimeInMs) {
            this.seekTimeInMs = seekTimeInMs;
        }

        public long getDurationInMs() {
            return this.durationInMs;
        }

        public void setDurationInMs(long durationInMs) {
            this.durationInMs = durationInMs;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

