/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import org.bson.types.ObjectId;

@Entity(value="P2PConnection")
@Indexes(value={@Index(fields={@Field(value="streamId")})})
@Schema(description="P2P Signalling Connection Info")
public class P2PConnection
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    @Id
    @Schema(description="The db id of the p2p connection")
    private ObjectId dbId;
    @Schema(description="The streamId for the p2p connection")
    private String streamId;
    @Schema(description="The IP of the originNode to which caller is connected")
    private String originNode;

    public P2PConnection() {
    }

    public P2PConnection(String streamId, String originNode) {
        this.streamId = streamId;
        this.originNode = originNode;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public String getOriginNode() {
        return this.originNode;
    }

    public void setOriginNode(String originNode) {
        this.originNode = originNode;
    }
}

