/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.eRTMP;

import io.antmedia.muxer.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HEVCDecoderConfigurationParser
extends Parser {
    private static Logger logger = LoggerFactory.getLogger(HEVCDecoderConfigurationParser.class);
    public static final int NAL_UNIT_TYPE_HEVC_VPS = 32;
    public static final int NAL_UNIT_TYPE_HEVC_SPS = 33;
    public static final int NAL_UNIT_TYPE_HEVC_PPS = 34;
    private byte[] sps;

    public HEVCDecoderConfigurationParser(byte[] data, int offset) {
        super(data, offset, false);
    }

    @Override
    protected void parse() {
        this.readBits(8);
        this.readBits(2);
        this.readBits(1);
        this.readBits(5);
        this.readBits(32);
        this.readBits(48);
        this.readBits(8);
        this.readBits(4);
        this.readBits(12);
        this.readBits(6);
        this.readBits(2);
        this.readBits(6);
        this.readBits(2);
        this.readBits(5);
        this.readBits(3);
        this.readBits(5);
        this.readBits(3);
        int averageFrameRate = this.readBits(16);
        this.readBits(2);
        this.readBits(3);
        this.readBits(1);
        int nalUnitLength = this.readBits(2) + 1;
        int numOfArrays = this.readBits(8);
        for (int i = 0; i < numOfArrays; ++i) {
            this.readBits(1);
            this.readBits(1);
            int nalUnitType = this.readBits(6);
            int numNalus = this.readBits(16);
            byte[] nalUnit = null;
            for (int j = 0; j < numNalus; ++j) {
                int nalLength = this.readBits(16);
                nalUnit = this.readByte(nalLength);
            }
            if (nalUnitType == 32) continue;
            if (nalUnitType == 33) {
                this.sps = nalUnit;
                logger.debug("NAL_UNIT_TYPE_HEVC_SPS: {}", (Object)this.sps);
                continue;
            }
            if (nalUnitType != 34) continue;
        }
        HEVCSPSParser spsParser = new HEVCSPSParser(this.sps, 2);
        this.width = spsParser.getWidth();
        this.height = spsParser.getHeight();
        logger.info("found width:{} and height:{}", (Object)this.width, (Object)this.height);
    }

    public static class HEVCSPSParser
    extends Parser {
        public HEVCSPSParser(byte[] data, int offset) {
            super(data, offset, true);
        }

        @Override
        protected void parse() {
            int i;
            this.readBits(4);
            int max_sub_layers_minus1 = this.readBits(3);
            this.readBits(1);
            this.readBits(2);
            this.readBits(1);
            this.readBits(5);
            this.readBits(32);
            this.readBits(1);
            this.readBits(1);
            this.readBits(1);
            this.readBits(1);
            this.readBits(44);
            this.readBits(8);
            int[] sub_layer_profile_present_flag = new int[max_sub_layers_minus1];
            int[] sub_layer_level_present_flag = new int[max_sub_layers_minus1];
            for (i = 0; i < max_sub_layers_minus1; ++i) {
                sub_layer_profile_present_flag[i] = this.readBits(1);
                sub_layer_level_present_flag[i] = this.readBits(1);
            }
            if (max_sub_layers_minus1 > 0) {
                for (i = max_sub_layers_minus1; i < 8; ++i) {
                    this.readBits(2);
                }
            }
            for (i = 0; i < max_sub_layers_minus1; ++i) {
                if (sub_layer_profile_present_flag[i] == 1) {
                    this.readBits(2);
                    this.readBits(1);
                    this.readBits(5);
                    for (int j = 0; j < 32; ++j) {
                        this.readBits(1);
                    }
                    this.readBits(1);
                    this.readBits(1);
                    this.readBits(1);
                    this.readBits(1);
                    this.readBits(44);
                }
                if (sub_layer_profile_present_flag[i] != 1) continue;
                this.readBits(8);
            }
            this.readExponentialGolombCode();
            int chroma_format_idc = this.readExponentialGolombCode();
            if (chroma_format_idc == 3) {
                this.readBits(1);
            }
            this.width = this.readExponentialGolombCode();
            this.height = this.readExponentialGolombCode();
        }
    }
}

