/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.eRTMP;

import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.AVCVideo;
import org.red5.codec.IVideoStreamCodec;
import org.red5.server.net.rtmp.event.VideoData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HEVCVideoEnhancedRTMP
extends AVCVideo {
    static final String CODEC_NAME = "HEVC";
    private static Logger log = LoggerFactory.getLogger(HEVCVideoEnhancedRTMP.class);

    public HEVCVideoEnhancedRTMP() {
        this.reset();
    }

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    @Override
    public boolean canDropFrames() {
        return true;
    }

    @Override
    public boolean canHandleData(IoBuffer data) {
        boolean result = false;
        if (data.limit() > 0) {
            boolean exVideoHeader;
            int firstByte = data.get() & 0xFF;
            boolean bl = exVideoHeader = (firstByte & 0x80) >> 7 == 1;
            if (exVideoHeader) {
                int videoPacketType = firstByte & 0xF;
                VideoData.ExVideoPacketType[] values = VideoData.ExVideoPacketType.values();
                VideoData.ExVideoPacketType exVideoPacketType = values[videoPacketType];
                if (data.remaining() >= 4) {
                    byte[] fourcc = new byte[4];
                    data.get(fourcc);
                    VideoData.VideoFourCC videoFourCc = VideoData.findFourCcByValue(VideoData.VideoFourCC.makeFourCc(new String(fourcc)));
                    if (videoFourCc != null && videoFourCc == VideoData.VideoFourCC.HEVC_FOURCC) {
                        result = true;
                    }
                }
            }
            data.rewind();
        }
        return result;
    }

    @Override
    public boolean addData(IoBuffer data, int timestamp) {
        if (data.hasRemaining()) {
            int start = data.position();
            int firstByte = data.get() & 0xFF;
            int frameTypeLocal = (firstByte & 0x70) >> 4;
            int videoPacketType = firstByte & 0xF;
            VideoData.ExVideoPacketType exVideoPacketType = VideoData.ExVideoPacketType.values()[videoPacketType];
            if (exVideoPacketType == VideoData.ExVideoPacketType.SEQUENCE_START) {
                data.rewind();
                this.decoderConfiguration.setData(data);
                this.softReset();
            } else if (exVideoPacketType == VideoData.ExVideoPacketType.CODED_FRAMES || exVideoPacketType == VideoData.ExVideoPacketType.CODED_FRAMESX) {
                // empty if block
            }
            if (frameTypeLocal == 1) {
                data.rewind();
                if (timestamp != this.keyframeTimestamp) {
                    this.keyframeTimestamp = timestamp;
                    this.softReset();
                }
                this.keyframes.add(new IVideoStreamCodec.FrameData(data));
            } else {
                data.rewind();
                try {
                    int lastInterframe = this.numInterframes.getAndIncrement();
                    if (lastInterframe < this.interframes.size()) {
                        ((IVideoStreamCodec.FrameData)this.interframes.get(lastInterframe)).setData(data);
                    } else {
                        this.interframes.add(new IVideoStreamCodec.FrameData(data));
                    }
                }
                catch (Throwable e) {
                    log.error("Failed to buffer interframe", e);
                }
            }
            data.position(start);
        }
        return true;
    }
}

