/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.IDataStoreFactory;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.security.ITokenService;
import io.antmedia.settings.ServerSettings;
import io.antmedia.statistic.IStreamStats;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Queue;
import org.apache.catalina.util.NetMask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public abstract class AbstractFilter
implements Filter {
    public static final String BROADCAST_OBJECT = "broadcast";
    protected static Logger logger = LoggerFactory.getLogger(AbstractFilter.class);
    protected FilterConfig config;
    IStreamStats streamStats;
    private ITokenService tokenService;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
    }

    public AppSettings getAppSettings() {
        AppSettings appSettings = null;
        ConfigurableWebApplicationContext context = this.getAppContext();
        if (context != null) {
            appSettings = (AppSettings)context.getBean("app.settings");
        }
        return appSettings;
    }

    public ServerSettings getServerSettings() {
        ServerSettings serverSettings = null;
        ConfigurableWebApplicationContext context = this.getAppContext();
        if (context != null) {
            serverSettings = (ServerSettings)context.getBean("ant.media.server.settings");
        }
        return serverSettings;
    }

    public boolean checkCIDRList(Queue<NetMask> allowedCIDRList, String remoteIPAdrress) {
        try {
            InetAddress addr = InetAddress.getByName(remoteIPAdrress);
            for (NetMask nm : allowedCIDRList) {
                if (!nm.matches(addr)) continue;
                return true;
            }
        }
        catch (UnknownHostException e) {
            logger.error("error", (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConfigurableWebApplicationContext getAppContext() {
        ConfigurableWebApplicationContext appContext = this.getWebApplicationContext();
        if (appContext != null && appContext.isRunning()) {
            Object dataStoreFactory = appContext.getBean("dataStoreFactory");
            if (!(dataStoreFactory instanceof IDataStoreFactory)) return appContext;
            DataStore dataStore = ((IDataStoreFactory)dataStoreFactory).getDataStore();
            if (dataStore.isAvailable()) {
                return appContext;
            }
            logger.warn("DataStore is not available. It may be closed or not initialized");
            return null;
        } else if (appContext == null) {
            logger.warn("App context not initialized ");
            return null;
        } else {
            logger.warn("App context not running yet.");
        }
        return null;
    }

    public ConfigurableWebApplicationContext getWebApplicationContext() {
        return (ConfigurableWebApplicationContext)this.getConfig().getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
    }

    public FilterConfig getConfig() {
        return this.config;
    }

    public void setConfig(FilterConfig config) {
        this.config = config;
    }

    public void destroy() {
    }

    public IStreamStats getStreamStats(String type) {
        ConfigurableWebApplicationContext context;
        if (this.streamStats == null && (context = this.getAppContext()) != null) {
            this.streamStats = type.equals("hls.viewerstats") ? (IStreamStats)context.getBean("hls.viewerstats") : (IStreamStats)context.getBean("dash.viewerstats");
        }
        return this.streamStats;
    }

    public Broadcast getBroadcast(HttpServletRequest request, String streamId) {
        DataStore dataStore;
        Broadcast broadcast = (Broadcast)request.getAttribute(BROADCAST_OBJECT);
        if (broadcast == null && (dataStore = this.getDataStore()) != null && (broadcast = dataStore.get(streamId)) != null) {
            request.setAttribute(BROADCAST_OBJECT, (Object)broadcast);
        }
        return broadcast;
    }

    public AntMediaApplicationAdapter getAntMediaApplicationAdapter() {
        AntMediaApplicationAdapter antMediaApplicationAdapter = null;
        ConfigurableWebApplicationContext context = this.getAppContext();
        if (context != null) {
            antMediaApplicationAdapter = (AntMediaApplicationAdapter)context.getBean("web.handler");
        }
        return antMediaApplicationAdapter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataStore getDataStore() {
        ConfigurableWebApplicationContext appContext = this.getWebApplicationContext();
        if (appContext != null && appContext.isRunning()) {
            Object dataStoreFactory = appContext.getBean("dataStoreFactory");
            if (!(dataStoreFactory instanceof IDataStoreFactory)) return null;
            DataStore dataStore = ((IDataStoreFactory)dataStoreFactory).getDataStore();
            if (dataStore.isAvailable()) {
                return dataStore;
            }
            logger.info("DataStore is not available. It may be closed or not initialized");
            return null;
        } else if (appContext == null) {
            logger.warn("App context not initialized ");
            return null;
        } else {
            logger.warn("App context not running yet.");
        }
        return null;
    }

    public ITokenService getTokenService() {
        ConfigurableWebApplicationContext context;
        if (this.tokenService == null && (context = this.getAppContext()) != null) {
            this.tokenService = (ITokenService)context.getBean(ITokenService.BeanName.TOKEN_SERVICE.toString());
        }
        return this.tokenService;
    }

    public void setTokenService(ITokenService tokenService) {
        this.tokenService = tokenService;
    }
}

