/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import com.amazonaws.util.StringUtils;
import io.antmedia.filter.AbstractFilter;
import io.lindstrom.m3u8.model.MediaPlaylist;
import io.lindstrom.m3u8.model.MediaSegment;
import io.lindstrom.m3u8.model.Playlist;
import io.lindstrom.m3u8.parser.MediaPlaylistParser;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class HlsManifestModifierFilter
extends AbstractFilter {
    public static final String START = "start";
    public static final String END = "end";
    public static final String SEGMENT_FILE_REGEX = "\\b\\S+\\.(ts|m4s)(\\?.*)?\\b";
    public static final String MANIFEST_FILE_REGEX = "\\b\\S+\\.m3u8(\\?.*)?\\b";
    protected static Logger logger = LoggerFactory.getLogger(HlsManifestModifierFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String method = httpRequest.getMethod();
        if ("GET".equals(method) && httpRequest.getRequestURI().endsWith("m3u8")) {
            boolean parameterExists;
            String startDate = request.getParameter(START);
            String endDate = request.getParameter(END);
            String token = request.getParameter("token");
            String subscriberId = request.getParameter("subscriberId");
            String subscriberCode = request.getParameter("subscriberCode");
            boolean bl = parameterExists = !StringUtils.isNullOrEmpty((String)token) || !StringUtils.isNullOrEmpty((String)subscriberId) || !StringUtils.isNullOrEmpty((String)subscriberCode);
            if (httpRequest.getRequestURI().contains("_adaptive") && parameterExists) {
                this.addSecurityParametersToAdaptiveM3u8File(token, subscriberId, subscriberCode, request, response, chain);
            }
            if (StringUtils.isNullOrEmpty((String)startDate) || StringUtils.isNullOrEmpty((String)endDate)) {
                if (!httpRequest.getRequestURI().contains("_adaptive") && parameterExists) {
                    this.addSecurityParametersToSegmentUrls(token, subscriberId, subscriberCode, request, response, chain);
                } else {
                    chain.doFilter((ServletRequest)httpRequest, response);
                }
            } else {
                long start = Long.parseLong(startDate);
                long end = Long.parseLong(endDate);
                ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper((HttpServletResponse)response);
                chain.doFilter(request, (ServletResponse)responseWrapper);
                int status = responseWrapper.getStatus();
                if (200 <= status && status <= 400) {
                    try {
                        byte[] originalData = responseWrapper.getContentAsByteArray();
                        String original = new String(originalData);
                        MediaPlaylistParser parser = new MediaPlaylistParser();
                        MediaPlaylist playList = (MediaPlaylist)parser.readPlaylist(original);
                        ArrayList segments = new ArrayList();
                        for (MediaSegment segment : playList.mediaSegments()) {
                            segment.programDateTime().ifPresent(dateTime -> {
                                long time = dateTime.toEpochSecond();
                                if (time >= start && time <= end) {
                                    segments.add(MediaSegment.builder().duration(segment.duration()).uri(segment.uri()).build());
                                }
                            });
                        }
                        MediaPlaylist newPlayList = MediaPlaylist.builder().version(playList.version()).targetDuration(playList.targetDuration()).ongoing(false).addAllMediaSegments(segments).build();
                        MediaPlaylistParser parser2 = new MediaPlaylistParser();
                        String newData = parser2.writePlaylistAsString((Playlist)newPlayList);
                        if (parameterExists) {
                            newData = this.modifyManifestFileContent(newData, token, subscriberId, subscriberCode, SEGMENT_FILE_REGEX);
                        }
                        response.setContentLength(newData.length());
                        response.getOutputStream().write(newData.getBytes());
                        response.getWriter().flush();
                    }
                    catch (Exception e) {
                        response.setContentLength(responseWrapper.getContentSize());
                        response.getOutputStream().write(responseWrapper.getContentAsByteArray());
                        response.flushBuffer();
                    }
                }
            }
        } else {
            chain.doFilter((ServletRequest)httpRequest, response);
        }
    }

    private void addSecurityParametersToSegmentUrls(String token, String subscriberId, String subscriberCode, ServletRequest request, ServletResponse response, FilterChain chain) throws IOException {
        this.addSecurityParametersToURLs(token, subscriberId, subscriberCode, request, response, chain, SEGMENT_FILE_REGEX);
    }

    public void addSecurityParametersToAdaptiveM3u8File(String token, String subscriberId, String subscriberCode, ServletRequest request, ServletResponse response, FilterChain chain) throws IOException {
        this.addSecurityParametersToURLs(token, subscriberId, subscriberCode, request, response, chain, MANIFEST_FILE_REGEX);
    }

    public void addSecurityParametersToURLs(String token, String subscriberId, String subscriberCode, ServletRequest request, ServletResponse response, FilterChain chain, String regex) throws IOException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper(httpResponse);
        try {
            chain.doFilter(request, (ServletResponse)responseWrapper);
            int status = responseWrapper.getStatus();
            if (status >= 200 && status <= 400) {
                byte[] originalData = responseWrapper.getContentAsByteArray();
                String original = new String(originalData);
                String modifiedContent = this.modifyManifestFileContent(original, token, subscriberId, subscriberCode, regex);
                response.setContentLength(modifiedContent.length());
                response.getOutputStream().write(modifiedContent.getBytes());
                response.getOutputStream().flush();
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            byte[] originalContent = responseWrapper.getContentAsByteArray();
            response.setContentLength(originalContent.length);
            response.getOutputStream().write(originalContent);
            response.flushBuffer();
        }
    }

    private String modifyManifestFileContent(String original, String token, String subscriberId, String subscriberCode, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(original);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            Object replacementString = matcher.group();
            replacementString = ((String)replacementString).contains("?") ? (String)replacementString + "&" : (String)replacementString + "?";
            if (!StringUtils.isNullOrEmpty((String)subscriberCode)) {
                replacementString = (String)replacementString + "subscriberCode=" + subscriberCode;
            }
            if (!StringUtils.isNullOrEmpty((String)subscriberId)) {
                replacementString = (String)replacementString + "&subscriberId=" + subscriberId;
            }
            if (!StringUtils.isNullOrEmpty((String)token)) {
                replacementString = (String)replacementString + "&token=" + token;
            }
            matcher.appendReplacement(result, (String)replacementString);
        }
        matcher.appendTail(result);
        String modifiedContent = result.toString();
        return modifiedContent;
    }
}

