/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.filter.TokenFilterManager;
import io.antmedia.statistic.IStreamStats;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StatisticsFilter
extends AbstractFilter {
    protected static Logger logger = LoggerFactory.getLogger(StatisticsFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String method = httpRequest.getMethod();
        if ("GET".equals(method) && this.isFilterMatching(httpRequest.getRequestURI())) {
            String sessionId = httpRequest.getSession().getId();
            String streamId = TokenFilterManager.getStreamId(httpRequest.getRequestURI());
            String subscriberId = ((HttpServletRequest)request).getParameter("subscriberId");
            if (this.isViewerCountExceeded((HttpServletRequest)request, (HttpServletResponse)response, streamId)) {
                logger.info("Number of viewers limits has exceeded so it's returning forbidden for streamId:{} and class:{}", (Object)streamId, (Object)this.getClass().getSimpleName());
                return;
            }
            chain.doFilter(request, response);
            int status = ((HttpServletResponse)response).getStatus();
            if (200 <= status && status <= 400 && streamId != null) {
                logger.debug("req ip {} session id {} stream id {} status {}", new Object[]{request.getRemoteHost(), sessionId, streamId, status});
                IStreamStats stats = this.getStreamStats(this.getBeanName());
                if (stats != null) {
                    stats.registerNewViewer(streamId, sessionId, subscriberId);
                }
            }
            this.startStreamingIfAutoStartStopEnabled((HttpServletRequest)request, streamId);
        } else if ("HEAD".equals(method) && this.isFilterMatching(httpRequest.getRequestURI())) {
            String streamId = TokenFilterManager.getStreamId(httpRequest.getRequestURI());
            chain.doFilter(request, response);
            this.startStreamingIfAutoStartStopEnabled((HttpServletRequest)request, streamId);
        } else {
            chain.doFilter((ServletRequest)httpRequest, response);
        }
    }

    public void startStreamingIfAutoStartStopEnabled(HttpServletRequest request, String streamId) {
        Broadcast broadcast = this.getBroadcast(request, streamId);
        if (broadcast != null && broadcast.isAutoStartStopEnabled() && !AntMediaApplicationAdapter.isStreaming(broadcast)) {
            logger.info("http play request(hls, dash) is received for stream id:{} and it's not streaming, so it's trying to start the stream", (Object)streamId);
            this.getAntMediaApplicationAdapter().startStreaming(broadcast);
        }
    }

    public abstract boolean isViewerCountExceeded(HttpServletRequest var1, HttpServletResponse var2, String var3) throws IOException;

    public abstract boolean isFilterMatching(String var1);

    public abstract String getBeanName();
}

