/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Subscriber;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.filter.TokenFilterManager;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriberBlockFilter
extends AbstractFilter {
    protected static Logger logger = LoggerFactory.getLogger(SubscriberBlockFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String method = httpRequest.getMethod();
        if ("GET".equals(method) && (httpRequest.getRequestURI().endsWith("m3u8") || httpRequest.getRequestURI().endsWith("ts") || httpRequest.getRequestURI().endsWith("m4s") || httpRequest.getRequestURI().endsWith("mpd"))) {
            String subscriberId = request.getParameter("subscriberId");
            String streamId = TokenFilterManager.getStreamId(httpRequest.getRequestURI());
            DataStore dataStore = this.getDataStore();
            Broadcast broadcast = this.getBroadcast(httpRequest, streamId);
            Subscriber subscriber = dataStore.getSubscriber(streamId, subscriberId);
            if (broadcast == null || subscriber == null) {
                chain.doFilter(request, response);
                return;
            }
            if (!subscriber.isBlocked("play")) {
                chain.doFilter(request, response);
            } else {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.sendError(401, "Subscriber is blocked");
            }
        } else {
            chain.doFilter(request, response);
        }
    }
}

