/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AppSettings;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.security.ITokenService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenFilterManager
extends AbstractFilter {
    public static final String REPLACE_CHARS_REGEX = "[\n|\r|\t]";
    public static final String NOT_INITIALIZED = "Not initialized";
    protected static Logger logger = LoggerFactory.getLogger(TokenFilterManager.class);
    public static final String TOKEN_HEADER_FOR_NODE_COMMUNICATION = "ClusterAuthorization";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String method = httpRequest.getMethod();
        String tokenId = ((HttpServletRequest)request).getParameter("token");
        String subscriberId = ((HttpServletRequest)request).getParameter("subscriberId");
        String subscriberCodeText = ((HttpServletRequest)request).getParameter("subscriberCode");
        if (tokenId != null) {
            tokenId = tokenId.replaceAll(REPLACE_CHARS_REGEX, "_");
        }
        if (subscriberId != null) {
            subscriberId = subscriberId.replaceAll(REPLACE_CHARS_REGEX, "_");
        }
        if (subscriberCodeText != null) {
            subscriberCodeText = subscriberCodeText.replaceAll(REPLACE_CHARS_REGEX, "_");
        }
        String sessionId = httpRequest.getSession().getId();
        String streamId = TokenFilterManager.getStreamId(httpRequest.getRequestURI());
        String clientIP = httpRequest.getRemoteAddr().replaceAll(REPLACE_CHARS_REGEX, "_");
        AppSettings appSettings = this.getAppSettings();
        if (appSettings == null) {
            httpResponse.sendError(403, "Server is getting initialized.");
            logger.warn("AppSettings not initialized. Server is getting started for stream id:{} from request: {}", (Object)streamId, (Object)clientIP);
            return;
        }
        logger.debug("Client IP: {}, request url:  {}, token:  {}, sessionId: {},streamId:  {} ", new Object[]{clientIP, httpRequest.getRequestURI(), tokenId, sessionId, streamId});
        if ("GET".equals(method) || "HEAD".equals(method)) {
            ITokenService tokenServiceTmp;
            if (streamId == null) {
                logger.warn("No streamId found in the request: {}", (Object)httpRequest.getRequestURI());
            }
            if ((tokenServiceTmp = this.getTokenService()) == null) {
                httpResponse.sendError(403, NOT_INITIALIZED);
                logger.warn("Token service is not initialized. Server is getting started for stream id:{} from request: {}", (Object)streamId, (Object)clientIP);
                return;
            }
            String jwtInternalCommunicationToken = httpRequest.getHeader(TOKEN_HEADER_FOR_NODE_COMMUNICATION);
            if (jwtInternalCommunicationToken != null) {
                boolean checkJwtToken = false;
                if (streamId != null) {
                    checkJwtToken = tokenServiceTmp.isJwtTokenValid(jwtInternalCommunicationToken, appSettings.getClusterCommunicationKey(), streamId, "play");
                }
                if (!checkJwtToken) {
                    httpResponse.sendError(403, "Cluster communication token is not valid for streamId:" + streamId);
                    logger.warn("Cluster communication token is not valid for streamId:{}", (Object)streamId);
                    return;
                }
            } else {
                if (TokenFilterManager.isAnySecurityEnabled(appSettings) && StringUtils.isBlank((CharSequence)streamId)) {
                    httpResponse.sendError(403, "Cannot specified the stream id from the url");
                    logger.warn("Stream id is null");
                    return;
                }
                if ((appSettings.isTimeTokenSubscriberOnly() || appSettings.isEnableTimeTokenForPlay()) && !tokenServiceTmp.checkTimeBasedSubscriber(subscriberId, streamId, sessionId, subscriberCodeText, "play")) {
                    httpResponse.sendError(403, "Time Based subscriber id or code is invalid");
                    logger.warn("subscriber request for subscriberID or subscriberCode is not valid for streamId: {}", (Object)streamId);
                    return;
                }
                if (appSettings.isPlayTokenControlEnabled() && !tokenServiceTmp.checkToken(tokenId, streamId, sessionId, "play")) {
                    httpResponse.sendError(403, "Invalid Token for streamId:" + streamId);
                    logger.warn("token {} is not valid for stream id:{}", (Object)tokenId, (Object)streamId);
                    return;
                }
                if (appSettings.isHashControlPlayEnabled() && !tokenServiceTmp.checkHash(tokenId, streamId, sessionId, "play")) {
                    httpResponse.sendError(403, "Invalid Hash");
                    logger.warn("hash {} is not valid", (Object)tokenId);
                    return;
                }
                if (appSettings.isPlayJwtControlEnabled() && !tokenServiceTmp.checkJwtToken(tokenId, streamId, sessionId, "play")) {
                    httpResponse.sendError(403, "Invalid JWT Token");
                    logger.warn("JWT token is not valid");
                    return;
                }
            }
            chain.doFilter(request, response);
        } else if ("OPTIONS".equals(method)) {
            chain.doFilter(request, response);
        } else {
            httpResponse.sendError(403, "Invalid Request Type");
            logger.warn("Invalid method type({}) for stream: {} and request uri: {}", new Object[]{method, streamId, httpRequest.getRequestURI()});
        }
    }

    public static boolean isAnySecurityEnabled(AppSettings appSettings) {
        return appSettings.isTimeTokenSubscriberOnly() || appSettings.isPlayJwtControlEnabled() || appSettings.isEnableTimeTokenForPlay() || appSettings.isPlayTokenControlEnabled() || appSettings.isHashControlPlayEnabled();
    }

    public static String getStreamId(String requestURI) {
        requestURI = requestURI.replaceAll(REPLACE_CHARS_REGEX, "_");
        int startIndex = requestURI.indexOf(47);
        if (requestURI.contains("streams")) {
            requestURI = requestURI.split("streams")[1];
        }
        if (requestURI.contains("m4s") || requestURI.contains("mpd")) {
            startIndex = requestURI.indexOf("/");
            int endIndex = requestURI.lastIndexOf("/");
            if (endIndex == 0) {
                return requestURI;
            }
            return requestURI.substring(startIndex + 1, endIndex);
        }
        if (requestURI.contains("chunked")) {
            requestURI = requestURI.split("chunked")[1];
            startIndex = requestURI.indexOf("/");
            int endIndex = requestURI.lastIndexOf("/");
            return requestURI.substring(startIndex + 1, endIndex);
        }
        int endIndex = requestURI.lastIndexOf("_adaptive.m3u8");
        if (endIndex != -1) {
            return requestURI.substring(requestURI.lastIndexOf("/") + 1, endIndex);
        }
        String tsRegex = "(.*)/(.*)__(.*)$";
        Pattern pattern = Pattern.compile(tsRegex);
        Matcher matcher = pattern.matcher(requestURI);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        String hlsRegex = "(.*)_([0-9]+p|[0-9]+kbps|[0-9]+p[0-9]+kbps).m3u8$";
        if (requestURI.matches(hlsRegex)) {
            endIndex = requestURI.lastIndexOf(95);
            return requestURI.substring(requestURI.lastIndexOf("/") + 1, endIndex);
        }
        endIndex = requestURI.lastIndexOf(".m3u8");
        if (endIndex != -1) {
            return requestURI.substring(requestURI.lastIndexOf("/") + 1, endIndex);
        }
        tsRegex = "(.*)_([0-9]+p|[0-9]+kbps|[0-9]+p[0-9]+kbps)+[0-9]{9}.ts$";
        if (requestURI.matches(tsRegex)) {
            endIndex = requestURI.lastIndexOf(95);
            return requestURI.substring(requestURI.lastIndexOf("/") + 1, endIndex);
        }
        tsRegex = "(.*)_([0-9]+p|[0-9]+kbps|[0-9]+p[0-9]+kbps)+[0-9]{4}.ts$";
        if (requestURI.matches(tsRegex)) {
            endIndex = requestURI.lastIndexOf(95);
            return requestURI.substring(requestURI.lastIndexOf("/") + 1, endIndex);
        }
        tsRegex = "(.*)[0-9]{9}.ts$";
        if (requestURI.matches(tsRegex)) {
            endIndex = requestURI.lastIndexOf(46);
            return requestURI.substring(requestURI.lastIndexOf("/") + 1, endIndex - 9);
        }
        tsRegex = "(.*)[0-9]{4}.ts$";
        if (requestURI.matches(tsRegex)) {
            endIndex = requestURI.lastIndexOf(46);
            return requestURI.substring(requestURI.lastIndexOf("/") + 1, endIndex - 4);
        }
        String vodDatetimeRegex = "(.*)+(-20)[0-9][0-9]+(-)+([0-9][0-9])+(.*)";
        String vodResolutionBitrateRegex = "(.*)+_[0-9]+p+[0-9]+kbps+(.*)";
        if (requestURI.matches(vodDatetimeRegex)) {
            endIndex = requestURI.lastIndexOf(95);
            startIndex = requestURI.lastIndexOf("/");
            if (requestURI.matches(vodResolutionBitrateRegex)) {
                requestURI = requestURI.substring(startIndex, endIndex);
                endIndex = requestURI.lastIndexOf(46);
                endIndex -= "yyyy-MM-dd_HH-mm-ss.SSS".length() - 3;
                startIndex = 0;
            } else {
                endIndex -= "yyyy-MM-dd_HH-mm-ss.SSS".length() - 12;
            }
            return requestURI.substring(startIndex + 1, endIndex);
        }
        if (requestURI.matches(vodResolutionBitrateRegex)) {
            endIndex = requestURI.lastIndexOf(95);
            startIndex = requestURI.lastIndexOf("/");
            if (requestURI.substring(startIndex + 1, endIndex).matches(vodResolutionBitrateRegex)) {
                requestURI = requestURI.substring(startIndex, endIndex);
                endIndex = requestURI.lastIndexOf(95);
                startIndex = 0;
            }
            return requestURI.substring(startIndex + 1, endIndex);
        }
        String underScoreRegex = "(.*)_[0-9]+(.*)";
        endIndex = requestURI.lastIndexOf(".mp4");
        if (endIndex == -1) {
            endIndex = requestURI.lastIndexOf(".webm");
        }
        if (endIndex != -1) {
            if (requestURI.matches(underScoreRegex)) {
                endIndex = requestURI.lastIndexOf("_");
            }
            return requestURI.substring(requestURI.lastIndexOf("/") + 1, endIndex);
        }
        return null;
    }
}

