/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer;

import io.antmedia.muxer.MuxAdaptor;
import io.antmedia.muxer.Muxer;
import io.antmedia.storage.StorageClient;
import io.vertx.core.Vertx;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.javacpp.BytePointer;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HLSMuxer
extends Muxer {
    public static final String SEI_USER_DATA = "sei_user_data";
    private static final String SEGMENT_SUFFIX_TS = "%09d.ts";
    private static final String SEGMENT_SUFFIX_FMP4 = "%09d.m4s";
    private static final String HLS_SEGMENT_TYPE_MPEGTS = "mpegts";
    private static final String HLS_SEGMENT_TYPE_FMP4 = "fmp4";
    protected static Logger logger = LoggerFactory.getLogger(HLSMuxer.class);
    private String hlsListSize = "20";
    private String hlsTime = "5";
    private String hlsPlayListType = null;
    private boolean deleteFileOnExit = true;
    private String hlsFlags;
    private String segmentInitFilename;
    private String hlsEncryptionKeyInfoFile = null;
    protected StorageClient storageClient = null;
    private String s3StreamsFolderPath = "streams";
    private boolean uploadHLSToS3 = true;
    private String segmentFilename;
    private String hlsSegmentType = "mpegts";
    private String httpEndpoint;
    public static final int S3_CONSTANT = 2;
    private int id3StreamIndex = 2;
    private AVPacket id3DataPkt;
    private boolean id3Enabled = false;
    private ByteBuffer pendingSEIData;
    private AVPacket tmpPacketForSEI;

    public HLSMuxer(Vertx vertx, StorageClient storageClient, String s3StreamsFolderPath, int uploadExtensionsToS3, String httpEndpoint, boolean addDateTimeToResourceName) {
        super(vertx);
        this.storageClient = storageClient;
        if ((2 & uploadExtensionsToS3) == 0) {
            this.uploadHLSToS3 = false;
        }
        this.extension = ".m3u8";
        this.format = "hls";
        this.firstKeyFrameReceived = false;
        this.firstAudioDts = -1L;
        this.firstVideoDts = -1L;
        this.s3StreamsFolderPath = s3StreamsFolderPath;
        this.httpEndpoint = httpEndpoint;
        this.setAddDateTimeToSourceName(addDateTimeToResourceName);
    }

    public void setHlsParameters(String hlsListSize, String hlsTime, String hlsPlayListType, String hlsFlags, String hlsEncryptionKeyInfoFile, String hlsSegmentType) {
        if (hlsListSize != null && !hlsListSize.isEmpty()) {
            this.hlsListSize = hlsListSize;
        }
        if (hlsTime != null && !hlsTime.isEmpty()) {
            this.hlsTime = hlsTime;
        }
        if (hlsPlayListType != null && !hlsPlayListType.isEmpty()) {
            this.hlsPlayListType = hlsPlayListType;
        }
        this.hlsFlags = hlsFlags != null && !hlsFlags.isEmpty() ? hlsFlags : "";
        if (hlsEncryptionKeyInfoFile != null && !hlsEncryptionKeyInfoFile.isEmpty()) {
            this.hlsEncryptionKeyInfoFile = hlsEncryptionKeyInfoFile;
        }
        if (StringUtils.isNotBlank((CharSequence)hlsSegmentType)) {
            this.hlsSegmentType = hlsSegmentType;
        }
    }

    @Override
    public void init(IScope scope, String name, int resolutionHeight, String subFolder, int bitrate) {
        if (!this.isInitialized) {
            super.init(scope, name, resolutionHeight, subFolder, bitrate);
            this.streamId = name;
            this.subFolder = subFolder;
            this.options.put("hls_list_size", this.hlsListSize);
            this.options.put("hls_time", this.hlsTime);
            if (this.hlsEncryptionKeyInfoFile != null) {
                this.options.put("hls_key_info_file", this.hlsEncryptionKeyInfoFile);
            }
            logger.info("hls time:{}, hls list size:{} hls playlist type:{} for stream:{}", new Object[]{this.hlsTime, this.hlsListSize, this.hlsPlayListType, this.streamId});
            if (StringUtils.isNotBlank((CharSequence)this.httpEndpoint)) {
                this.segmentFilename = this.httpEndpoint;
                this.segmentFilename = this.segmentFilename + (!this.segmentFilename.endsWith(File.separator) ? File.separator : "");
                this.segmentFilename = this.segmentFilename + (this.subFolder != null ? subFolder : "");
                this.segmentFilename = this.segmentFilename + (!this.segmentFilename.endsWith(File.separator) ? File.separator : "");
                this.segmentFilename = this.segmentFilename + this.initialResourceNameWithoutExtension;
            } else {
                this.segmentFilename = this.file.getParentFile().toString();
                this.segmentFilename = this.segmentFilename + (!this.segmentFilename.endsWith(File.separator) ? File.separator : "");
                this.segmentFilename = this.segmentFilename + this.initialResourceNameWithoutExtension;
            }
            this.segmentFilename = HLSMuxer.replaceDoubleSlashesWithSingleSlash(this.segmentFilename);
            this.options.put("hls_segment_type", this.hlsSegmentType);
            if (HLS_SEGMENT_TYPE_FMP4.equals(this.hlsSegmentType)) {
                this.segmentInitFilename = this.initialResourceNameWithoutExtension + "_init.mp4";
                this.options.put("hls_fmp4_init_filename", this.segmentInitFilename);
                this.segmentFilename = this.segmentFilename + SEGMENT_SUFFIX_FMP4;
            } else {
                this.segmentFilename = this.segmentFilename + SEGMENT_SUFFIX_TS;
            }
            this.options.put("hls_segment_filename", this.segmentFilename);
            if (this.hlsPlayListType != null && (this.hlsPlayListType.equals("event") || this.hlsPlayListType.equals("vod"))) {
                this.options.put("hls_playlist_type", this.hlsPlayListType);
            }
            if (this.hlsFlags != null && !this.hlsFlags.isEmpty()) {
                this.options.put("hls_flags", this.hlsFlags);
            }
            this.tmpPacketForSEI = avcodec.av_packet_alloc();
            this.isInitialized = true;
        }
    }

    @Override
    public String getOutputURL() {
        if (StringUtils.isNotBlank((CharSequence)this.httpEndpoint)) {
            return HLSMuxer.replaceDoubleSlashesWithSingleSlash(this.httpEndpoint + File.separator + (this.subFolder != null ? this.subFolder : "") + File.separator + this.initialResourceNameWithoutExtension + this.extension);
        }
        return super.getOutputURL();
    }

    @Override
    public AVFormatContext getOutputFormatContext() {
        if (this.outputFormatContext == null) {
            this.outputFormatContext = new AVFormatContext(null);
            int ret = avformat.avformat_alloc_output_context2((AVFormatContext)this.outputFormatContext, null, (String)this.format, (String)this.getOutputURL());
            if (ret < 0) {
                logger.info("Could not create output context for {}", (Object)this.getOutputURL());
                return null;
            }
        }
        return this.outputFormatContext;
    }

    @Override
    public boolean isCodecSupported(int codecId) {
        return codecId == 27 || codecId == 86018 || codecId == 86017 || codecId == 173 || codecId == 86019;
    }

    @Override
    public synchronized void writePacket(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase, int codecType) {
        if (codecType == 0 && this.pendingSEIData != null) {
            logger.info("sei data size:{} for streamId:{}", (Object)this.pendingSEIData.limit(), (Object)this.streamId);
            this.pendingSEIData.rewind();
            int newPacketSize = pkt.size() + this.pendingSEIData.limit();
            avcodec.av_packet_ref((AVPacket)this.tmpPacketForSEI, (AVPacket)pkt);
            this.tmpPacketForSEI.position(0L);
            ByteBuffer packetbuffer = ByteBuffer.allocateDirect(newPacketSize);
            packetbuffer.put(this.pendingSEIData);
            packetbuffer.put(pkt.data().position(0L).limit((long)pkt.size()).asByteBuffer());
            packetbuffer.position(0);
            this.tmpPacketForSEI.data(new BytePointer(packetbuffer));
            this.tmpPacketForSEI.data().position(0L).limit((long)newPacketSize);
            this.tmpPacketForSEI.size(packetbuffer.limit());
            this.pendingSEIData = null;
            super.writePacket(this.tmpPacketForSEI, inputTimebase, outputTimebase, codecType);
            avcodec.av_packet_unref((AVPacket)this.tmpPacketForSEI);
        } else {
            super.writePacket(pkt, inputTimebase, outputTimebase, codecType);
        }
    }

    @Override
    public synchronized void writeMetaData(String data, long dts) {
        this.addID3Data(data);
    }

    public synchronized void addID3Data(String data) {
        int id3TagSize = data.length() + 3;
        int tagSize = id3TagSize + 10;
        ByteBuffer byteBuffer = ByteBuffer.allocate(tagSize + 10);
        logger.info("Adding ID3 data: {} lenght:{} byte length:{} buffer capacacity:{}", new Object[]{data, data.length(), data.getBytes().length, byteBuffer.capacity()});
        byteBuffer.put("ID3".getBytes());
        byteBuffer.put(new byte[]{3, 0});
        byteBuffer.put((byte)0);
        byteBuffer.putInt(tagSize);
        byteBuffer.put("TXXX".getBytes());
        byteBuffer.putInt(id3TagSize);
        byteBuffer.put(new byte[]{0, 0});
        byteBuffer.put((byte)3);
        byteBuffer.put((byte)0);
        byteBuffer.put(data.getBytes());
        byteBuffer.put((byte)0);
        byteBuffer.rewind();
        this.writeID3Packet(byteBuffer);
    }

    public synchronized void writeID3Packet(ByteBuffer data) {
        if (!this.id3Enabled) {
            logger.info("ID3 tag is disabled for stream:{}", (Object)this.streamId);
            return;
        }
        long pts = this.getLastPts();
        this.id3DataPkt.pts(pts);
        this.id3DataPkt.dts(pts);
        this.id3DataPkt.stream_index(this.id3StreamIndex);
        this.id3DataPkt.data(new BytePointer(data));
        this.id3DataPkt.size(data.limit());
        this.id3DataPkt.position(0L);
        this.writeDataFrame(this.id3DataPkt, this.getOutputFormatContext());
    }

    @Override
    public boolean writeHeader() {
        this.createID3StreamIfRequired();
        return super.writeHeader();
    }

    public void createID3StreamIfRequired() {
        if (this.id3Enabled) {
            logger.info("ID3 tag is enabled for stream:{}", (Object)this.streamId);
            this.id3DataPkt = avcodec.av_packet_alloc();
            avcodec.av_init_packet((AVPacket)this.id3DataPkt);
            this.addID3Stream();
        }
    }

    @Override
    public synchronized void writeTrailer() {
        super.writeTrailer();
        if (StringUtils.isBlank((CharSequence)this.httpEndpoint)) {
            logger.info("Delete File onexit:{} upload to S3:{} stream:{} hls time:{} hlslist size:{}", new Object[]{this.deleteFileOnExit, this.uploadHLSToS3, this.streamId, this.hlsTime, this.hlsListSize});
            this.vertx.setTimer((long)(Integer.parseInt(this.hlsTime) * Integer.parseInt(this.hlsListSize)) * 1000L, l -> {
                String filenameWithoutExtension = this.file.getName().substring(0, this.file.getName().lastIndexOf(this.extension));
                int indexOfSuffix = 0;
                indexOfSuffix = HLS_SEGMENT_TYPE_FMP4.equals(this.hlsSegmentType) ? this.segmentFilename.indexOf(SEGMENT_SUFFIX_FMP4) : this.segmentFilename.indexOf(SEGMENT_SUFFIX_TS);
                String segmentFileWithoutSuffix = this.segmentFilename.substring(this.segmentFilename.lastIndexOf("/") + 1, indexOfSuffix);
                String regularExpression = segmentFileWithoutSuffix + "[0-9]*\\.(?:ts|m4s)$";
                File[] files = this.getHLSFilesInDirectory(regularExpression);
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        this.handleFinalization(files[i]);
                    }
                }
                if (this.segmentInitFilename != null) {
                    this.handleFinalization(new File(this.file.getParentFile() + File.separator + this.segmentInitFilename));
                }
            });
        } else {
            logger.info("http endpoint is {} so skipping delete or upload the m3u8 or ts files", (Object)this.httpEndpoint);
        }
    }

    private void handleFinalization(File file) {
        try {
            if (this.uploadHLSToS3 && this.storageClient.isEnabled()) {
                String path = HLSMuxer.replaceDoubleSlashesWithSingleSlash(this.s3StreamsFolderPath + File.separator + (this.subFolder != null ? this.subFolder : "") + File.separator + file.getName());
                this.storageClient.save(path, file, this.deleteFileOnExit);
            } else if (this.deleteFileOnExit) {
                Files.deleteIfExists(file.toPath());
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    public File[] getHLSFilesInDirectory(String regularExpression) {
        return this.file.getParentFile().listFiles((dir, name) -> name.equals(this.file.getName()) || name.matches(regularExpression));
    }

    @Override
    public synchronized boolean addStream(AVCodec codec, AVCodecContext codecContext, int streamIndex) {
        AVCodecParameters codecParameter = new AVCodecParameters();
        int ret = avcodec.avcodec_parameters_from_context((AVCodecParameters)codecParameter, (AVCodecContext)codecContext);
        if (ret < 0) {
            logger.error("Cannot get codec parameters for {}", (Object)this.streamId);
        }
        return super.addStream(codecParameter, codecContext.time_base(), streamIndex);
    }

    public synchronized void setSeiData(String data) {
        int nbStreams = this.getOutputFormatContext().nb_streams();
        boolean hevcCodec = false;
        boolean h264Codec = false;
        for (int i = 0; i < nbStreams; ++i) {
            AVStream stream = this.getOutputFormatContext().streams(i);
            if (stream.codecpar().codec_type() != 0) continue;
            if (stream.codecpar().codec_id() == 27) {
                h264Codec = true;
                continue;
            }
            if (stream.codecpar().codec_id() != 173) continue;
            hevcCodec = true;
        }
        if (!h264Codec && !hevcCodec) {
            logger.warn("There is no video stream in the muxer, so cannot add SEI data to the muxer. Stream id: {}", (Object)this.streamId);
            return;
        }
        int length = data.getBytes().length;
        int payloadSize = 16 + length;
        int lengthByteCount = payloadSize / 255;
        int remaining = payloadSize % 255;
        if (remaining != 0) {
            ++lengthByteCount;
        }
        int totalLength = 6 + lengthByteCount + payloadSize + 1;
        if (hevcCodec) {
            ++totalLength;
        }
        this.pendingSEIData = ByteBuffer.allocateDirect(totalLength);
        if (StringUtils.equals((CharSequence)this.getBitStreamFilter(), (CharSequence)"h264_mp4toannexb") || StringUtils.equals((CharSequence)this.getBitStreamFilter(), (CharSequence)"hevc_mp4toannexb") || HLS_SEGMENT_TYPE_FMP4.equals(this.hlsSegmentType)) {
            this.pendingSEIData.putInt(totalLength - 4);
        } else {
            this.pendingSEIData.put((byte)0);
            this.pendingSEIData.put((byte)0);
            this.pendingSEIData.put((byte)0);
            this.pendingSEIData.put((byte)1);
        }
        if (h264Codec) {
            this.pendingSEIData.put((byte)6);
        } else {
            this.pendingSEIData.put((byte)78);
            this.pendingSEIData.put((byte)1);
        }
        this.pendingSEIData.put((byte)5);
        for (int i = 0; i < lengthByteCount - 1; ++i) {
            this.pendingSEIData.put((byte)-1);
        }
        this.pendingSEIData.put((byte)remaining);
        UUID uuid = UUID.randomUUID();
        this.pendingSEIData.putLong(uuid.getMostSignificantBits());
        this.pendingSEIData.putLong(uuid.getLeastSignificantBits());
        this.pendingSEIData.put(data.getBytes());
        this.pendingSEIData.put((byte)-128);
        this.pendingSEIData.rewind();
    }

    public static void logError(int ret, String message, String streamId) {
        if (ret < 0 && logger.isErrorEnabled()) {
            logger.error(message, (Object)streamId, (Object)Muxer.getErrorDefinition(ret));
        }
    }

    @Override
    public synchronized boolean addStream(AVCodecParameters codecParameters, AVRational timebase, int streamIndex) {
        if (codecParameters.codec_id() == 27) {
            this.setBitstreamFilter("h264_mp4toannexb");
        } else if (codecParameters.codec_id() == 173) {
            this.setBitstreamFilter("hevc_mp4toannexb");
        } else if (codecParameters.codec_id() == 86018 && HLS_SEGMENT_TYPE_FMP4.equals(this.hlsSegmentType)) {
            this.setAudioBitreamFilter("aac_adtstoasc");
        }
        return super.addStream(codecParameters, timebase, streamIndex);
    }

    public boolean addID3Stream() {
        AVCodecParameters codecParameter = new AVCodecParameters();
        codecParameter.codec_type(2);
        codecParameter.codec_id(98313);
        return super.addStream(codecParameter, MuxAdaptor.getTimeBaseForMs(), this.id3StreamIndex);
    }

    public String getHlsListSize() {
        return this.hlsListSize;
    }

    public void setHlsListSize(String hlsListSize) {
        this.hlsListSize = hlsListSize;
    }

    public String getHlsTime() {
        return this.hlsTime;
    }

    public void setHlsTime(String hlsTime) {
        this.hlsTime = hlsTime;
    }

    public String getHlsPlayListType() {
        return this.hlsPlayListType;
    }

    public void setHlsPlayListType(String hlsPlayListType) {
        this.hlsPlayListType = hlsPlayListType;
    }

    public boolean isDeleteFileOnExit() {
        return this.deleteFileOnExit;
    }

    public void setDeleteFileOnExit(boolean deleteFileOnExist) {
        this.deleteFileOnExit = deleteFileOnExist;
    }

    public boolean isUploadingToS3() {
        return this.uploadHLSToS3;
    }

    public String getSegmentFilename() {
        return this.segmentFilename;
    }

    public void setId3Enabled(boolean id3Enabled) {
        this.id3Enabled = id3Enabled;
    }

    @Override
    protected synchronized void clearResource() {
        super.clearResource();
        if (this.id3DataPkt != null) {
            avcodec.av_packet_free((AVPacket)this.id3DataPkt);
            this.id3DataPkt = null;
        }
        if (this.tmpPacketForSEI != null) {
            avcodec.av_packet_free((AVPacket)this.tmpPacketForSEI);
            this.tmpPacketForSEI = null;
        }
    }

    public ByteBuffer getPendingSEIData() {
        return this.pendingSEIData;
    }
}

