/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.muxer;

import io.antmedia.muxer.IEndpointStatusListener;
import io.antmedia.muxer.Muxer;
import io.vertx.core.Vertx;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bytedeco.ffmpeg.avcodec.AVBSFContext;
import org.bytedeco.ffmpeg.avcodec.AVCodec;
import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.bytedeco.ffmpeg.avformat.AVStream;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.ffmpeg.global.avformat;
import org.bytedeco.ffmpeg.global.avutil;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.SizeTPointer;

public class RtmpMuxer
extends Muxer {
    private String url;
    private volatile boolean trailerWritten = false;
    private IEndpointStatusListener statusListener;
    private BytePointer allocatedExtraDataPointer = null;
    private String status = "created";
    boolean keyFrameReceived = false;
    private AtomicBoolean preparedIO = new AtomicBoolean(false);

    public RtmpMuxer(String url, Vertx vertx) {
        super(vertx);
        this.format = "flv";
        this.url = url;
        this.parseRtmpURL(this.url);
    }

    void parseRtmpURL(String url) {
        if (url == null) {
            return;
        }
        String regex = "rtmp(s)?://[a-zA-Z0-9\\.-]+(:[0-9]+)?/([^/]+)/.*";
        Pattern rtmpAppName = Pattern.compile(regex);
        Matcher checkAppName = rtmpAppName.matcher(url);
        if (!checkAppName.matches()) {
            this.setOption("rtmp_app", "");
        }
    }

    @Override
    public String getOutputURL() {
        return this.url;
    }

    @Override
    public synchronized boolean addStream(AVCodec codec, AVCodecContext codecContext, int streamIndex) {
        boolean result = super.addStream(codec, codecContext, streamIndex);
        this.setStatus(result ? "preparing" : "failed");
        return result;
    }

    public void setStatusListener(IEndpointStatusListener listener) {
        this.statusListener = listener;
    }

    @Override
    public AVFormatContext getOutputFormatContext() {
        if (this.outputFormatContext == null) {
            this.logger.info("Creating outputFormatContext");
            this.outputFormatContext = new AVFormatContext(null);
            int ret = avformat.avformat_alloc_output_context2((AVFormatContext)this.outputFormatContext, null, (String)this.format, null);
            if (ret < 0) {
                this.setStatus("failed");
                this.logger.info("Could not create output context for url {}", (Object)this.url);
                return null;
            }
        }
        return this.outputFormatContext;
    }

    public void setStatus(String status) {
        if (!this.status.equals(status) && this.statusListener != null) {
            this.statusListener.endpointStatusUpdated(this.url, status);
        }
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public synchronized boolean prepareIO() {
        if (this.preparedIO.get()) {
            return false;
        }
        this.preparedIO.set(true);
        boolean result = false;
        if (this.getOutputFormatContext().nb_streams() > 0) {
            this.vertx.executeBlocking(b -> {
                if (this.openIO()) {
                    if (this.bsfFilterContextList.isEmpty()) {
                        this.writeHeader();
                        return;
                    }
                    this.isRunning.set(true);
                    this.setStatus("broadcasting");
                } else {
                    this.clearResource();
                    this.setStatus("failed");
                    this.logger.error("Cannot initializeOutputFormatContextIO for rtmp endpoint:{}", (Object)this.url);
                }
            }, null);
            result = true;
        } else {
            this.setStatus("failed");
        }
        return result;
    }

    @Override
    public synchronized boolean writeHeader() {
        if (!this.trailerWritten) {
            long startTime = System.currentTimeMillis();
            super.writeHeader();
            long diff = System.currentTimeMillis() - startTime;
            this.logger.info("write header takes {} for rtmp:{} the bitstream filter name is {}", new Object[]{diff, this.getOutputURL(), this.getBitStreamFilter()});
            this.headerWritten = true;
            this.setStatus("broadcasting");
            return true;
        }
        this.logger.warn("Trying to write header after writing trailer");
        return false;
    }

    @Override
    public synchronized void writeTrailer() {
        if (this.headerWritten) {
            super.writeTrailer();
            this.trailerWritten = true;
        } else {
            this.logger.info("Not writing trailer because header is not written yet");
        }
        this.setStatus("finished");
    }

    @Override
    public synchronized void clearResource() {
        super.clearResource();
    }

    @Override
    public synchronized boolean addVideoStream(int width, int height, AVRational timebase, int codecId, int streamIndex, boolean isAVC, AVCodecParameters codecpar) {
        boolean result = super.addVideoStream(width, height, timebase, codecId, streamIndex, isAVC, codecpar);
        if (result) {
            AVStream outStream = this.getOutputFormatContext().streams(((Integer)this.inputOutputStreamIndexMap.get(streamIndex)).intValue());
            this.setBitstreamFilter("extract_extradata");
            AVBSFContext avbsfContext = this.initVideoBitstreamFilter(this.getBitStreamFilter(), outStream.codecpar(), (AVRational)this.inputTimeBaseMap.get(streamIndex));
            if (avbsfContext != null) {
                int ret = avcodec.avcodec_parameters_copy((AVCodecParameters)outStream.codecpar(), (AVCodecParameters)avbsfContext.par_out());
                result = ret == 0;
            }
            this.logger.info("Adding video stream index:{} for stream:{}", (Object)streamIndex, (Object)this.url);
        }
        return result;
    }

    @Override
    public synchronized void writePacket(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase, int codecType) {
        AVFormatContext context = this.getOutputFormatContext();
        if (context.streams(pkt.stream_index()).codecpar().codec_type() == 1 && !this.headerWritten) {
            this.logger.info("Not writing audio packet to muxer because header is not written yet for {}", (Object)this.url);
            return;
        }
        this.writeFrameInternal(pkt, inputTimebase, outputTimebase, context, codecType);
    }

    private synchronized void writeFrameInternal(AVPacket pkt, AVRational inputTimebase, AVRational outputTimebase, AVFormatContext context, int codecType) {
        long pts = pkt.pts();
        long dts = pkt.dts();
        long duration = pkt.duration();
        long pos = pkt.pos();
        pkt.pts(avutil.av_rescale_q_rnd((long)pkt.pts(), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
        pkt.dts(avutil.av_rescale_q_rnd((long)pkt.dts(), (AVRational)inputTimebase, (AVRational)outputTimebase, (int)8197));
        pkt.duration(avutil.av_rescale_q((long)pkt.duration(), (AVRational)inputTimebase, (AVRational)outputTimebase));
        pkt.pos(-1L);
        int ret = 0;
        if (codecType == 0) {
            ret = avcodec.av_packet_ref((AVPacket)this.getTmpPacket(), (AVPacket)pkt);
            if (ret < 0) {
                this.setStatus("error");
                this.logger.error("Cannot copy packet for {}", (Object)this.file.getName());
                return;
            }
            if (!this.bsfFilterContextList.isEmpty() && this.bsfFilterContextList.get(0) != null) {
                ret = avcodec.av_bsf_send_packet((AVBSFContext)((AVBSFContext)this.bsfFilterContextList.get(0)), (AVPacket)this.getTmpPacket());
                if (ret < 0) {
                    this.setStatus("error");
                    this.logger.warn("cannot send packet to the filter");
                    return;
                }
                while (avcodec.av_bsf_receive_packet((AVBSFContext)((AVBSFContext)this.bsfFilterContextList.get(0)), (AVPacket)this.getTmpPacket()) == 0) {
                    if (!this.headerWritten) {
                        SizeTPointer size = new SizeTPointer(1L);
                        BytePointer extradataBytePointer = avcodec.av_packet_get_side_data((AVPacket)this.getTmpPacket(), (int)1, (SizeTPointer)size);
                        if (size.get() != 0L) {
                            this.allocatedExtraDataPointer = new BytePointer(avutil.av_malloc((long)(size.get() + 64L))).capacity(size.get() + 64L);
                            byte[] extraDataArray = new byte[(int)size.get()];
                            extradataBytePointer.get(extraDataArray, 0, extraDataArray.length);
                            this.allocatedExtraDataPointer.put(extraDataArray, 0, extraDataArray.length);
                            this.logger.info("extradata size:{} extradata: {} allocated pointer: {}", new Object[]{size.get(), extradataBytePointer, this.allocatedExtraDataPointer});
                            context.streams(pkt.stream_index()).codecpar().extradata(this.allocatedExtraDataPointer);
                            context.streams(pkt.stream_index()).codecpar().extradata_size((int)size.get());
                            this.writeHeader();
                            this.setStatus("broadcasting");
                        }
                    }
                    if (this.headerWritten) {
                        this.avWriteFrame(pkt, context);
                        continue;
                    }
                    this.setStatus("error");
                    this.logger.warn("Header is not written yet for writing video packet for stream: {}", (Object)this.file.getName());
                }
            } else {
                this.avWriteFrame(pkt, context);
            }
            avcodec.av_packet_unref((AVPacket)this.getTmpPacket());
        } else if (codecType == 1 && this.headerWritten) {
            avcodec.av_packet_ref((AVPacket)this.getTmpPacket(), (AVPacket)pkt);
            ret = avformat.av_interleaved_write_frame((AVFormatContext)context, (AVPacket)this.getTmpPacket());
            if (ret < 0 && this.logger.isInfoEnabled()) {
                this.setStatus("error");
                this.logPacketIssue("Cannot write audio packet for stream:{} and url:{}. Packet pts:{} dts:{} and Error is {}", this.streamId, this.getOutputURL(), pkt.pts(), pkt.dts(), RtmpMuxer.getErrorDefinition(ret));
            } else {
                this.setStatus("broadcasting");
                this.logPacketIssue("Write audio packet for stream:{} and url:{}. Packet pts:{} dts:{}", this.streamId, this.getOutputURL(), pkt.pts(), pkt.dts());
            }
            avcodec.av_packet_unref((AVPacket)this.getTmpPacket());
        }
        pkt.pts(pts);
        pkt.dts(dts);
        pkt.duration(duration);
        pkt.pos(pos);
    }

    public void avWriteFrame(AVPacket pkt, AVFormatContext context) {
        int ret = 0;
        boolean isKeyFrame = false;
        if ((pkt.flags() & 1) == 1) {
            isKeyFrame = true;
        }
        this.addExtradataIfRequired(pkt, isKeyFrame);
        ret = avformat.av_interleaved_write_frame((AVFormatContext)context, (AVPacket)this.getTmpPacket());
        if (ret < 0 && this.logger.isInfoEnabled()) {
            this.setStatus("error");
            this.logPacketIssue("Cannot write video packet for stream:{} and url:{}. Packet pts:{}, dts:{} Error is {}", this.streamId, this.getOutputURL(), pkt.pts(), pkt.dts(), RtmpMuxer.getErrorDefinition(ret));
        } else {
            this.logPacketIssue("Write video packet for stream:{} and url:{}. Packet pts:{}, dts:{}", this.streamId, this.getOutputURL(), pkt.pts(), pkt.dts());
            this.setStatus("broadcasting");
        }
    }

    @Override
    public synchronized void writeVideoBuffer(ByteBuffer encodedVideoFrame, long dts, int frameRotation, int streamIndex, boolean isKeyFrame, long firstFrameTimeStamp, long pts) {
        if (!this.isRunning.get() || !this.registeredStreamIndexList.contains(streamIndex)) {
            this.logPacketIssue("Not writing to RTMP muxer because it's not started for {}", this.url);
            return;
        }
        if (!this.keyFrameReceived && isKeyFrame) {
            this.keyFrameReceived = true;
            this.logger.info("Key frame is received to start for rtmp:{}", (Object)this.url);
        }
        if (this.keyFrameReceived) {
            super.writeVideoBuffer(encodedVideoFrame, dts, frameRotation, streamIndex, isKeyFrame, firstFrameTimeStamp, pts);
        }
    }

    @Override
    public boolean isCodecSupported(int codecId) {
        return codecId == 27 || codecId == 86018;
    }
}

