/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import io.antmedia.AppSettings;
import io.antmedia.filter.JWTFilter;
import io.antmedia.pushnotification.IPushNotificationService;
import io.antmedia.rest.model.PushNotificationToSubscribers;
import io.antmedia.rest.model.Result;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component
@Path(value="/v2/push-notification")
public class PushNotificationRestService {
    @Context
    protected ServletContext servletContext;
    protected ApplicationContext appCtx;
    private IPushNotificationService pushNotificationService;
    private AppSettings appSettings;

    public ApplicationContext getAppContext() {
        if (this.servletContext != null) {
            this.appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
        return this.appCtx;
    }

    public IPushNotificationService getPushNotificationService() {
        ApplicationContext appContext;
        if (this.pushNotificationService == null && (appContext = this.getAppContext()) != null) {
            this.pushNotificationService = (IPushNotificationService)appContext.getBean("push.notification.service");
        }
        return this.pushNotificationService;
    }

    public AppSettings getAppSettings() {
        ApplicationContext appContext;
        if (this.appSettings == null && (appContext = this.getAppContext()) != null) {
            this.appSettings = (AppSettings)appContext.getBean("app.settings");
        }
        return this.appSettings;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/subscriber-auth-token")
    public Result getSubscriberAuthenticationToken(@QueryParam(value="subscriberId") String subscriberId, @QueryParam(value="timeoutSeconds") int timeoutDurationInSeconds) {
        if (timeoutDurationInSeconds <= 0) {
            timeoutDurationInSeconds = 3600;
        }
        if (StringUtils.isNotBlank((CharSequence)subscriberId)) {
            long expireTimeMs = System.currentTimeMillis() + (long)(timeoutDurationInSeconds * 1000);
            String jwtToken = JWTFilter.generateJwtToken(this.getAppSettings().getSubscriberAuthenticationKey(), expireTimeMs, "subscriberId", subscriberId);
            return new Result(true, jwtToken, "Token is available in dataId field");
        }
        return new Result(false, "subscriberId is blank. Please give subscriberId as query parameter");
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/subscribers")
    public Result sendPushNotification(PushNotificationToSubscribers pushNotificationToSubcribers, @QueryParam(value="serviceName") String serviceName) {
        JSONParser parser = new JSONParser();
        try {
            if (StringUtils.isBlank((CharSequence)serviceName)) {
                return this.getPushNotificationService().sendNotification(pushNotificationToSubcribers.getSubscribers(), (JSONObject)parser.parse(pushNotificationToSubcribers.getJsonMessage()));
            }
            return this.getPushNotificationService().sendNotification(pushNotificationToSubcribers.getSubscribers(), (JSONObject)parser.parse(pushNotificationToSubcribers.getJsonMessage()), serviceName);
        }
        catch (ParseException e) {
            return new Result(false, "JSON content cannot be parsed. Make sure JSON content is in correct format");
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/topics/{topic}")
    public Result sendPushNotification(@PathParam(value="topic") String topic, String jsonMessage, @QueryParam(value="serviceName") String serviceName) {
        JSONParser parser = new JSONParser();
        try {
            if (StringUtils.isBlank((CharSequence)serviceName)) {
                return this.getPushNotificationService().sendNotification(topic, (JSONObject)parser.parse(jsonMessage));
            }
            return this.getPushNotificationService().sendNotification(topic, (JSONObject)parser.parse(jsonMessage), serviceName);
        }
        catch (ParseException e) {
            return new Result(false, "JSON content cannot be parsed");
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

