/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import io.antmedia.datastore.db.types.VoD;
import io.antmedia.rest.BroadcastRestService;
import io.antmedia.rest.RestServiceBase;
import io.antmedia.rest.model.Result;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.servers.Server;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;

@OpenAPIDefinition(info=@Info(description="Ant Media Server REST API Reference", version="V2.0", title="Ant Media Server REST API Reference", contact=@Contact(name="Ant Media Info", email="contact@antmedia.io", url="https://antmedia.io"), license=@License(name="Apache 2.0", url="http://www.apache.org")), servers={@Server(description="test server", url="https://test.antmedia.io:5443/Sandbox/rest/")}, externalDocs=@ExternalDocumentation(url="https://antmedia.io"))
@Component
@Path(value="/v2/vods")
public class VoDRestService
extends RestServiceBase {
    @Override
    @Operation(summary="VoD file from database", description="Retrieves a VoD file from the database by its ID.", responses={@ApiResponse(responseCode="200", description="VoD file retrieved successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=VoD.class))}), @ApiResponse(responseCode="404", description="VoD file not found")})
    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public VoD getVoD(@Parameter(description="ID of the VoD file", required=true) @PathParam(value="id") String id) {
        return super.getVoD(id);
    }

    @Override
    @Operation(summary="Import VoDs to Stalker Portal", description="Imports VoDs to the Stalker Portal.", responses={@ApiResponse(responseCode="200", description="VoDs imported successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @POST
    @Path(value="/import-to-stalker")
    @Produces(value={"application/json"})
    public Result importVoDsToStalker() {
        return super.importVoDsToStalker();
    }

    @Operation(summary="Get the VoD list from database", description="Retrieves the list of VoD files from the database. It returns up to 50 items. You can use offset value to get result page by page.", responses={@ApiResponse(responseCode="200", description="VoD list retrieved successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=VoD.class, type="array"))})})
    @GET
    @Path(value="/list/{offset}/{size}")
    @Produces(value={"application/json"})
    public List<VoD> getVodList(@Parameter(description="Offset of the list", required=true) @PathParam(value="offset") int offset, @Parameter(description="Number of items that will be fetched", required=true) @PathParam(value="size") int size, @Parameter(description="Field to sort. Possible values are 'name', 'date'") @QueryParam(value="sort_by") String sortBy, @Parameter(description="'asc' for Ascending, 'desc' for Descending order") @QueryParam(value="order_by") String orderBy, @Parameter(description="ID of the stream to filter the results by stream ID") @QueryParam(value="streamId") String streamId, @Parameter(description="Search string") @QueryParam(value="search") String search) {
        return this.getDataStore().getVodList(offset, size, sortBy, orderBy, streamId, search);
    }

    @Operation(summary="Get the total number of VoDs", description="Retrieves the total number of VoD files in the database.", responses={@ApiResponse(responseCode="200", description="Total number of VoDs retrieved successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=BroadcastRestService.SimpleStat.class))})})
    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    public BroadcastRestService.SimpleStat getTotalVodNumber() {
        return new BroadcastRestService.SimpleStat(this.getDataStore().getTotalVodNumber());
    }

    @Operation(summary="Get the partial number of VoDs depending on the searched items", description="Retrieves the number of VoD files that include the specified search parameter.", responses={@ApiResponse(responseCode="200", description="Partial number of VoDs retrieved successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=BroadcastRestService.SimpleStat.class))})})
    @GET
    @Path(value="/count/{search}")
    @Produces(value={"application/json"})
    public BroadcastRestService.SimpleStat getTotalVodNumber(@Parameter(description="Search parameter to get the number of items including it", required=true) @PathParam(value="search") String search) {
        return new BroadcastRestService.SimpleStat(this.getDataStore().getPartialVodNumber(search));
    }

    @Override
    @Operation(summary="Delete specific VoD File", description="Deletes a specific VoD file from the database by its ID.", responses={@ApiResponse(responseCode="200", description="VoD file deleted successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))}), @ApiResponse(responseCode="404", description="VoD file not found")})
    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Result deleteVoD(@Parameter(description="ID of the VoD file", required=true) @PathParam(value="id") String id) {
        return super.deleteVoD(id);
    }

    @Override
    @Deprecated
    @Hidden
    @DELETE
    @Path(value="/bulk")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Result deleteVoDs(@Parameter(description="IDs of the VoD files", required=true) String[] vodIds) {
        return super.deleteVoDs(vodIds);
    }

    @Operation(summary="Delete bulk VoD Files based on Vod Id", description="Deletes multiple VoD files from the database by their IDs.", responses={@ApiResponse(responseCode="200", description="VoD files deleted successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @DELETE
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Result deleteVoDsBulk(@Parameter(description="Comma-separated IDs of the VoD files", required=true) @QueryParam(value="ids") String vodIds) {
        if (StringUtils.isNotBlank((CharSequence)vodIds)) {
            return super.deleteVoDs(vodIds.split(","));
        }
        return new Result(false, "ids parameter is blank. Please give comma-separated vod ids to the 'ids' as query parameter");
    }

    @Override
    @Operation(summary="Upload external VoD file to Ant Media Server", description="Uploads an external VoD file to Ant Media Server.", responses={@ApiResponse(responseCode="200", description="VoD file uploaded successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @POST
    @Path(value="/create")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Result uploadVoDFile(@Parameter(description="Name of the VoD File", required=true) @QueryParam(value="name") String fileName, @Parameter(description="VoD file", required=true) @FormDataParam(value="file") InputStream inputStream) {
        return super.uploadVoDFile(fileName, inputStream);
    }

    @Override
    @Operation(summary="Import VoD files from a directory and make them streamable.", description="Imports VoD files from a directory to the datastore and links them to the streams.", responses={@ApiResponse(responseCode="200", description="VoD files imported successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @POST
    @Path(value="/directory")
    @Produces(value={"application/json"})
    public Result importVoDs(@Parameter(description="The full path of the directory that VoD files will be imported to the datastore and linked to the streams", required=true) @QueryParam(value="directory") String directory) {
        return super.importVoDs(directory);
    }

    @Override
    @Operation(summary="Unlinks VoD path from streams directory and delete the database record.", description="Deletes the database record associated with the specified directory, without deleting the files themselves.", responses={@ApiResponse(responseCode="200", description="VoD records unlinked successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @DELETE
    @Path(value="/directory")
    @Produces(value={"application/json"})
    public Result unlinksVoD(@Parameter(description="The full path of the directory from which imported VoD files will be deleted from the database", required=true) @QueryParam(value="directory") String directory) {
        return super.unlinksVoD(directory);
    }

    @Override
    @Hidden
    @Operation(summary="Deprecated. Use import VoDs.", description="Synchronizes VoD Folder and adds them to VoD database if any file exist and creates symbolic links to that folder.", deprecated=true, responses={@ApiResponse(responseCode="200", description="VoD files synchronized successfully", content={@Content(mediaType="application/json", schema=@Schema(implementation=Result.class))})})
    @POST
    @Path(value="/synch-user-vod-list")
    @Produces(value={"application/json"})
    public Result synchUserVodList() {
        return super.synchUserVodList();
    }
}

