/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.security;

import io.antmedia.rest.model.SslConfigurationType;
import java.io.File;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslConfigurator {
    private static final Logger logger = LoggerFactory.getLogger(SslConfigurator.class);
    private SslConfigurationType type;
    private String domain;
    private File fullChainFile;
    private File privateKeyFile;
    private File chainFile;

    public String getCommand() {
        logger.info("SSL configuration with configuration type {} has started.", (Object)this.type);
        String installDirectory = Paths.get("", new String[0]).toAbsolutePath().toString();
        switch (this.type) {
            case CUSTOM_DOMAIN: {
                return "sudo /bin/bash enable_ssl.sh -d " + this.domain + " -i " + installDirectory;
            }
            case ANTMEDIA_SUBDOMAIN: {
                return "sudo /bin/bash enable_ssl.sh -i " + installDirectory;
            }
            case CUSTOM_CERTIFICATE: {
                return "sudo /bin/bash enable_ssl.sh -f " + this.fullChainFile.getAbsolutePath() + " -p " + this.privateKeyFile.getAbsolutePath() + " -c " + this.chainFile.getAbsolutePath() + " -d " + this.domain + " -i " + installDirectory;
            }
        }
        logger.warn("No SSL configuration type. SSL configuration failed.");
        return null;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setType(SslConfigurationType type) {
        this.type = type;
    }

    public void setFullChainFile(File fullChainFile) {
        this.fullChainFile = fullChainFile;
    }

    public void setPrivateKeyFile(File privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public void setChainFile(File chainFile) {
        this.chainFile = chainFile;
    }
}

