/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.servlet;

import com.amazonaws.event.ProgressEventType;
import io.antmedia.AppSettings;
import io.antmedia.muxer.Muxer;
import io.antmedia.storage.StorageClient;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

@MultipartConfig
public class UploadHLSChunk
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected static Logger logger = LoggerFactory.getLogger(UploadHLSChunk.class);

    public StorageClient getStorageClient(HttpServletRequest req) {
        ConfigurableWebApplicationContext appContext = (ConfigurableWebApplicationContext)req.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (appContext != null && appContext.isRunning()) {
            StorageClient storageClient = (StorageClient)appContext.getBean("app.storageClient");
            if (storageClient.isEnabled()) {
                return storageClient;
            }
            logger.warn("Storage client is not enabled for request:{}", (Object)req.getRequestURI());
        } else {
            logger.warn("AppContext is not running for write request to {}", (Object)req.getRequestURI());
        }
        return null;
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        StorageClient storageClient = this.getStorageClient(req);
        if (storageClient != null) {
            try {
                ConfigurableWebApplicationContext appContext = (ConfigurableWebApplicationContext)req.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
                AppSettings appSettings = (AppSettings)appContext.getBean("app.settings");
                storageClient.delete(UploadHLSChunk.getS3Key(req, appSettings));
            }
            catch (IllegalStateException | BeansException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public void doDeleteForUnitTests(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.doDelete(req, resp);
        }
        catch (ServletException | IOException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) {
        StorageClient storageClient = this.getStorageClient(req);
        if (storageClient != null) {
            try {
                ConfigurableWebApplicationContext appContext = (ConfigurableWebApplicationContext)req.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
                this.uploadHLSChunk(storageClient, appContext, (InputStream)req.getInputStream(), req, resp);
            }
            catch (IOException | IllegalStateException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public void doPutForUnitTests(HttpServletRequest req, HttpServletResponse resp) {
        this.doPut(req, resp);
    }

    public void uploadHLSChunk(StorageClient storageClient, ConfigurableWebApplicationContext appContext, InputStream inputStream, HttpServletRequest req, HttpServletResponse resp) {
        AppSettings appSettings = (AppSettings)appContext.getBean("app.settings");
        String s3FileKey = UploadHLSChunk.getS3Key(req, appSettings);
        storageClient.setProgressListener(event -> {
            if (event.getEventType() == ProgressEventType.TRANSFER_FAILED_EVENT) {
                logger.error("S3 - Error: Upload failed for {} with key {}", (Object)req.getPathInfo(), (Object)s3FileKey);
            } else if (event.getEventType() == ProgressEventType.TRANSFER_COMPLETED_EVENT) {
                logger.info("File uploaded to S3 with key: {}", (Object)s3FileKey);
            }
        });
        storageClient.save(s3FileKey, inputStream, true);
    }

    public static String getS3Key(HttpServletRequest req, AppSettings appSettings) {
        return Muxer.replaceDoubleSlashesWithSingleSlash(appSettings.getS3StreamsFolderPath() + File.separator + req.getPathInfo());
    }
}

