/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.settings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.antmedia.licence.ILicenceService;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.catalina.util.NetMask;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bytedeco.ffmpeg.global.avutil;
import org.red5.server.tomcat.TomcatConnector;
import org.red5.server.tomcat.TomcatLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.PropertySource;
import org.webrtc.Logging;

@PropertySource(value={"/conf/red5.properties"})
@JsonIgnoreProperties(ignoreUnknown=true)
public class ServerSettings
implements ApplicationContextAware,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BEAN_NAME = "ant.media.server.settings";
    private static final String SETTINGS_HEART_BEAT_ENABLED = "server.heartbeatEnabled";
    private static final String SETTINGS_USE_GLOBAL_IP = "useGlobalIp";
    private static final String SETTINGS_PROXY_ADDRESS = "proxy.address";
    private static final String SETTINGS_NODE_GROUP = "nodeGroup";
    public static final String LOG_LEVEL_ALL = "ALL";
    public static final String LOG_LEVEL_TRACE = "TRACE";
    public static final String LOG_LEVEL_DEBUG = "DEBUG";
    public static final String LOG_LEVEL_INFO = "INFO";
    public static final String LOG_LEVEL_WARN = "WARN";
    public static final String LOG_LEVEL_ERROR = "ERROR";
    public static final String LOG_LEVEL_OFF = "OFF";
    public static final String DEFAULT_NODE_GROUP = "default";
    private static final String SETTINGS_CPU_MEASUREMENT_PERIOD_MS = "server.cpu_measurement_period_ms";
    private static final String SETTINGS_CPU_MEASUREMENT_WINDOW_SIZE = "server.cpu_measurement_window_size";
    private static final String SETTINGS_SERVER_DEFAULT_HTTP_PORT = "http.port";
    private static final String SETTINGS_ORIGIN_PORT = "server.origin_port";
    private static final String SETTINGS_SRT_PORT = "server.srt_port";
    private static final String SETTINGS_RTMP_PORT = "rtmp.port";
    private static final String ALLOWED_DASH_BOARD_CIDR = "server.allowed_dashboard_CIDR";
    private static final String SETTINGS_NATIVE_LOG_LEVEL = "nativeLogLevel";
    private static final String SETTINGS_LOG_LEVEL = "logLevel";
    private static final String SETTINGS_LICENSE_KEY = "server.licence_key";
    private static final String SETTINGS_SERVER_NAME = "server.name";
    private static final String SETTINGS_MARKET_PLACE_NAME = "server.marketplace";
    public static final String SETTINGS_JWT_SERVER_SECRET_KEY = "server.jwtServerSecretKey";
    public static final String SETTINGS_JWT_SERVER_CONTROL_ENABLED = "server.jwtServerControlEnabled";
    public static final String SETTINGS_JWKS_URL = "server.jwksURL";
    private static final String SETTINGS_SERVER_STATUS_WEBHOOK_URL = "server.statusWebHookURL";
    @Value(value="${server.allowed_dashboard_CIDR:'0.0.0.0/0'}")
    private String allowedDashboardCIDR;
    @JsonIgnore
    private transient Queue<NetMask> allowedCIDRList = new ConcurrentLinkedQueue<NetMask>();
    private static Logger logger = LoggerFactory.getLogger(ServerSettings.class);
    private static String localHostAddress;
    private static String globalHostAddress;
    private String hostAddress;
    @Value(value="${server.name:#{null}}")
    private String serverName;
    @Value(value="${server.licence_key:#{null}}")
    private String licenceKey;
    private boolean buildForMarket = false;
    @Value(value="${server.marketplace:#{null}}")
    private String marketplace;
    @Value(value="${logLevel:'INFO'}")
    private String logLevel = null;
    private boolean offlineLicense = false;
    @Value(value="${nativeLogLevel:'ERROR'}")
    private String nativeLogLevel = "ERROR";
    @Value(value="${server.heartbeatEnabled:true}")
    private boolean heartbeatEnabled;
    @Value(value="${useGlobalIp:false}")
    private boolean useGlobalIp;
    @Value(value="${proxy.address:#{null}}")
    private String proxyAddress;
    @Value(value="${nodeGroup:default}")
    private String nodeGroup = "default";
    private Logging.Severity webrtcLogLevel = Logging.Severity.LS_WARNING;
    @Value(value="${server.cpu_measurement_period_ms:1000}")
    private int cpuMeasurementPeriodMs;
    @Value(value="${server.cpu_measurement_window_size:5}")
    private int cpuMeasurementWindowSize;
    @Value(value="${http.port:5080}")
    private int defaultHttpPort;
    @Value(value="${server.jwtServerControlEnabled:false}")
    private boolean jwtServerControlEnabled;
    @Value(value="${server.jwtServerSecretKey:#{null}}")
    private String jwtServerSecretKey;
    @Value(value="${server.jwksURL:#{null}}")
    private String jwksURL;
    @Value(value="${server.origin_port:5000}")
    private int originServerPort;
    @Value(value="${server.srt_port:4200}")
    private int srtPort = 4200;
    @Value(value="${appIngestsSrtStreamsWithoutStreamId:LiveApp}")
    private String appIngestsSrtStreamsWithoutStreamId = "LiveApp";
    private boolean sslEnabled = false;
    @Value(value="${rtmp.port:1935}")
    private int rtmpPort = 1935;
    @Value(value="${server.statusWebHookURL:#{null}}")
    private String serverStatusWebHookURL;

    public String getJwksURL() {
        return this.jwksURL;
    }

    public void setJwksURL(String jwksURL) {
        this.jwksURL = jwksURL;
    }

    public boolean isBuildForMarket() {
        return this.buildForMarket;
    }

    public void setBuildForMarket(boolean buildForMarket) {
        this.buildForMarket = buildForMarket;
    }

    public String getLicenceKey() {
        return this.licenceKey;
    }

    public void setLicenceKey(String licenceKey) {
        this.licenceKey = licenceKey;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public boolean isHeartbeatEnabled() {
        return this.heartbeatEnabled;
    }

    public void setHeartbeatEnabled(boolean heartbeatEnabled) {
        this.heartbeatEnabled = heartbeatEnabled;
    }

    public String getHostAddress() {
        if (this.hostAddress == null) {
            logger.warn("ServerSettings is not initialized yet so that return local host address: {}", (Object)ServerSettings.getLocalHostAddress());
            return ServerSettings.getLocalHostAddress();
        }
        return this.hostAddress;
    }

    public static String getGlobalHostAddress() {
        if (globalHostAddress == null) {
            try (InputStream in = new URL("http://checkip.amazonaws.com").openStream();){
                globalHostAddress = IOUtils.toString((InputStream)in, (Charset)Charset.defaultCharset()).trim();
            }
            catch (IOException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return globalHostAddress;
    }

    public static String getLocalHostAddress() {
        if (localHostAddress == null) {
            long startTime = System.currentTimeMillis();
            try {
                localHostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            long diff = System.currentTimeMillis() - startTime;
            if (diff > 1000L) {
                logger.warn("Getting host adress took {}ms. it's cached now and will return immediately from now on. You can  alternatively set serverName in conf/red5.properties file ", (Object)diff);
            }
        }
        return localHostAddress;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        String hostAddressEnv = this.getHostAddressFromEnvironment();
        if (hostAddressEnv != null && !hostAddressEnv.isEmpty()) {
            logger.info("Env host address is {}", (Object)hostAddressEnv);
            this.hostAddress = hostAddressEnv;
        } else if (this.useGlobalIp) {
            this.hostAddress = ServerSettings.getGlobalHostAddress();
            logger.info("Using global host address is {}", (Object)this.hostAddress);
        } else {
            this.hostAddress = ServerSettings.getLocalHostAddress();
            logger.info("Using local host address is {}", (Object)this.hostAddress);
        }
        if (applicationContext.containsBean("tomcat.server")) {
            TomcatLoader tomcatLoader = (TomcatLoader)applicationContext.getBean("tomcat.server");
            List<TomcatConnector> connectors = tomcatLoader.getConnectors();
            for (TomcatConnector tomcatConnector : connectors) {
                if (!tomcatConnector.isSecure()) continue;
                this.sslEnabled = true;
                break;
            }
        }
        if (applicationContext.containsBean(ILicenceService.BeanName.LICENCE_SERVICE.toString())) {
            ILicenceService licenseService = (ILicenceService)applicationContext.getBean(ILicenceService.BeanName.LICENCE_SERVICE.toString());
            if ("marketplace".equals(licenseService.getLicenseType())) {
                this.buildForMarket = true;
            } else if ("offline".equals(licenseService.getLicenseType())) {
                this.offlineLicense = true;
            }
        }
        this.setNativeLogLevel(this.nativeLogLevel);
    }

    public String getHostAddressFromEnvironment() {
        return System.getenv("AMS_HOST_ADDRESS");
    }

    public boolean isUseGlobalIp() {
        return this.useGlobalIp;
    }

    public void setUseGlobalIp(boolean useGlobalIp) {
        this.useGlobalIp = useGlobalIp;
    }

    public void setProxyAddress(String proxyAddress) {
        this.proxyAddress = proxyAddress;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public void setAllowedDashboardCIDR(String allowedDashboardCIDR) {
        this.allowedDashboardCIDR = allowedDashboardCIDR;
        this.allowedCIDRList = new ConcurrentLinkedQueue<NetMask>();
        this.fillFromInput(allowedDashboardCIDR, this.allowedCIDRList);
    }

    public String getAllowedDashboardCIDR() {
        return this.allowedDashboardCIDR;
    }

    @JsonIgnore
    public Queue<NetMask> getAllowedCIDRList() {
        if (this.allowedCIDRList.isEmpty()) {
            this.fillFromInput(this.allowedDashboardCIDR, this.allowedCIDRList);
        }
        return this.allowedCIDRList;
    }

    private List<String> fillFromInput(String input, Queue<NetMask> target) {
        target.clear();
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<CallSite> messages = new LinkedList<CallSite>();
        for (String s : input.split("\\s*,\\s*")) {
            try {
                NetMask nm = new NetMask(s);
                target.add(nm);
            }
            catch (IllegalArgumentException e) {
                messages.add((CallSite)((Object)(s + ": " + e.getMessage())));
            }
        }
        return Collections.unmodifiableList(messages);
    }

    public String getNativeLogLevel() {
        return this.nativeLogLevel;
    }

    public void setNativeLogLevel(String nativeLogLevel) {
        switch (this.nativeLogLevel = nativeLogLevel) {
            case "ALL": 
            case "TRACE": {
                this.webrtcLogLevel = Logging.Severity.LS_VERBOSE;
                avutil.av_log_set_level((int)56);
                break;
            }
            case "DEBUG": {
                this.webrtcLogLevel = Logging.Severity.LS_VERBOSE;
                avutil.av_log_set_level((int)48);
                break;
            }
            case "INFO": {
                this.webrtcLogLevel = Logging.Severity.LS_INFO;
                avutil.av_log_set_level((int)32);
                break;
            }
            case "WARN": {
                this.webrtcLogLevel = Logging.Severity.LS_WARNING;
                avutil.av_log_set_level((int)24);
                break;
            }
            case "ERROR": {
                this.webrtcLogLevel = Logging.Severity.LS_ERROR;
                avutil.av_log_set_level((int)16);
                break;
            }
            case "OFF": {
                this.webrtcLogLevel = Logging.Severity.LS_NONE;
                avutil.av_log_set_level((int)-8);
                break;
            }
            default: {
                this.nativeLogLevel = LOG_LEVEL_WARN;
                this.webrtcLogLevel = Logging.Severity.LS_WARNING;
                avutil.av_log_set_level((int)24);
            }
        }
    }

    public Logging.Severity getWebRTCLogLevel() {
        return this.webrtcLogLevel;
    }

    public String getNodeGroup() {
        return this.nodeGroup;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
    }

    public int getCpuMeasurementPeriodMs() {
        return this.cpuMeasurementPeriodMs;
    }

    public void setCpuMeasurementPeriodMs(int cpuMeasurementPeriodMs) {
        this.cpuMeasurementPeriodMs = cpuMeasurementPeriodMs;
    }

    public int getCpuMeasurementWindowSize() {
        return this.cpuMeasurementWindowSize;
    }

    public void setCpuMeasurementWindowSize(int cpuMeasurementWindowSize) {
        this.cpuMeasurementWindowSize = cpuMeasurementWindowSize;
    }

    public int getDefaultHttpPort() {
        return this.defaultHttpPort;
    }

    public void setDefaultHttpPort(int defaultHttpPort) {
        this.defaultHttpPort = defaultHttpPort;
    }

    public int getOriginServerPort() {
        return this.originServerPort;
    }

    public void setOriginServerPort(int originServerPort) {
        this.originServerPort = originServerPort;
    }

    public int getSrtPort() {
        return this.srtPort;
    }

    public void setSrtPort(int srtPort) {
        this.srtPort = srtPort;
    }

    public int getRtmpPort() {
        return this.rtmpPort;
    }

    public String getMarketplace() {
        return this.marketplace;
    }

    public void setMarketplace(String marketplace) {
        this.marketplace = marketplace;
    }

    public String getJwtServerSecretKey() {
        return this.jwtServerSecretKey;
    }

    public void setJwtServerSecretKey(String jwtServerSecretKey) {
        this.jwtServerSecretKey = jwtServerSecretKey;
    }

    public boolean isJwtServerControlEnabled() {
        return this.jwtServerControlEnabled;
    }

    public void setJwtServerControlEnabled(boolean jwtServerControlEnabled) {
        this.jwtServerControlEnabled = jwtServerControlEnabled;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public String getServerStatusWebHookURL() {
        return this.serverStatusWebHookURL;
    }

    public void setServerStatusWebHookURL(String serverStatusWebHookURL) {
        this.serverStatusWebHookURL = serverStatusWebHookURL;
    }

    public boolean isOfflineLicense() {
        return this.offlineLicense;
    }

    public void setOfflineLicense(boolean offlineLicense) {
        this.offlineLicense = offlineLicense;
    }

    public String getAppIngestsSrtStreamsWithoutStreamId() {
        return this.appIngestsSrtStreamsWithoutStreamId;
    }

    public void setAppIngestsSrtStreamsWithoutStreamId(String appIngestsSrtStreamsWithoutStreamId) {
        this.appIngestsSrtStreamsWithoutStreamId = appIngestsSrtStreamsWithoutStreamId;
    }
}

