/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.shutdown;

import io.antmedia.shutdown.IShutdownListener;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMSShutdownManager {
    protected Logger logger = LoggerFactory.getLogger(AMSShutdownManager.class);
    private static AMSShutdownManager instance = new AMSShutdownManager();
    private volatile boolean isShuttingDown = false;
    private Queue<IShutdownListener> listeners = new ConcurrentLinkedQueue<IShutdownListener>();

    public static AMSShutdownManager getInstance() {
        return instance;
    }

    private AMSShutdownManager() {
    }

    public void subscribe(IShutdownListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void notifyShutdown() {
        if (!this.isShuttingDown) {
            this.isShuttingDown = true;
            for (IShutdownListener listener : this.listeners) {
                try {
                    listener.serverShuttingdown();
                }
                catch (Exception e) {
                    this.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    public Queue<IShutdownListener> getListeners() {
        return this.listeners;
    }
}

