/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.statistic;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.AppSettings;
import io.antmedia.analytic.model.PlayEvent;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.ConnectionEvent;
import io.antmedia.datastore.db.types.Subscriber;
import io.antmedia.logger.LoggerUtils;
import io.antmedia.settings.ServerSettings;
import io.vertx.core.Vertx;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewerStats {
    protected static Logger logger = LoggerFactory.getLogger(ViewerStats.class);
    protected Vertx vertx;
    public static final String HLS_TYPE = "hls";
    public static final String DASH_TYPE = "dash";
    public static final String VOD_TYPE = "vod";
    private String type;
    private DataStore dataStore;
    protected DataStoreFactory dataStoreFactory;
    public static final int DEFAULT_TIME_PERIOD_FOR_VIEWER_COUNT = 10000;
    protected String appName;
    private int timePeriodMS = 10000;
    Map<String, Map<String, Long>> streamsViewerMap = new ConcurrentHashMap<String, Map<String, Long>>();
    Map<String, String> sessionId2subscriberId = new ConcurrentHashMap<String, String>();
    Map<String, Integer> increaseCounterMap = new ConcurrentHashMap<String, Integer>();
    private Object lock = new Object();
    protected ServerSettings serverSettings;
    protected int timeoutMS = 20000;

    public void registerNewViewer(String streamId, String sessionId, String subscriberId) {
        this.vertx.runOnContext(h -> {
            Object object = this.lock;
            synchronized (object) {
                Map<String, Long> viewerMap = this.streamsViewerMap.get(streamId);
                if (viewerMap == null) {
                    viewerMap = new ConcurrentHashMap<String, Long>();
                }
                if (!viewerMap.containsKey(sessionId)) {
                    int streamIncrementCounter = this.getIncreaseCounterMap(streamId);
                    this.increaseCounterMap.put(streamId, ++streamIncrementCounter);
                    PlayEvent playStartedEvent = new PlayEvent();
                    playStartedEvent.setStreamId(streamId);
                    playStartedEvent.setProtocol(this.type);
                    playStartedEvent.setApp(this.appName);
                    playStartedEvent.setEvent("playEnded");
                    playStartedEvent.setSubscriberId(subscriberId);
                    LoggerUtils.logAnalyticsFromServer(playStartedEvent);
                }
                viewerMap.put(sessionId, System.currentTimeMillis());
                this.streamsViewerMap.put(streamId, viewerMap);
                if (subscriberId != null) {
                    Subscriber subscriber = this.getDataStore().getSubscriber(streamId, subscriberId);
                    if (subscriber == null) {
                        subscriber = new Subscriber();
                        subscriber.setStreamId(streamId);
                        subscriber.setSubscriberId(subscriberId);
                    }
                    subscriber.setRegisteredNodeIp(this.serverSettings.getHostAddress());
                    this.getDataStore().addSubscriber(streamId, subscriber);
                    this.sessionId2subscriberId.put(sessionId, subscriberId);
                    ConnectionEvent event = new ConnectionEvent();
                    event.setEventType("connected");
                    Date curDate = new Date();
                    event.setTimestamp(curDate.getTime());
                    event.setEventProtocol(this.getType());
                    if (this.getDataStore().addSubscriberConnectionEvent(streamId, subscriberId, event)) {
                        logger.info("CONNECTED_EVENT for subscriberId:{} streamId:{}", (Object)subscriberId, (Object)streamId);
                    }
                }
            }
        });
    }

    public void resetViewerMap(String streamID, String type) {
        Map<String, Long> viewerMapEntry = this.streamsViewerMap.get(streamID);
        if (viewerMapEntry != null) {
            for (Map.Entry<String, Long> viewer : viewerMapEntry.entrySet()) {
                String sessionId = viewer.getKey();
                if (!this.sessionId2subscriberId.containsKey(sessionId)) continue;
                this.sessionId2subscriberId.remove(sessionId);
            }
            this.streamsViewerMap.get(streamID).clear();
            this.streamsViewerMap.remove(streamID);
            logger.info("Reset {} Stream ID: {} removed successfully", (Object)type, (Object)streamID);
        } else {
            logger.info("Reset {} Stream ID: {} remove failed or null", (Object)type, (Object)streamID);
        }
    }

    public int getViewerCount(String streamId) {
        Map<String, Long> viewerMap = this.streamsViewerMap.get(streamId);
        int viewerCount = 0;
        if (viewerMap != null) {
            viewerCount = viewerMap.size();
        }
        return viewerCount;
    }

    public int getTotalViewerCount() {
        int viewerCount = 0;
        for (Map<String, Long> map : this.streamsViewerMap.values()) {
            viewerCount += map.size();
        }
        return viewerCount;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public DataStoreFactory getDataStoreFactory() {
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(DataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }

    public DataStore getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = this.getDataStoreFactory().getDataStore();
        }
        return this.dataStore;
    }

    public int getIncreaseCounterMap(String streamId) {
        Integer increaseCounter = this.increaseCounterMap.get(streamId);
        return increaseCounter != null ? increaseCounter : 0;
    }

    public static int getTimeoutMSFromSettings(AppSettings settings, int defaultValue, String type) {
        int newTimePeriodMS = defaultValue;
        if (type.equals(HLS_TYPE)) {
            String hlsTime = settings.getHlsTime();
            if (hlsTime != null && !hlsTime.isEmpty()) {
                try {
                    newTimePeriodMS = (int)(Double.parseDouble(hlsTime) * 10.0 * 1000.0);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        } else {
            String dashTime = settings.getDashFragmentDuration();
            if (dashTime != null && !dashTime.isEmpty()) {
                try {
                    newTimePeriodMS = (int)(Double.parseDouble(dashTime) * 20.0 * 1000.0);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        return newTimePeriodMS;
    }

    public void setTimePeriodMS(int timePeriodMS) {
        this.timePeriodMS = timePeriodMS;
    }

    public int getTimePeriodMS() {
        return this.timePeriodMS;
    }

    public int getTimeoutMS() {
        return this.timeoutMS;
    }

    public Map<String, String> getSessionId2subscriberId() {
        return this.sessionId2subscriberId;
    }

    public void setSessionId2subscriberId(Map<String, String> sessionId2subscriberId) {
        this.sessionId2subscriberId = sessionId2subscriberId;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public void updateViewerCountProcess(String type) {
        Iterator<Map.Entry<String, Map<String, Long>>> streamIterator = this.streamsViewerMap.entrySet().iterator();
        long now = System.currentTimeMillis();
        while (streamIterator.hasNext()) {
            Map<String, Long> viewerMapEntry;
            Map.Entry<String, Map<String, Long>> streamViewerEntry = streamIterator.next();
            String streamId = streamViewerEntry.getKey();
            Broadcast broadcast = this.getDataStore().get(streamId);
            boolean isBroadcasting = false;
            if (broadcast != null) {
                int numberOfDecrement = 0;
                viewerMapEntry = streamViewerEntry.getValue();
                Iterator<Map.Entry<String, Long>> viewerIterator = viewerMapEntry.entrySet().iterator();
                while (viewerIterator.hasNext()) {
                    Map.Entry<String, Long> viewer = viewerIterator.next();
                    if (viewer.getValue() >= now - (long)this.getTimeoutMS()) continue;
                    viewerIterator.remove();
                    ++numberOfDecrement;
                    String sessionId = viewer.getKey();
                    String subscriberId = this.sessionId2subscriberId.get(sessionId);
                    PlayEvent playEndedEvent = new PlayEvent();
                    playEndedEvent.setEvent("playEnded");
                    playEndedEvent.setStreamId(streamId);
                    playEndedEvent.setProtocol(type);
                    playEndedEvent.setApp(this.appName);
                    playEndedEvent.setSubscriberId(subscriberId);
                    LoggerUtils.logAnalyticsFromServer(playEndedEvent);
                    if (subscriberId == null) continue;
                    ConnectionEvent event = new ConnectionEvent();
                    event.setEventType("disconnected");
                    Date curDate = new Date();
                    event.setTimestamp(curDate.getTime());
                    event.setEventProtocol(this.getType());
                    if (!this.getDataStore().addSubscriberConnectionEvent(streamId, subscriberId, event)) continue;
                    logger.info("DISCONNECTED_EVENT for subscriberId:{} and streamId:{}", (Object)subscriberId, (Object)streamId);
                }
                isBroadcasting = this.isStreaming(broadcast);
                numberOfDecrement = -1 * numberOfDecrement;
                int numberOfIncrement = this.getIncreaseCounterMap(streamId);
                if ((numberOfIncrement != 0 || numberOfDecrement != 0) && isBroadcasting) {
                    int diffCount = numberOfIncrement + numberOfDecrement;
                    logger.info("Update {} viewer in stream ID:{} increment count:{} decrement count:{} diff:{}", new Object[]{type, streamId, numberOfIncrement, numberOfDecrement, diffCount});
                    if (type.equals(HLS_TYPE)) {
                        this.getDataStore().updateHLSViewerCount(streamViewerEntry.getKey(), diffCount);
                    } else {
                        this.getDataStore().updateDASHViewerCount(streamViewerEntry.getKey(), diffCount);
                    }
                    this.increaseCounterMap.put(streamId, 0);
                }
            }
            if (isBroadcasting) continue;
            viewerMapEntry = streamViewerEntry.getValue();
            for (Map.Entry<String, Long> viewer : viewerMapEntry.entrySet()) {
                String sessionId = viewer.getKey();
                String subscriberId = this.sessionId2subscriberId.get(sessionId);
                if (subscriberId == null) continue;
                ConnectionEvent event = new ConnectionEvent();
                event.setEventType("disconnected");
                Date curDate = new Date();
                event.setTimestamp(curDate.getTime());
                this.getDataStore().addSubscriberConnectionEvent(streamId, subscriberId, event);
            }
            streamIterator.remove();
            this.increaseCounterMap.remove(streamId);
        }
    }

    public boolean isStreaming(Broadcast broadcast) {
        return AntMediaApplicationAdapter.isStreaming(broadcast);
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

