/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.red5.io.IKeyFrameMetaCache;
import org.red5.io.flv.IKeyFrameDataAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileKeyFrameMetaCache
implements IKeyFrameMetaCache {
    private static Logger log = LoggerFactory.getLogger(FileKeyFrameMetaCache.class);

    @Override
    public IKeyFrameDataAnalyzer.KeyFrameMeta loadKeyFrameMeta(File file) {
        NodeList keyFrames;
        Document dom;
        String filename = file.getAbsolutePath() + ".meta";
        File metadataFile = new File(filename);
        if (!metadataFile.exists()) {
            return null;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.parse(filename);
            db.reset();
        }
        catch (ParserConfigurationException pce) {
            log.error("Could not parse XML file.", (Throwable)pce);
            return null;
        }
        catch (SAXException se) {
            log.error("Could not parse XML file.", (Throwable)se);
            return null;
        }
        catch (IOException ioe) {
            log.error("Could not parse XML file.", (Throwable)ioe);
            return null;
        }
        Element root = dom.getDocumentElement();
        if (!"FrameMetadata".equals(root.getNodeName())) {
            return null;
        }
        String modified = root.getAttribute("modified");
        if (modified == null || !modified.equals(String.valueOf(file.lastModified()))) {
            return null;
        }
        if (!root.hasAttribute("duration")) {
            return null;
        }
        if (!root.hasAttribute("audioOnly")) {
            return null;
        }
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            XPathExpression xexpr = xpath.compile("/FrameMetadata/KeyFrame");
            keyFrames = (NodeList)xexpr.evaluate(dom, XPathConstants.NODESET);
        }
        catch (XPathExpressionException err) {
            log.error("could not compile xpath expression", (Throwable)err);
            return null;
        }
        int length = keyFrames.getLength();
        if (keyFrames == null || length == 0) {
            return null;
        }
        IKeyFrameDataAnalyzer.KeyFrameMeta result = new IKeyFrameDataAnalyzer.KeyFrameMeta();
        result.duration = Long.parseLong(root.getAttribute("duration"));
        result.positions = new long[length];
        result.timestamps = new int[length];
        for (int i = 0; i < length; ++i) {
            Node node = keyFrames.item(i);
            NamedNodeMap attrs = node.getAttributes();
            result.positions[i] = Long.parseLong(attrs.getNamedItem("position").getNodeValue());
            result.timestamps[i] = Integer.parseInt(attrs.getNamedItem("timestamp").getNodeValue());
        }
        result.audioOnly = "true".equals(root.getAttribute("audioOnly"));
        return result;
    }

    @Override
    public void removeKeyFrameMeta(File file) {
        String filename = String.format("%s.meta", file.getAbsolutePath());
        File metadataFile = new File(filename);
        if (metadataFile.exists()) {
            log.trace("Meta file exists");
            if (metadataFile.delete()) {
                log.debug("Meta file deleted - {}", (Object)filename);
            } else {
                log.warn("Meta file was not deleted - {}", (Object)filename);
                metadataFile.deleteOnExit();
            }
        } else {
            log.debug("Meta file does not exist: {}", (Object)filename);
        }
    }

    @Override
    public void saveKeyFrameMeta(File file, IKeyFrameDataAnalyzer.KeyFrameMeta meta) {
        log.error("Save keyframe meta not implemented");
    }
}

