/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.amf3;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.io.amf.AMF;
import org.red5.io.amf3.IDataOutput;
import org.red5.io.amf3.Output;
import org.red5.io.object.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataOutput
implements IDataOutput {
    private static Logger logger = LoggerFactory.getLogger(DataOutput.class);
    private Output output;
    private IoBuffer buffer;

    protected DataOutput(Output output) {
        this.output = output;
        this.buffer = output.getBuffer();
    }

    @Override
    public ByteOrder getEndian() {
        return this.buffer.order();
    }

    @Override
    public void setEndian(ByteOrder endian) {
        this.buffer.order(endian);
    }

    @Override
    public void writeBoolean(boolean value) {
        this.buffer.put((byte)(value ? 1 : 0));
    }

    @Override
    public void writeByte(byte value) {
        this.buffer.put(value);
    }

    @Override
    public void writeBytes(byte[] bytes) {
        this.buffer.put(bytes);
    }

    @Override
    public void writeBytes(byte[] bytes, int offset) {
        this.buffer.put(bytes, offset, bytes.length - offset);
    }

    @Override
    public void writeBytes(byte[] bytes, int offset, int length) {
        this.buffer.put(bytes, offset, length);
    }

    @Override
    public void writeDouble(double value) {
        this.buffer.putDouble(value);
    }

    @Override
    public void writeFloat(float value) {
        this.buffer.putFloat(value);
    }

    @Override
    public void writeInt(int value) {
        this.buffer.putInt(value);
    }

    @Override
    public void writeMultiByte(String value, String encoding) {
        Charset cs = Charset.forName(encoding);
        ByteBuffer strBuf = cs.encode(value);
        this.buffer.put(strBuf);
    }

    @Override
    public void writeObject(Object value) {
        Serializer.serialize(this.output, value);
    }

    @Override
    public void writeShort(short value) {
        this.buffer.putShort(value);
    }

    @Override
    public void writeUnsignedInt(long value) {
        this.buffer.putInt((int)value);
    }

    @Override
    public void writeUTF(String value) {
        try {
            byte[] strBuf = value.getBytes(AMF.CHARSET.name());
            this.buffer.putShort((short)strBuf.length);
            this.buffer.put(strBuf);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public void writeUTFBytes(String value) {
        ByteBuffer strBuf = AMF.CHARSET.encode(value);
        this.buffer.put(strBuf);
    }
}

