/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.flv.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.cache.ICacheStore;
import org.red5.cache.ICacheable;
import org.red5.cache.impl.NoCacheImpl;
import org.red5.io.ITag;
import org.red5.io.ITagReader;
import org.red5.io.ITagWriter;
import org.red5.io.flv.IFLV;
import org.red5.io.flv.impl.FLVReader;
import org.red5.io.flv.impl.FLVWriter;
import org.red5.io.flv.meta.IMetaData;
import org.red5.io.flv.meta.IMetaService;
import org.red5.io.flv.meta.MetaData;
import org.red5.io.flv.meta.MetaService;
import org.red5.media.processor.IPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLV
implements IFLV {
    protected static Logger log = LoggerFactory.getLogger(FLV.class);
    private static ICacheStore cache;
    private static LinkedList<Class<IPostProcessor>> writePostProcessors;
    private File file;
    private boolean generateMetadata;
    private IMetaService metaService;
    private IMetaData<?, ?> metaData;

    public FLV() {
    }

    public FLV(File file) {
        this(file, false);
    }

    public FLV(File file, boolean generateMetadata) {
        this.file = file;
        this.generateMetadata = generateMetadata;
        if (!generateMetadata) {
            try {
                FLVReader reader = new FLVReader(this.file);
                ITag tag = null;
                int count = 0;
                while (reader.hasMoreTags() && ++count < 5) {
                    tag = reader.readTag();
                    if (tag.getDataType() != 18) continue;
                    if (this.metaService == null) {
                        this.metaService = new MetaService();
                    }
                    this.metaData = this.metaService.readMetaData(tag.getBody());
                }
                reader.close();
            }
            catch (Exception e) {
                log.error("An error occured looking for metadata", (Throwable)e);
            }
        }
    }

    @Override
    public void setCache(ICacheStore cache) {
        FLV.cache = cache;
    }

    public void setWriterPostProcessor(String writerPostProcessor) {
        if (writePostProcessors == null) {
            writePostProcessors = new LinkedList();
        }
        try {
            writePostProcessors.add(Class.forName(writerPostProcessor));
        }
        catch (Exception e) {
            log.debug("Write post process implementation: {} was not found", (Object)writerPostProcessor);
        }
    }

    public void setWriterPostProcessors(Set<String> writerPostProcessors) {
        if (writePostProcessors == null) {
            writePostProcessors = new LinkedList();
        }
        for (String writerPostProcessor : writerPostProcessors) {
            try {
                writePostProcessors.add(Class.forName(writerPostProcessor));
            }
            catch (Exception e) {
                log.debug("Write post process implementation: {} was not found", (Object)writerPostProcessor);
            }
        }
    }

    public LinkedList<Class<IPostProcessor>> getWritePostProcessors() {
        return writePostProcessors;
    }

    @Override
    public boolean hasMetaData() {
        return this.metaData != null;
    }

    @Override
    public IMetaData getMetaData() throws FileNotFoundException {
        this.metaService.setFile(this.file);
        return null;
    }

    @Override
    public boolean hasKeyFrameData() {
        return false;
    }

    @Override
    public void setKeyFrameData(Map keyframedata) {
        Map.Entry entry;
        Map.Entry o;
        Iterator iterator;
        if (!this.hasMetaData()) {
            this.metaData = new MetaData();
        }
        HashMap<String, Double> times = new HashMap<String, Double>();
        HashMap<String, Double> filepositions = new HashMap<String, Double>();
        if (keyframedata.containsKey("times")) {
            Map inTimes = (Map)keyframedata.get("times");
            iterator = inTimes.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = o = iterator.next();
                times.put((String)entry.getKey(), (Double)entry.getValue());
            }
        }
        ((MetaData)this.metaData).put("times", times);
        if (keyframedata.containsKey("filepositions")) {
            Map inPos = (Map)keyframedata.get("filepositions");
            iterator = inPos.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = o = iterator.next();
                filepositions.put((String)entry.getKey(), (Double)entry.getValue());
            }
        }
        ((MetaData)this.metaData).put("filepositions", filepositions);
    }

    @Override
    public Map getKeyFrameData() {
        Map keyframes = null;
        return keyframes;
    }

    @Override
    public void refreshHeaders() throws IOException {
    }

    @Override
    public void flushHeaders() throws IOException {
    }

    @Override
    public ITagReader getReader() throws IOException {
        ICacheable ic;
        FLVReader reader = null;
        String fileName = this.file.getName();
        if (cache == null) {
            log.info("FLV cache is null, forcing NoCacheImpl instance");
            cache = NoCacheImpl.getInstance();
        }
        if (null == (ic = cache.get(fileName)) || null == ic.getByteBuffer()) {
            if (this.file.exists()) {
                log.debug("File size: {}", (Object)this.file.length());
                reader = new FLVReader(this.file, this.generateMetadata);
                IoBuffer fileData = reader.getFileData();
                if (fileData != null && cache.offer(fileName, fileData)) {
                    log.debug("Item accepted by the cache: {}", (Object)fileName);
                } else {
                    log.debug("Item will not be cached: {}", (Object)fileName);
                }
            } else {
                boolean result = this.file.createNewFile();
                log.info("Creating new file: {} and result is {}", (Object)this.file, (Object)result);
            }
        } else {
            IoBuffer fileData = IoBuffer.wrap((byte[])ic.getBytes());
            reader = new FLVReader(fileData, this.generateMetadata);
        }
        return reader;
    }

    @Override
    public ITagReader readerFromNearestKeyFrame(int seekPoint) {
        return null;
    }

    @Override
    public ITagWriter getWriter() throws IOException {
        log.info("getWriter: {}", (Object)this.file);
        return new FLVWriter(this.file.toPath(), false);
    }

    @Override
    public ITagWriter getAppendWriter() throws IOException {
        log.info("getAppendWriter: {}", (Object)this.file);
        return new FLVWriter(this.file.toPath(), true);
    }

    @Override
    public ITagWriter writerFromNearestKeyFrame(int seekPoint) {
        return null;
    }

    @Override
    public void setMetaData(IMetaData meta) throws IOException {
        log.info("setMetaData: {}", (Object)meta);
        if (this.metaService == null) {
            this.metaService = new MetaService(this.file);
        }
        if (this.metaService.getFile() == null) {
            this.metaService.setFile(this.file);
        }
        this.metaService.write(meta);
        this.metaData = meta;
    }

    @Override
    public void setMetaService(IMetaService service) {
        this.metaService = service;
    }
}

