/*
 * Decompiled with CFR 0.152.
 */
package org.red5.io.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.red5.io.utils.DOM2Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XMLUtils {
    protected static Logger log = LoggerFactory.getLogger(XMLUtils.class);

    public static Document stringToDoc(String str) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            Document document;
            StringReader reader = new StringReader(str);
            try {
                Document doc;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                DocumentBuilder db = factory.newDocumentBuilder();
                document = doc = db.parse(new InputSource(reader));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    log.debug("String: {}", (Object)str);
                    throw new IOException(String.format("Error converting from string to doc %s", ex.getMessage()));
                }
            }
            ((Reader)reader).close();
            return document;
        }
        throw new IOException("Error - could not convert empty string to doc");
    }

    public static String docToString(Document dom) {
        return XMLUtils.docToString1(dom);
    }

    public static String docToString1(Document dom) {
        StringWriter sw = new StringWriter();
        DOM2Writer.serializeAsXML(dom, sw);
        return sw.toString();
    }
}

