/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.nio.file.Paths;

public class Shutdown {
    public static void main(String[] args) {
        String host = System.getProperty("red5.shutdown.host", "127.0.0.1");
        try (Socket clientSocket = new Socket(host, (int)Integer.valueOf(args[0]));
             PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
             BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));){
            String token = "cafebeef";
            token = args.length > 1 ? args[1] : Shutdown.getToken(token);
            out.println(token);
            in.readLine();
        }
        catch (Exception e) {
            System.err.printf("Exception connecting to %s%n", host);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String getToken(String token) {
        File tokenFile = Paths.get("shutdown.token", new String[0]).toFile();
        try (RandomAccessFile raf = new RandomAccessFile(tokenFile, "r");){
            byte[] buf = new byte[36];
            raf.readFully(buf);
            token = new String(buf);
            System.out.printf("Token loaded: %s%n", token);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return token;
    }
}

