/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.api;

import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import org.red5.logging.Red5LoggerFactory;
import org.red5.server.api.IClient;
import org.red5.server.api.IConnection;
import org.red5.server.api.IContext;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;

public final class Red5 {
    private static Logger log = Red5LoggerFactory.getLogger(Red5.class);
    private static final ThreadLocal<WeakReference<IConnection>> connThreadLocal = new ThreadLocal();
    public IConnection conn;
    public static final String VERSION = "Red5 Server 1.0.9";
    public static final String FMS_VERSION = "RED5/1,0,9,0";
    public static final Integer CAPABILITIES = 33;
    public static final Map<String, Object> DATA_VERSION = new HashMap<String, Object>(2){
        {
            this.put("version", "4,0,0,1121");
            this.put("type", "red5");
        }
    };
    private static final long START_TIME = System.currentTimeMillis();
    private static boolean debug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("jdwp") >= 0;

    public Red5(IConnection conn) {
        this.conn = conn;
    }

    public Red5() {
        this.conn = Red5.getConnectionLocal();
    }

    public static void setConnectionLocal(IConnection connection) {
        if (log.isDebugEnabled()) {
            log.debug("Set connection: {} with thread: {}", (Object)(connection != null ? connection.getSessionId() : null), (Object)Thread.currentThread().getName());
            try {
                StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
                StackTraceElement stackTraceElement = stackTraceElements[2];
                log.debug("Caller: {}.{} #{}", new Object[]{stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber()});
            }
            catch (Exception stackTraceElements) {
                // empty catch block
            }
        }
        if (connection != null) {
            connThreadLocal.set(new WeakReference<IConnection>(connection));
            IScope scope = connection.getScope();
            if (scope != null && scope.getClassLoader() != null) {
                Thread.currentThread().setContextClassLoader(scope.getClassLoader());
            }
        } else {
            connThreadLocal.remove();
        }
    }

    public static IConnection getConnectionLocal() {
        WeakReference<IConnection> ref = connThreadLocal.get();
        if (ref != null) {
            IConnection connection = (IConnection)ref.get();
            log.debug("Get connection: {} on thread: {}", (Object)(connection != null ? connection.getSessionId() : null), (Object)Thread.currentThread().getName());
            return connection;
        }
        return null;
    }

    public IConnection getConnection() {
        return this.conn;
    }

    public IScope getScope() {
        return this.conn.getScope();
    }

    public IClient getClient() {
        return this.conn.getClient();
    }

    public IContext getContext() {
        return this.conn.getScope().getContext();
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getFMSVersion() {
        return FMS_VERSION;
    }

    public static Integer getCapabilities() {
        return CAPABILITIES;
    }

    public static Object getDataVersion() {
        return DATA_VERSION;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static long getUpTime() {
        return System.currentTimeMillis() - START_TIME;
    }

    public static Red5 from(CompositeData cd) {
        Object cn;
        Red5 instance = null;
        instance = cd.containsKey("connection") ? ((cn = cd.get("connection")) != null && cn instanceof IConnection ? new Red5((IConnection)cn) : new Red5()) : new Red5();
        return instance;
    }
}

