/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.JMX;
import javax.management.ObjectName;
import org.apache.mina.core.session.IoSession;
import org.red5.server.api.Red5;
import org.red5.server.api.scope.IBasicScope;
import org.red5.server.jmx.mxbeans.RTMPMinaTransportMXBean;
import org.red5.server.net.IConnectionManager;
import org.red5.server.net.rtmp.RTMPConnection;
import org.red5.server.net.rtmp.RTMPMinaConnection;
import org.red5.server.net.rtmp.codec.RTMP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class RTMPConnManager
implements IConnectionManager<RTMPConnection>,
ApplicationContextAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RTMPConnManager.class);
    protected static ApplicationContext applicationContext;
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new CustomizableThreadFactory("ConnectionChecker-"));
    protected ConcurrentMap<String, RTMPConnection> connMap = new ConcurrentHashMap<String, RTMPConnection>();
    protected AtomicInteger conns = new AtomicInteger();
    protected static IConnectionManager<RTMPConnection> instance;
    protected boolean debug;

    public RTMPConnManager() {
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                int closedConnections = 0;
                Collection<RTMPConnection> allConns = RTMPConnManager.this.getAllConnections();
                log.debug("Checking {} connections", (Object)allConns.size());
                block3: for (RTMPConnection conn : allConns) {
                    if (log.isTraceEnabled()) {
                        log.trace("{} session: {} state: {} keep-alive running: {}", new Object[]{conn.getClass().getSimpleName(), conn.getSessionId(), RTMP.states[conn.getStateCode()], conn.running});
                        log.trace("Decoder lock - permits: {} queue length: {}", (Object)conn.decoderLock.availablePermits(), (Object)conn.decoderLock.getQueueLength());
                        log.trace("Encoder lock - permits: {} queue length: {}", (Object)conn.encoderLock.availablePermits(), (Object)conn.encoderLock.getQueueLength());
                        log.trace("Client streams: {} used: {}", (Object)conn.getStreams().size(), (Object)conn.getUsedStreamCount());
                        if (!conn.getAttributes().isEmpty()) {
                            log.trace("Attributes: {}", conn.getAttributes());
                        }
                        Iterator<IBasicScope> scopes = conn.getBasicScopes();
                        while (scopes.hasNext()) {
                            IBasicScope scope = scopes.next();
                            log.trace("Scope: {}", (Object)scope);
                        }
                    }
                    String sessionId = conn.getSessionId();
                    RTMP rtmp = conn.getState();
                    switch (rtmp.getState()) {
                        case 4: 
                        case 5: {
                            RTMPConnManager.this.removeConnection(sessionId);
                            continue block3;
                        }
                    }
                    long ioTime = 0L;
                    IoSession session = conn.getIoSession();
                    if (conn instanceof RTMPMinaConnection) {
                        ioTime = System.currentTimeMillis() - session.getLastIoTime();
                        if (log.isTraceEnabled()) {
                            log.trace("Session - write queue: {} session count: {}", (Object)session.getWriteRequestQueue().size(), (Object)session.getService().getManagedSessionCount());
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Session last io time: {} ms", (Object)ioTime);
                    }
                    if (ioTime < (long)conn.maxInactivity) continue;
                    log.warn("Connection {} has exceeded the max inactivity threshold of {} ms", (Object)conn.getSessionId(), (Object)conn.maxInactivity);
                    if (session != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Prepared to clear write queue, if session is connected: {}; closing? {}", (Object)session.isConnected(), (Object)session.isClosing());
                        }
                        if (session.isConnected()) {
                            session.getWriteRequestQueue().clear(session);
                        }
                    }
                    conn.onInactive();
                    if (!conn.isClosed()) {
                        log.debug("Connection {} is not closed", (Object)conn.getSessionId());
                        continue;
                    }
                    ++closedConnections;
                }
                if (closedConnections > 0) {
                    System.gc();
                }
            }
        }, 7000L, 30000L, TimeUnit.MILLISECONDS);
    }

    public static IConnectionManager<RTMPConnection> getInstance() {
        if (instance == null) {
            log.trace("Connection manager instance does not exist");
            if (applicationContext != null && applicationContext.containsBean("rtmpConnManager")) {
                log.trace("Connection manager bean exists");
                instance = (RTMPConnManager)applicationContext.getBean("rtmpConnManager");
            } else {
                log.trace("Connection manager bean doesnt exist, creating new instance");
                instance = new RTMPConnManager();
            }
        }
        return instance;
    }

    @Override
    public RTMPConnection createConnection(Class<?> connCls) {
        RTMPConnection conn = null;
        if (RTMPConnection.class.isAssignableFrom(connCls)) {
            try {
                conn = this.createConnectionInstance(connCls);
                this.connMap.put(conn.getSessionId(), conn);
                log.trace("Connections: {}", (Object)this.conns.incrementAndGet());
                if (applicationContext.containsBean("rtmpScheduler") && conn.getScheduler() == null) {
                    conn.setScheduler((ThreadPoolTaskScheduler)applicationContext.getBean("rtmpScheduler"));
                }
                log.trace("Connection created: {}", (Object)conn);
            }
            catch (Exception ex) {
                log.warn("Exception creating connection", (Throwable)ex);
            }
        }
        return conn;
    }

    @Override
    public RTMPConnection createConnection(Class<?> connCls, String sessionId) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setConnection(RTMPConnection conn) {
        log.trace("Adding connection: {}", (Object)conn);
        int id = conn.getId();
        if (id == -1) {
            log.debug("Connection has unsupported id, using session id hash");
            id = conn.getSessionId().hashCode();
        }
        log.debug("Connection id: {} session id hash: {}", (Object)conn.getId(), (Object)conn.getSessionId().hashCode());
        if (this.debug) {
            log.info("Connection count (map): {}", (Object)this.connMap.size());
            try {
                RTMPMinaTransportMXBean proxy = JMX.newMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), new ObjectName("org.red5.server:type=RTMPMinaTransport"), RTMPMinaTransportMXBean.class, true);
                if (proxy != null) {
                    log.info("{}", (Object)proxy.getStatistics());
                }
            }
            catch (Exception e) {
                log.warn("Error on jmx lookup", (Throwable)e);
            }
        }
    }

    @Override
    public RTMPConnection getConnection(int clientId) {
        log.trace("Getting connection by client id: {}", (Object)clientId);
        for (RTMPConnection conn : this.connMap.values()) {
            if (conn.getId() != clientId) continue;
            return (RTMPConnection)this.connMap.get(conn.getSessionId());
        }
        return null;
    }

    @Override
    public RTMPConnection getConnectionBySessionId(String sessionId) {
        log.trace("Getting connection by session id: {}", (Object)sessionId);
        RTMPConnection conn = (RTMPConnection)this.connMap.get(sessionId);
        if (conn == null && log.isDebugEnabled()) {
            log.debug("Connection not found for {}", (Object)sessionId);
            if (log.isTraceEnabled()) {
                log.trace("Connections ({}) {}", (Object)this.connMap.size(), this.connMap.values());
            }
        }
        return conn;
    }

    @Override
    public RTMPConnection removeConnection(int clientId) {
        log.trace("Removing connection with id: {}", (Object)clientId);
        for (RTMPConnection conn : this.connMap.values()) {
            if (conn.getId() != clientId) continue;
            return this.removeConnection(conn.getSessionId());
        }
        log.warn("Connection was not removed by id: {}", (Object)clientId);
        return null;
    }

    @Override
    public RTMPConnection removeConnection(String sessionId) {
        RTMPConnection conn;
        log.trace("Removing connection with session id: {}", (Object)sessionId);
        if (log.isTraceEnabled()) {
            log.trace("Connections ({}) at pre-remove: {}", (Object)this.connMap.size(), this.connMap.values());
        }
        if ((conn = (RTMPConnection)this.connMap.remove(sessionId)) != null) {
            log.trace("Connections: {}", (Object)this.conns.decrementAndGet());
            Red5.setConnectionLocal(null);
        }
        return conn;
    }

    @Override
    public Collection<RTMPConnection> getAllConnections() {
        ArrayList<RTMPConnection> list = new ArrayList<RTMPConnection>(this.connMap.size());
        list.addAll(this.connMap.values());
        return list;
    }

    @Override
    public Collection<RTMPConnection> removeConnections() {
        ArrayList<RTMPConnection> list = new ArrayList<RTMPConnection>(this.connMap.size());
        list.addAll(this.connMap.values());
        this.connMap.clear();
        this.conns.set(0);
        return list;
    }

    public RTMPConnection createConnectionInstance(Class<?> cls) throws Exception {
        RTMPConnection conn = null;
        conn = cls == RTMPMinaConnection.class ? (RTMPMinaConnection)applicationContext.getBean(RTMPMinaConnection.class) : (RTMPConnection)cls.newInstance();
        return conn;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        RTMPConnManager.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        this.executor.shutdownNow();
    }
}

