/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.rtmp.event;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.apache.mina.core.buffer.IoBuffer;
import org.red5.codec.VideoCodec;
import org.red5.io.IoConstants;
import org.red5.server.api.event.IEvent;
import org.red5.server.api.stream.IStreamPacket;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.stream.IStreamData;

public class VideoData
extends BaseEvent
implements IoConstants,
IStreamData<VideoData>,
IStreamPacket {
    private static final long serialVersionUID = 5538859593815804830L;
    public static final String CODEC_HEVC = "hvc1";
    public static final String CODEC_AVC = "avc1";
    public static final String CODEC_AV1 = "av01";
    public static final String CODEC_VP9 = "vp09";
    public static final String CODEC_VP8 = "vp08";
    public static final int MASK_EX_VIDEO_TAG_HEADER = 128;
    public static final int MASK_EX_VIDEO_FRAME_TYPE = 112;
    public static final int MASK_EX_VIDEO_PACKET_TYPE = 15;
    private boolean exVideoHeader = false;
    private ExVideoPacketType exVideoPacketType;
    private long receivedTime;
    protected IoBuffer data;
    private byte dataType = (byte)9;
    private FrameType frameType = FrameType.UNKNOWN;
    private int codecId = -1;
    protected boolean config;

    public VideoData() {
        this(IoBuffer.allocate((int)0).flip());
    }

    public VideoData(IoBuffer data) {
        super(IEvent.Type.STREAM_DATA);
        this.setData(data);
    }

    public VideoData(IoBuffer data, boolean copy) {
        super(IEvent.Type.STREAM_DATA);
        if (copy) {
            byte[] array = new byte[data.limit()];
            data.mark();
            data.get(array);
            data.reset();
            this.setData(array);
        } else {
            this.setData(data);
        }
    }

    @Override
    public byte getDataType() {
        return this.dataType;
    }

    public void setDataType(byte dataType) {
        this.dataType = dataType;
    }

    @Override
    public IoBuffer getData() {
        return this.data;
    }

    public void setData(IoBuffer data) {
        this.data = data;
        if (data != null && data.limit() > 0) {
            data.mark();
            int firstByte = data.get() & 0xFF;
            this.exVideoHeader = (firstByte & 0x80) >> 7 == 1;
            int frameTypeLocal = 0;
            if (this.exVideoHeader) {
                frameTypeLocal = (firstByte & 0x70) >> 4;
                int videoPacketType = firstByte & 0xF;
                ExVideoPacketType[] values = ExVideoPacketType.values();
                this.exVideoPacketType = values[videoPacketType];
                this.log.debug("Extended video tag header - exVideoPacketType: {} frameType value:{}", (Object)this.exVideoPacketType.name(), (Object)frameTypeLocal);
            } else {
                this.codecId = firstByte & 0xF;
                if (this.codecId == VideoCodec.AVC.getId()) {
                    this.config = data.get() == 0;
                }
                frameTypeLocal = (firstByte & 0xF0) >> 4;
            }
            this.frameType = frameTypeLocal == 1 ? FrameType.KEYFRAME : (frameTypeLocal == 2 ? FrameType.INTERFRAME : (frameTypeLocal == 3 ? FrameType.DISPOSABLE_INTERFRAME : (frameTypeLocal == 5 ? FrameType.COMMAND : FrameType.UNKNOWN)));
            if (this.exVideoHeader) {
                if (this.exVideoPacketType != ExVideoPacketType.METADATA && this.frameType == FrameType.COMMAND) {
                    this.log.info("Command is not yet supported in video data, incoming command:{}", (Object)(data.get() & 0xFF));
                } else if (this.exVideoPacketType == ExVideoPacketType.MULTITRACK) {
                    this.log.info("Multitrack is not yet supported in video data");
                } else {
                    byte[] fourcc = new byte[4];
                    data.get(fourcc);
                    VideoFourCC videoFourCc = VideoData.findFourCcByValue(VideoFourCC.makeFourCc(new String(fourcc)));
                    if (videoFourCc == null) {
                        throw new IllegalArgumentException("Video fourcc cannot be found");
                    }
                    this.log.debug("Incoming video fourcc:{} videoPacketType:{} frameType:{}", new Object[]{videoFourCc.name(), this.exVideoPacketType.name(), this.frameType.name()});
                    this.codecId = videoFourCc.value;
                }
            }
            data.reset();
        }
    }

    public static VideoFourCC findFourCcByValue(int value) {
        for (VideoFourCC fourCc : VideoFourCC.values()) {
            if (fourCc.value != value) continue;
            return fourCc;
        }
        return null;
    }

    public void setData(byte[] data) {
        this.data = IoBuffer.allocate((int)data.length);
        this.data.put(data).flip();
    }

    public FrameType getFrameType() {
        return this.frameType;
    }

    public int getCodecId() {
        return this.codecId;
    }

    public boolean isConfig() {
        return this.config;
    }

    @Override
    protected void releaseInternal() {
        if (this.data != null) {
            IoBuffer localData = this.data;
            this.data = null;
            localData.clear();
            localData.free();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.frameType = (FrameType)((Object)in.readObject());
        byte[] byteBuf = (byte[])in.readObject();
        if (byteBuf != null) {
            this.setData(IoBuffer.wrap((byte[])byteBuf));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject((Object)this.frameType);
        if (this.data != null) {
            out.writeObject(this.data.array());
        } else {
            out.writeObject(null);
        }
    }

    public VideoData duplicate() throws IOException, ClassNotFoundException {
        VideoData result = new VideoData();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        this.writeExternal(oos);
        oos.close();
        byte[] buf = baos.toByteArray();
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bais);
        result.readExternal(ois);
        ois.close();
        bais.close();
        if (this.header != null) {
            result.setHeader(this.header.clone());
        }
        return result;
    }

    public String toString() {
        return String.format("Video - ts: %s length: %s", this.getTimestamp(), this.data != null ? this.data.limit() : 48);
    }

    public boolean isExVideoHeader() {
        return this.exVideoHeader;
    }

    public long getReceivedTime() {
        return this.receivedTime;
    }

    public ExVideoPacketType getExVideoPacketType() {
        return this.exVideoPacketType;
    }

    public void setConfig(boolean config) {
        this.config = config;
    }

    public void setReceivedTime(long timeMillis) {
        this.receivedTime = timeMillis;
    }

    public static enum FrameType {
        UNKNOWN,
        KEYFRAME,
        INTERFRAME,
        DISPOSABLE_INTERFRAME,
        COMMAND;

    }

    public static enum ExVideoPacketType {
        SEQUENCE_START(0),
        CODED_FRAMES(1),
        SEQUENCE_END(2),
        CODED_FRAMESX(3),
        METADATA(4),
        MPEG2TS_SEQUENCE_START(5),
        MULTITRACK(6);

        public final int value;

        private ExVideoPacketType(int value) {
            this.value = value;
        }
    }

    public static enum VideoFourCC {
        VP8_FOURCC("vp08"),
        VP9_FOURCC("vp09"),
        AV1_FOURCC("av01"),
        AVC_FOURCC("avc1"),
        HEVC_FOURCC("hvc1");

        public final int value;

        private VideoFourCC(String value) {
            this.value = VideoFourCC.makeFourCc(value);
        }

        public static int makeFourCc(String fourcc) {
            return fourcc.charAt(0) | fourcc.charAt(1) << 8 | fourcc.charAt(2) << 16 | fourcc.charAt(3) << 24;
        }
    }
}

