/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.net.servlet;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;

public class ServletUtils {
    private static Logger log = Red5LoggerFactory.getLogger(ServletUtils.class);
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    public static void copy(InputStream input, OutputStream output) throws IOException {
        ServletUtils.copy(input, output, 2048);
    }

    public static void copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int availableBytes = input.available();
        log.debug("copy - bufferSize: {} available: {}", (Object)bufferSize, (Object)availableBytes);
        byte[] buf = null;
        if (availableBytes > 0) {
            buf = availableBytes >= bufferSize ? new byte[bufferSize] : new byte[availableBytes];
            int bytesRead = input.read(buf);
            while (bytesRead != -1) {
                output.write(buf, 0, bytesRead);
                bytesRead = input.read(buf);
                log.trace("Bytes read: {}", (Object)bytesRead);
            }
            output.flush();
        } else {
            log.debug("Available is 0, attempting to read anyway");
            buf = new byte[bufferSize];
            int bytesRead = input.read(buf);
            while (bytesRead != -1) {
                output.write(buf, 0, bytesRead);
                bytesRead = input.read(buf);
                log.trace("Bytes read: {}", (Object)bytesRead);
            }
            output.flush();
        }
    }

    public static void copy(HttpServletRequest req, OutputStream output) throws IOException {
        ServletInputStream input = req.getInputStream();
        int availableBytes = req.getContentLength();
        log.debug("copy - available: {}", (Object)availableBytes);
        if (availableBytes > 0) {
            byte[] buf = new byte[availableBytes];
            int bytesRead = input.read(buf);
            while (bytesRead != -1) {
                output.write(buf, 0, bytesRead);
                bytesRead = input.read(buf);
                log.trace("Bytes read: {}", (Object)bytesRead);
            }
            output.flush();
        } else {
            log.debug("Nothing to available to copy");
        }
    }

    public static void copyThenClose(InputStream input, OutputStream output) throws IOException {
        ServletUtils.copy(input, output);
        input.close();
        output.close();
    }

    public static byte[] getBytes(InputStream input) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        ServletUtils.copy(input, (OutputStream)result);
        result.close();
        return result.toByteArray();
    }

    public static List<String> getRemoteAddresses(HttpServletRequest request) {
        String httpVia;
        String forwardedFor;
        ArrayList<String> addresses = new ArrayList<String>();
        addresses.add(request.getRemoteHost());
        if (!request.getRemoteAddr().equals(request.getRemoteHost())) {
            addresses.add(request.getRemoteAddr());
        }
        if ((forwardedFor = request.getHeader("X-Forwarded-For")) != null) {
            String[] parts;
            for (String part : parts = forwardedFor.split(",")) {
                addresses.add(part);
            }
        }
        if ((httpVia = request.getHeader("Via")) != null) {
            String[] parts;
            for (String part : parts = httpVia.split(",")) {
                addresses.add(part);
            }
        }
        return Collections.unmodifiableList(addresses);
    }
}

