/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.scope;

import org.red5.server.api.IServer;
import org.red5.server.api.persistence.IPersistenceStore;
import org.red5.server.api.persistence.PersistenceUtils;
import org.red5.server.api.scope.IGlobalScope;
import org.red5.server.api.scope.ScopeType;
import org.red5.server.jmx.mxbeans.GlobalScopeMXBean;
import org.red5.server.scope.Scope;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class GlobalScope
extends Scope
implements IGlobalScope,
GlobalScopeMXBean {
    protected transient IServer server;

    public GlobalScope() {
        this.type = ScopeType.GLOBAL;
        this.name = "default";
    }

    @Override
    public void setPersistenceClass(String persistenceClass) throws Exception {
        this.persistenceClass = persistenceClass;
    }

    @Override
    public IPersistenceStore getStore() {
        if (this.store == null) {
            try {
                this.store = PersistenceUtils.getPersistenceStore(this, this.persistenceClass);
            }
            catch (Exception error) {
                log.error("Could not create persistence store.", (Throwable)error);
                this.store = null;
            }
        }
        return this.store;
    }

    public void setServer(IServer server) {
        this.server = server;
    }

    @Override
    public IServer getServer() {
        return this.server;
    }

    @Override
    public void register() {
        this.server.registerGlobal(this);
        this.init();
    }
}

