/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream;

import org.red5.io.ITag;
import org.red5.io.ITagReader;
import org.red5.io.flv.IKeyFrameDataAnalyzer;
import org.red5.server.net.rtmp.event.AudioData;
import org.red5.server.net.rtmp.event.BaseEvent;
import org.red5.server.net.rtmp.event.IRTMPEvent;
import org.red5.server.net.rtmp.event.Invoke;
import org.red5.server.net.rtmp.event.Notify;
import org.red5.server.net.rtmp.event.Unknown;
import org.red5.server.net.rtmp.event.VideoData;
import org.red5.server.net.rtmp.message.Constants;
import org.red5.server.stream.ISeekableStreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStreamSource
implements ISeekableStreamSource,
Constants {
    protected static Logger log = LoggerFactory.getLogger(FileStreamSource.class);
    private ITagReader reader;
    private IKeyFrameDataAnalyzer.KeyFrameMeta keyFrameMeta;

    public FileStreamSource(ITagReader reader) {
        this.reader = reader;
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @Override
    public IRTMPEvent dequeue() {
        if (this.reader.hasMoreTags()) {
            ITag tag = this.reader.readTag();
            BaseEvent msg = switch (tag.getDataType()) {
                case 8 -> new AudioData(tag.getBody());
                case 9 -> new VideoData(tag.getBody());
                case 20 -> new Invoke(tag.getBody());
                case 18 -> new Notify(tag.getBody());
                default -> {
                    log.warn("Unexpected type? {}", (Object)tag.getDataType());
                    yield new Unknown(tag.getDataType(), tag.getBody());
                }
            };
            msg.setTimestamp(tag.getTimestamp());
            return msg;
        }
        return null;
    }

    @Override
    public boolean hasMore() {
        return this.reader.hasMoreTags();
    }

    @Override
    public int seek(int ts) {
        log.trace("Seek ts: {}", (Object)ts);
        if (this.keyFrameMeta == null) {
            if (!(this.reader instanceof IKeyFrameDataAnalyzer)) {
                return ts;
            }
            this.keyFrameMeta = ((IKeyFrameDataAnalyzer)((Object)this.reader)).analyzeKeyFrames();
        }
        if (this.keyFrameMeta.positions.length == 0) {
            return ts;
        }
        int frame = 0;
        int i = 0;
        while (i < this.keyFrameMeta.positions.length && this.keyFrameMeta.timestamps[i] <= ts) {
            frame = i++;
        }
        this.reader.position(this.keyFrameMeta.positions[frame]);
        return this.keyFrameMeta.timestamps[frame];
    }
}

