/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.stream.message;

import org.red5.server.messaging.AbstractMessage;
import org.red5.server.net.rtmp.RTMPType;
import org.red5.server.net.rtmp.event.IRTMPEvent;

public class RTMPMessage
extends AbstractMessage {
    private final IRTMPEvent body;

    private RTMPMessage(IRTMPEvent body) {
        this.body = body;
        this.setMessageType(RTMPType.valueOf(body.getDataType()));
    }

    private RTMPMessage(IRTMPEvent body, int eventTime) {
        this.body = body;
        this.body.setTimestamp(eventTime);
        this.setMessageType(RTMPType.valueOf(body.getDataType()));
    }

    public IRTMPEvent getBody() {
        return this.body;
    }

    public static final RTMPMessage build(IRTMPEvent body) {
        RTMPMessage msg = new RTMPMessage(body);
        msg.body.setSourceType(body.getSourceType());
        return msg;
    }

    public static final RTMPMessage build(IRTMPEvent body, int eventTime) {
        RTMPMessage msg = new RTMPMessage(body, eventTime);
        msg.body.setSourceType(body.getSourceType());
        return msg;
    }

    public static final RTMPMessage build(IRTMPEvent body, byte sourceType) {
        RTMPMessage msg = new RTMPMessage(body);
        msg.body.setSourceType(sourceType);
        return msg;
    }
}

