/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server.tomcat;

import java.lang.reflect.InvocationTargetException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.StandardRoot;

public class EmbeddedTomcat
extends Tomcat {
    private long cacheMaxSize = 0x100000L;

    public Context addWebapp(Host host, String contextPath, String docBase) {
        LifecycleListener listener = null;
        try {
            Class<?> clazz = Class.forName(this.getHost().getConfigClass());
            listener = (LifecycleListener)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
        return this.addWebapp(host, contextPath, docBase, listener);
    }

    public Context addWebapp(Host host, String contextPath, String docBase, LifecycleListener config) {
        Context ctx = this.createContextInternal(host, contextPath);
        ctx.setPath(contextPath);
        ctx.setDocBase(docBase);
        ctx.addLifecycleListener((LifecycleListener)new Tomcat.DefaultWebXmlListener());
        ctx.setConfigFile(this.getWebappConfigFile(docBase, contextPath));
        ctx.addLifecycleListener(config);
        ((ContextConfig)config).setDefaultWebXml(this.noDefaultWebXmlPath());
        this.getHost();
        if (!host.getParentClassLoader().equals(Thread.currentThread().getContextClassLoader())) {
            host.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        }
        StandardRoot standardRoot = new StandardRoot(ctx);
        standardRoot.setCacheMaxSize(this.cacheMaxSize);
        ctx.setResources((WebResourceRoot)standardRoot);
        host.addChild((Container)ctx);
        return ctx;
    }

    private Context createContextInternal(Host host, String url) {
        String contextClass = StandardContext.class.getName();
        if (host == null) {
            host = this.getHost();
        }
        if (host instanceof StandardHost) {
            contextClass = ((StandardHost)host).getContextClass();
        }
        try {
            return (Context)Class.forName(contextClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException("Can't instantiate context-class " + contextClass + " for host " + host + " and url " + url, e);
        }
    }

    public long getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(long cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }
}

