/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia;

import io.antmedia.AppSettings;
import io.antmedia.EncoderSettings;
import io.antmedia.cluster.IClusterNotifier;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.datastore.db.types.VoD;
import io.antmedia.datastore.preference.PreferenceStore;
import io.antmedia.filter.StreamAcceptFilter;
import io.antmedia.ipcamera.OnvifCamera;
import io.antmedia.muxer.IAntMediaStreamHandler;
import io.antmedia.muxer.MuxAdaptor;
import io.antmedia.rest.RestServiceBase;
import io.antmedia.rest.model.Result;
import io.antmedia.security.AcceptOnlyStreamsInDataStore;
import io.antmedia.settings.ServerSettings;
import io.antmedia.shutdown.AMSShutdownManager;
import io.antmedia.shutdown.IShutdownListener;
import io.antmedia.social.endpoint.PeriscopeEndpoint;
import io.antmedia.social.endpoint.VideoServiceEndpoint;
import io.antmedia.statistic.HlsViewerStats;
import io.antmedia.statistic.type.RTMPToWebRTCStats;
import io.antmedia.statistic.type.WebRTCAudioReceiveStats;
import io.antmedia.statistic.type.WebRTCAudioSendStats;
import io.antmedia.statistic.type.WebRTCVideoReceiveStats;
import io.antmedia.statistic.type.WebRTCVideoSendStats;
import io.antmedia.streamsource.StreamFetcher;
import io.antmedia.streamsource.StreamFetcherManager;
import io.antmedia.webrtc.api.IWebRTCAdaptor;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.dropwizard.MetricsService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avformat.AVFormatContext;
import org.red5.server.api.scope.IBroadcastScope;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IClientBroadcastStream;
import org.red5.server.api.stream.IPlayItem;
import org.red5.server.api.stream.IStreamCapableConnection;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.red5.server.api.stream.IStreamService;
import org.red5.server.api.stream.ISubscriberStream;
import org.red5.server.stream.ClientBroadcastStream;
import org.red5.server.stream.StreamService;
import org.red5.server.util.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntMediaApplicationAdapter
implements IAntMediaStreamHandler,
IShutdownListener {
    public static final String BEAN_NAME = "web.handler";
    public static final String BROADCAST_STATUS_CREATED = "created";
    public static final String BROADCAST_STATUS_BROADCASTING = "broadcasting";
    public static final String BROADCAST_STATUS_FINISHED = "finished";
    public static final String BROADCAST_STATUS_PREPARING = "preparing";
    public static final int BROADCAST_STATS_RESET = 0;
    public static final String HOOK_ACTION_END_LIVE_STREAM = "liveStreamEnded";
    public static final String HOOK_ACTION_START_LIVE_STREAM = "liveStreamStarted";
    public static final String HOOK_ACTION_VOD_READY = "vodReady";
    public static final String DEFAULT_LOCALHOST = "127.0.0.1";
    protected static Logger logger = LoggerFactory.getLogger(AntMediaApplicationAdapter.class);
    private ServerSettings serverSettings;
    public static final String VOD = "VoD";
    public static final String LIVE_STREAM = "liveStream";
    public static final String IP_CAMERA = "ipCamera";
    public static final String STREAM_SOURCE = "streamSource";
    protected static final int END_POINT_LIMIT = 20;
    public static final String FACEBOOK = "facebook";
    public static final String PERISCOPE = "periscope";
    public static final String YOUTUBE = "youtube";
    public static final String FACEBOOK_ENDPOINT_CLASS = "io.antmedia.enterprise.social.endpoint.FacebookEndpoint";
    public static final String YOUTUBE_ENDPOINT_CLASS = "io.antmedia.enterprise.social.endpoint.YoutubeEndpoint";
    public static final String WEBAPPS_PATH = "webapps/";
    private Map<String, VideoServiceEndpoint> videoServiceEndpoints = new HashMap<String, VideoServiceEndpoint>();
    private List<VideoServiceEndpoint> videoServiceEndpointsHavingError = new ArrayList<VideoServiceEndpoint>();
    private List<IStreamPublishSecurity> streamPublishSecurityList;
    private HashMap<String, OnvifCamera> onvifCameraList = new HashMap();
    protected StreamFetcherManager streamFetcherManager;
    protected List<MuxAdaptor> muxAdaptors;
    private DataStore dataStore;
    private DataStoreFactory dataStoreFactory;
    private StreamAcceptFilter streamAcceptFilter;
    private AppSettings appSettings;
    private Vertx vertx;
    private IScope scope;
    protected List<String> encoderBlockedStreams = new ArrayList<String>();
    private int numberOfEncoderNotOpenedErrors = 0;
    protected int publishTimeoutStreams = 0;
    private List<String> publishTimeoutStreamsList = new ArrayList<String>();
    private boolean shutdownProperly = true;
    protected WebRTCVideoReceiveStats webRTCVideoReceiveStats = new WebRTCVideoReceiveStats();
    protected WebRTCAudioReceiveStats webRTCAudioReceiveStats = new WebRTCAudioReceiveStats();
    protected WebRTCVideoSendStats webRTCVideoSendStats = new WebRTCVideoSendStats();
    protected WebRTCAudioSendStats webRTCAudioSendStats = new WebRTCAudioSendStats();
    private IClusterNotifier clusterNotifier;

    public boolean appStart(IScope app) {
        this.setScope(app);
        this.vertx = (Vertx)app.getContext().getBean("vertxCore");
        this.getDataStore();
        Result result = this.createInitializationProcess(app.getName());
        if (!result.isSuccess()) {
            this.shutdownProperly = false;
            this.resetBroadcasts();
        }
        if (app.getContext().hasBean("tomcat.cluster")) {
            this.clusterNotifier = (IClusterNotifier)app.getContext().getBean("tomcat.cluster");
            this.clusterNotifier.registerSettingUpdateListener(this.getAppSettings().getAppName(), settings -> this.updateSettings(settings, false));
        }
        this.vertx.setTimer(10L, l -> {
            this.getStreamFetcherManager();
            if (this.appSettings.isStartStreamFetcherAutomatically()) {
                List streams = this.getDataStore().getExternalStreamsList();
                logger.info("Stream source size: {}", (Object)streams.size());
                this.streamFetcherManager.startStreams(streams);
            }
            List socialEndpoints = this.getDataStore().getSocialEndpoints(0, 20);
            logger.info("socialEndpoints size: {}", (Object)socialEndpoints.size());
            for (SocialEndpointCredentials socialEndpointCredentials : socialEndpoints) {
                VideoServiceEndpoint endPointService = null;
                if (socialEndpointCredentials.getServiceName().equals(FACEBOOK)) {
                    endPointService = this.getEndpointService(FACEBOOK_ENDPOINT_CLASS, socialEndpointCredentials, this.appSettings.getFacebookClientId(), this.appSettings.getFacebookClientSecret());
                } else if (socialEndpointCredentials.getServiceName().equals(PERISCOPE)) {
                    endPointService = this.getEndpointService(PeriscopeEndpoint.class.getName(), socialEndpointCredentials, this.appSettings.getPeriscopeClientId(), this.appSettings.getPeriscopeClientSecret());
                } else if (socialEndpointCredentials.getServiceName().equals(YOUTUBE)) {
                    endPointService = this.getEndpointService(YOUTUBE_ENDPOINT_CLASS, socialEndpointCredentials, this.appSettings.getYoutubeClientId(), this.appSettings.getYoutubeClientSecret());
                }
                if (endPointService == null) continue;
                endPointService.setCollectInteractivity(this.appSettings.isCollectSocialMediaActivity());
                this.videoServiceEndpoints.put(endPointService.getCredentials().getId(), endPointService);
            }
            this.synchUserVoDFolder(null, this.appSettings.getVodFolder());
        });
        AMSShutdownManager.getInstance().subscribe(this);
        if (app.getContext().hasBean("webrtc.adaptor")) {
            IWebRTCAdaptor webRTCAdaptor = (IWebRTCAdaptor)app.getContext().getBean("webrtc.adaptor");
            webRTCAdaptor.setExcessiveBandwidthValue(this.appSettings.getExcessiveBandwidthValue());
            webRTCAdaptor.setExcessiveBandwidthCallThreshold(this.appSettings.getExcessiveBandwidthCallThreshold());
            webRTCAdaptor.setTryCountBeforeSwitchback(this.appSettings.getExcessiveBandwithTryCountBeforeSwitchback());
            webRTCAdaptor.setExcessiveBandwidthAlgorithmEnabled(this.appSettings.isExcessiveBandwidthAlgorithmEnabled());
            webRTCAdaptor.setPacketLossDiffThresholdForSwitchback(this.appSettings.getPacketLossDiffThresholdForSwitchback());
            webRTCAdaptor.setRttMeasurementDiffThresholdForSwitchback(this.appSettings.getRttMeasurementDiffThresholdForSwitchback());
        }
        return true;
    }

    public void appStop(IScope app) {
    }

    public Result resetBroadcasts() {
        logger.info("Resetting streams viewer numbers because there is an unexpected stop happened in app: {}", (Object)(this.getScope() != null ? this.getScope().getName() : "[scope is null]"));
        int operationCount = this.getDataStore().resetBroadcasts(this.getServerSettings().getHostAddress());
        Result result = new Result(true);
        result.setMessage("Successfull operations: " + operationCount);
        return result;
    }

    public boolean synchUserVoDFolder(String oldFolderPath, String vodFolderPath) {
        boolean result = false;
        File streamsFolder = new File(WEBAPPS_PATH + this.getScope().getName() + "/streams");
        try {
            this.deleteOldFolderPath(oldFolderPath, streamsFolder);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        File f = new File(vodFolderPath == null ? "" : vodFolderPath);
        try {
            String newLinkPath;
            File newLinkFile;
            if (!streamsFolder.exists()) {
                streamsFolder.mkdir();
            }
            if (f.exists() && f.isDirectory() && !(newLinkFile = new File(newLinkPath = streamsFolder.getAbsolutePath() + "/" + f.getName())).exists()) {
                Path target = f.toPath();
                Files.createSymbolicLink(newLinkFile.toPath(), target, new FileAttribute[0]);
            }
            this.getDataStore().fetchUserVodList(f);
            result = true;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return result;
    }

    public boolean deleteOldFolderPath(String oldFolderPath, File streamsFolder) throws IOException {
        boolean result = false;
        if (oldFolderPath != null && !oldFolderPath.isEmpty() && streamsFolder != null) {
            File f = new File(oldFolderPath);
            File linkFile = new File(streamsFolder.getAbsolutePath(), f.getName());
            if (linkFile.exists() && linkFile.isDirectory()) {
                Files.delete(linkFile.toPath());
                result = true;
            }
        }
        return result;
    }

    public void streamBroadcastClose(IBroadcastStream stream) {
        String streamName = stream.getPublishedName();
        this.vertx.executeBlocking(future -> this.closeBroadcast(streamName), null);
    }

    public void closeBroadcast(String streamName) {
        try {
            this.getDataStore().updateStatus(streamName, BROADCAST_STATUS_FINISHED);
            Broadcast broadcast = this.getDataStore().get(streamName);
            if (broadcast != null) {
                String listenerHookURL = broadcast.getListenerHookURL();
                String streamId = broadcast.getStreamId();
                if (listenerHookURL != null && listenerHookURL.length() > 0) {
                    String name = broadcast.getName();
                    String category = broadcast.getCategory();
                    logger.info("Setting timer to call live stream ended hook for stream:{}", (Object)streamId);
                    this.vertx.setTimer(10L, e -> this.notifyHook(listenerHookURL, streamId, HOOK_ACTION_END_LIVE_STREAM, name, category, null, null));
                }
                this.stopPublishingSocialEndpoints(broadcast);
                if (broadcast.isZombi()) {
                    this.getDataStore().delete(streamName);
                } else {
                    this.resetHLSStats(streamId);
                }
            }
        }
        catch (Exception e2) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e2));
        }
    }

    public void resetHLSStats(String streamId) {
        HlsViewerStats hlsViewerStats;
        if (this.scope.getContext().getApplicationContext().containsBean("hls.viewerstats") && (hlsViewerStats = (HlsViewerStats)this.scope.getContext().getApplicationContext().getBean("hls.viewerstats")) != null) {
            hlsViewerStats.resetHLSViewerMap(streamId);
        }
    }

    public void stopPublishingSocialEndpoints(Broadcast broadcast) {
        List endPointList = broadcast.getEndPointList();
        if (endPointList != null) {
            for (Endpoint endpoint : endPointList) {
                VideoServiceEndpoint videoServiceEndPoint = this.getVideoServiceEndPoint(endpoint.getEndpointServiceId());
                if (videoServiceEndPoint == null) continue;
                try {
                    videoServiceEndPoint.stopBroadcast(endpoint);
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            this.recreateEndpointsForSocialMedia(broadcast, endPointList);
        }
    }

    public void recreateEndpointsForSocialMedia(Broadcast broadcast, List<Endpoint> endPointList) {
        ArrayList<Endpoint> removeList = new ArrayList<Endpoint>();
        ArrayList<Endpoint> addList = new ArrayList<Endpoint>();
        for (Endpoint endpoint : endPointList) {
            VideoServiceEndpoint videoServiceEndPoint;
            if ("".equals(endpoint.getType()) || (videoServiceEndPoint = this.getVideoServiceEndPoint(endpoint.getEndpointServiceId())) == null) continue;
            try {
                Endpoint newEndpoint = videoServiceEndPoint.createBroadcast(broadcast.getName(), broadcast.getDescription(), broadcast.getStreamId(), broadcast.isIs360(), broadcast.isPublicStream(), 2160, true);
                removeList.add(endpoint);
                addList.add(newEndpoint);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        for (Endpoint endpoint : removeList) {
            this.getDataStore().removeEndpoint(broadcast.getStreamId(), endpoint, true);
        }
        for (Endpoint endpoint : addList) {
            this.getDataStore().addEndpoint(broadcast.getStreamId(), endpoint);
        }
    }

    public VideoServiceEndpoint getEndpointService(String className, SocialEndpointCredentials socialEndpointCredentials, String clientId, String clientSecret) {
        try {
            Class<?> endpointClass = Class.forName(className);
            VideoServiceEndpoint endPointService = (VideoServiceEndpoint)endpointClass.getConstructor(String.class, String.class, DataStore.class, SocialEndpointCredentials.class, Vertx.class).newInstance(clientId, clientSecret, this.getDataStore(), socialEndpointCredentials, this.vertx);
            endPointService.setCollectInteractivity(this.appSettings.isCollectSocialMediaActivity());
            return endPointService;
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public void streamPlayItemPlay(IPlayItem item, boolean isLive) {
        this.vertx.setTimer(1L, l -> this.getDataStore().updateRtmpViewerCount(item.getName(), true));
    }

    public void streamPlayItemStop(IPlayItem item) {
        this.vertx.setTimer(1L, l -> this.getDataStore().updateRtmpViewerCount(item.getName(), false));
    }

    public void streamSubscriberClose(ISubscriberStream stream) {
        this.vertx.setTimer(1L, l -> this.getDataStore().updateRtmpViewerCount(stream.getBroadcastStreamPublishName(), false));
    }

    public void streamPublishStart(IBroadcastStream stream) {
        String streamName = stream.getPublishedName();
        logger.info("stream name in streamPublishStart: {}", (Object)streamName);
        long absoluteStartTimeMs = 0L;
        if (stream instanceof ClientBroadcastStream) {
            absoluteStartTimeMs = ((ClientBroadcastStream)stream).getAbsoluteStartTimeMs();
        }
        this.startPublish(streamName, absoluteStartTimeMs);
    }

    public void startPublish(String streamName, long absoluteStartTimeMs) {
        this.vertx.executeBlocking(handler -> {
            try {
                DataStore dataStoreLocal = this.getDataStore();
                Broadcast broadcast = dataStoreLocal.get(streamName);
                if (broadcast == null) {
                    broadcast = AntMediaApplicationAdapter.saveUndefinedBroadcast(streamName, this.getScope().getName(), dataStoreLocal, this.appSettings, BROADCAST_STATUS_BROADCASTING, this.getServerSettings(), absoluteStartTimeMs);
                } else {
                    broadcast.setStatus(BROADCAST_STATUS_BROADCASTING);
                    broadcast.setStartTime(System.currentTimeMillis());
                    broadcast.setOriginAdress(this.getServerSettings().getHostAddress());
                    broadcast.setAbsoluteStartTimeMs(absoluteStartTimeMs);
                    broadcast.setWebRTCViewerCount(0);
                    broadcast.setHlsViewerCount(0);
                    boolean result = dataStoreLocal.updateBroadcastFields(broadcast.getStreamId(), broadcast);
                    logger.info(" Status of stream {} is set to Broadcasting with result: {}", (Object)broadcast.getStreamId(), (Object)result);
                }
                String listenerHookURL = broadcast.getListenerHookURL();
                String streamId = broadcast.getStreamId();
                if (listenerHookURL != null && !listenerHookURL.isEmpty()) {
                    String name = broadcast.getName();
                    String category = broadcast.getCategory();
                    logger.info("Setting timer to call live stream started hook for stream:{}", (Object)streamId);
                    this.vertx.setTimer(10L, e -> this.notifyHook(listenerHookURL, streamId, HOOK_ACTION_START_LIVE_STREAM, name, category, null, null));
                }
                this.publishSocialEndpoints(broadcast.getEndPointList());
                handler.complete();
            }
            catch (Exception e2) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e2));
                handler.fail(ExceptionUtils.getStackTrace((Throwable)e2));
            }
        }, null);
        logger.info("start publish leaved");
    }

    private ServerSettings getServerSettings() {
        if (this.serverSettings == null) {
            this.serverSettings = (ServerSettings)this.scope.getContext().getApplicationContext().getBean("ant.media.server.settings");
        }
        return this.serverSettings;
    }

    public void publishSocialEndpoints(List<Endpoint> endPointList) {
        if (endPointList != null) {
            for (Endpoint endpoint : endPointList) {
                VideoServiceEndpoint videoServiceEndPoint = this.getVideoServiceEndPoint(endpoint.getEndpointServiceId());
                if (videoServiceEndPoint == null) continue;
                try {
                    videoServiceEndPoint.publishBroadcast(endpoint);
                    logger.info("publish broadcast called for {}", (Object)videoServiceEndPoint.getName());
                }
                catch (Exception e) {
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
    }

    public static Broadcast saveUndefinedBroadcast(String streamId, String scopeName, DataStore dataStore, AppSettings appSettings, String streamStatus, ServerSettings serverSettings, long absoluteStartTimeMs) {
        Broadcast newBroadcast = new Broadcast();
        long now = System.currentTimeMillis();
        newBroadcast.setDate(now);
        newBroadcast.setStartTime(now);
        newBroadcast.setZombi(true);
        try {
            newBroadcast.setStreamId(streamId);
            String settingsListenerHookURL = null;
            if (appSettings != null) {
                settingsListenerHookURL = appSettings.getListenerHookURL();
            }
            return RestServiceBase.saveBroadcast(newBroadcast, streamStatus, scopeName, dataStore, settingsListenerHookURL, serverSettings, absoluteStartTimeMs);
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    public VideoServiceEndpoint getVideoServiceEndPoint(String id) {
        if (this.videoServiceEndpoints != null) {
            return this.videoServiceEndpoints.get(id);
        }
        return null;
    }

    public void muxingFinished(String streamId, File file, long duration, int resolution) {
        String muxerFinishScript;
        int index;
        String vodName = file.getName();
        String filePath = file.getPath();
        long fileSize = file.length();
        long systemTime = System.currentTimeMillis();
        String[] subDirs = filePath.split(Pattern.quote(File.separator));
        Integer pathLength = subDirs.length;
        String relativePath = subDirs[pathLength - 2] + "/" + subDirs[pathLength - 1];
        String listenerHookURL = null;
        Object streamName = file.getName();
        Broadcast broadcast = this.getDataStore().get(streamId);
        if (broadcast != null && broadcast.getName() != null) {
            streamName = broadcast.getName();
            listenerHookURL = broadcast.getListenerHookURL();
            if (resolution != 0) {
                streamName = (String)streamName + " (" + resolution + "p)";
            }
        }
        if (listenerHookURL == null || listenerHookURL.isEmpty()) {
            listenerHookURL = this.appSettings.getListenerHookURL();
        }
        String vodId = RandomStringUtils.randomNumeric((int)24);
        VoD newVod = new VoD((String)streamName, streamId, relativePath, vodName, systemTime, duration, fileSize, "streamVod", vodId);
        if (this.getDataStore().addVod(newVod) == null) {
            logger.warn("Stream vod with stream id {} cannot be added to data store", (Object)streamId);
        }
        if (listenerHookURL != null && !listenerHookURL.isEmpty() && (index = vodName.lastIndexOf(".mp4")) != -1 || (index = vodName.lastIndexOf(".webm")) != -1) {
            String baseName = vodName.substring(0, index);
            String finalListenerHookURL = listenerHookURL;
            logger.info("Setting timer for calling vod ready hook for stream:{}", (Object)streamId);
            this.vertx.setTimer(10L, e -> this.notifyHook(finalListenerHookURL, streamId, HOOK_ACTION_VOD_READY, null, null, baseName, vodId));
        }
        if ((muxerFinishScript = this.appSettings.getMuxerFinishScript()) != null && !muxerFinishScript.isEmpty()) {
            this.runScript(muxerFinishScript + "  " + file.getAbsolutePath());
        }
    }

    public void runScript(String scriptFile) {
        this.vertx.executeBlocking(future -> {
            try {
                logger.info("running muxer finish script: {}", (Object)scriptFile);
                Process exec = Runtime.getRuntime().exec(scriptFile);
                int result = exec.waitFor();
                future.complete();
                logger.info("completing script: {} with return value {}", (Object)scriptFile, (Object)result);
            }
            catch (IOException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
            catch (InterruptedException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
        }, res -> {});
    }

    public void startDeviceAuthStatusPolling(VideoServiceEndpoint videoServiceEndpoint, VideoServiceEndpoint.DeviceAuthParameters askDeviceAuthParameters) {
        int timeDelta = askDeviceAuthParameters.interval * 1000;
        this.getVertx().setTimer((long)timeDelta, l -> new AuthCheckJob(0, timeDelta, videoServiceEndpoint, this).execute());
    }

    public Map<String, VideoServiceEndpoint> getVideoServiceEndpoints() {
        return this.videoServiceEndpoints;
    }

    public List<VideoServiceEndpoint> getVideoServiceEndpointsHavingError() {
        return this.videoServiceEndpointsHavingError;
    }

    public void setVideoServiceEndpoints(Map<String, VideoServiceEndpoint> videoServiceEndpoints) {
        this.videoServiceEndpoints = videoServiceEndpoints;
    }

    public StringBuilder notifyHook(String url, String id, String action, String streamName, String category, String vodName, String vodId) {
        StringBuilder response = null;
        logger.info("Running notify hook url:{} stream id: {} action:{} vod name:{} vod id:{}", new Object[]{url, id, action, vodName, vodId});
        if (url != null && url.length() > 0) {
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("id", id);
            variables.put("action", action);
            if (streamName != null) {
                variables.put("streamName", streamName);
            }
            if (category != null) {
                variables.put("category", category);
            }
            if (vodName != null) {
                variables.put("vodName", vodName);
            }
            if (vodId != null) {
                variables.put("vodId", vodId);
            }
            try {
                response = this.sendPOST(url, variables);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return response;
    }

    public StringBuilder sendPOST(String url, Map<String, String> variables) throws IOException {
        StringBuilder response = null;
        try (CloseableHttpClient httpClient = this.getHttpClient();){
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(2000).setConnectionRequestTimeout(2000).setSocketTimeout(2000).build();
            httpPost.setConfig(requestConfig);
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            Set<Map.Entry<String, String>> entrySet = variables.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                urlParameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            UrlEncodedFormEntity postParams = new UrlEncodedFormEntity(urlParameters);
            httpPost.setEntity((HttpEntity)postParams);
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);){
                logger.info("POST Response Status:: {}", (Object)httpResponse.getStatusLine().getStatusCode());
                HttpEntity entity = httpResponse.getEntity();
                if (entity != null) {
                    String inputLine;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));
                    response = new StringBuilder();
                    while ((inputLine = reader.readLine()) != null) {
                        response.append(inputLine);
                    }
                    reader.close();
                }
            }
        }
        return response;
    }

    public CloseableHttpClient getHttpClient() {
        return HttpClients.createDefault();
    }

    public List<IStreamPublishSecurity> getStreamPublishSecurityList() {
        return this.streamPublishSecurityList;
    }

    public void setStreamPublishSecurityList(List<IStreamPublishSecurity> streamPublishSecurityList) {
        this.streamPublishSecurityList = streamPublishSecurityList;
    }

    public AppSettings getAppSettings() {
        return this.appSettings;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public StreamAcceptFilter getStreamAcceptFilter() {
        return this.streamAcceptFilter;
    }

    public void setStreamAcceptFilter(StreamAcceptFilter streamAcceptFilter) {
        this.streamAcceptFilter = streamAcceptFilter;
    }

    public boolean isValidStreamParameters(AVFormatContext inputFormatContext, AVPacket pkt, String streamId) {
        return this.streamAcceptFilter.isValidStreamParameters(inputFormatContext, pkt, streamId);
    }

    public StreamFetcher startStreaming(Broadcast broadcast) {
        if (broadcast.getType().equals(IP_CAMERA) || broadcast.getType().equals(STREAM_SOURCE)) {
            return this.streamFetcherManager.startStreaming(broadcast);
        }
        return null;
    }

    public Result stopStreaming(Broadcast broadcast) {
        IBroadcastStream broadcastStream;
        Result result = new Result(false);
        if (broadcast.getType().equals(IP_CAMERA) || broadcast.getType().equals(STREAM_SOURCE) || broadcast.getType().equals(VOD)) {
            result = this.streamFetcherManager.stopStreaming(broadcast);
        } else if (broadcast.getType().equals(LIVE_STREAM) && (broadcastStream = this.getBroadcastStream(this.getScope(), broadcast.getStreamId())) != null) {
            IStreamCapableConnection connection = ((IClientBroadcastStream)broadcastStream).getConnection();
            if (connection != null) {
                connection.close();
            } else {
                logger.warn("Connection is null. It should not happen for stream: {}. Analyze the logs", (Object)broadcast.getStreamId());
            }
            result.setSuccess(true);
        }
        return result;
    }

    public IBroadcastStream getBroadcastStream(IScope scope, String name) {
        IBroadcastScope bs;
        IStreamService service = (IStreamService)ScopeUtils.getScopeService((IScope)scope, IStreamService.class, StreamService.class);
        if (service instanceof StreamService && (bs = ((StreamService)service).getBroadcastScope(scope, name)) != null) {
            return bs.getClientBroadcastStream();
        }
        return null;
    }

    public OnvifCamera getOnvifCamera(String id) {
        Broadcast camera;
        OnvifCamera onvifCamera = this.onvifCameraList.get(id);
        if (onvifCamera == null && (camera = this.getDataStore().get(id)) != null) {
            onvifCamera = new OnvifCamera();
            onvifCamera.connect(camera.getIpAddr(), camera.getUsername(), camera.getPassword());
            this.onvifCameraList.put(id, onvifCamera);
        }
        return onvifCamera;
    }

    public StreamFetcherManager getStreamFetcherManager() {
        if (this.streamFetcherManager == null) {
            this.streamFetcherManager = new StreamFetcherManager(this.vertx, this.getDataStore(), this.scope);
        }
        return this.streamFetcherManager;
    }

    public void setStreamFetcherManager(StreamFetcherManager streamFetcherManager) {
        this.streamFetcherManager = streamFetcherManager;
    }

    public void setQualityParameters(String id, String quality, double speed, int pendingPacketSize) {
        this.vertx.setTimer(5L, h -> {
            logger.info("update source quality for stream: {} quality:{} speed:{}", new Object[]{id, quality, speed});
            this.getDataStore().updateSourceQualityParameters(id, quality, speed, pendingPacketSize);
        });
    }

    public DataStore getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = this.dataStoreFactory.getDataStore();
        }
        return this.dataStore;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public DataStoreFactory getDataStoreFactory() {
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(DataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRTMPStreams() {
        List<MuxAdaptor> adaptors;
        List<MuxAdaptor> list = adaptors = this.getMuxAdaptors();
        synchronized (list) {
            for (MuxAdaptor adaptor : adaptors) {
                if (!adaptor.getBroadcast().getType().equals(LIVE_STREAM)) continue;
                ClientBroadcastStream broadcastStream = adaptor.getBroadcastStream();
                if (broadcastStream != null) {
                    broadcastStream.stop();
                }
                adaptor.stop();
            }
        }
    }

    public void closeStreamFetchers() {
        if (this.streamFetcherManager != null) {
            Queue<StreamFetcher> fetchers = this.streamFetcherManager.getStreamFetcherList();
            for (StreamFetcher streamFetcher : fetchers) {
                streamFetcher.stopStream();
                fetchers.remove(streamFetcher);
            }
        }
    }

    public void waitUntilLiveStreamsStopped() {
        int i = 0;
        int waitPeriod = 1000;
        while (this.getDataStore().getLocalLiveBroadcastCount(this.getServerSettings().getHostAddress()) > 0L) {
            try {
                if (i > 3) {
                    logger.warn("Waiting for active broadcasts number decrease to zero for app: {}total wait time: {}ms", (Object)this.getScope().getName(), (Object)(i * waitPeriod));
                }
                if (i > 10) {
                    logger.error("*********************************************************************************");
                    logger.error("Not all live streams're stopped. It's even breaking the loop to finish the server");
                    logger.error("*********************************************************************************");
                    break;
                }
                ++i;
                Thread.sleep(waitPeriod);
            }
            catch (InterruptedException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
        }
    }

    public void waitUntilThreadsStop() {
        int i = 0;
        int waitPeriod = 1000;
        int activeVertxThreadCount = 0;
        while ((activeVertxThreadCount = this.getActiveVertxThreadCount()) > 0) {
            try {
                if (i > 3) {
                    logger.warn("Waiting for active vertx threads count({}) decrease to zero for app: {} total wait time: {}ms", new Object[]{activeVertxThreadCount, this.getScope().getName(), i * waitPeriod});
                }
                if (i > 10) {
                    logger.error("*********************************************************************");
                    logger.error("Not all active vertx threads are stopped. It's even breaking the loop");
                    logger.error("*********************************************************************");
                    break;
                }
                ++i;
                Thread.sleep(waitPeriod);
            }
            catch (InterruptedException e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                Thread.currentThread().interrupt();
            }
        }
    }

    private int getActiveVertxThreadCount() {
        int activeVertexThreadCount = 0;
        try {
            MetricsService metricsService = MetricsService.create((Vertx)this.vertx);
            String activeThreadKey = "vertx.pools.worker.vert.x-worker-thread.in-use";
            JsonObject metrics = metricsService.getMetricsSnapshot(activeThreadKey);
            if (metrics != null) {
                activeVertexThreadCount = metrics.getJsonObject(activeThreadKey).getInteger("count");
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return activeVertexThreadCount;
    }

    @Override
    public void serverShuttingdown() {
        logger.info("{} is closing streams", (Object)this.getScope().getName());
        this.closeStreamFetchers();
        this.closeRTMPStreams();
        this.waitUntilLiveStreamsStopped();
        this.waitUntilThreadsStop();
        this.createShutdownFile(this.getScope().getName());
        this.getDataStore().close();
    }

    public Result createInitializationProcess(String appName) {
        Result result = new Result(false);
        String initializedFilePath = WEBAPPS_PATH + appName + "/.initialized";
        File initializedFile = new File(initializedFilePath);
        String closedFilePath = WEBAPPS_PATH + appName + "/.closed";
        File closedFile = new File(closedFilePath);
        try {
            if (!initializedFile.exists() && !closedFile.exists()) {
                if (initializedFile.createNewFile()) {
                    result.setMessage("Initialized file created in " + appName);
                    result.setSuccess(true);
                    logger.info("Initialized file is created in {}", (Object)appName);
                } else {
                    result.setMessage("Initialized file couldn't create in " + appName);
                    result.setSuccess(false);
                    logger.info("Initialized file couldn't be created in {}", (Object)appName);
                }
            } else if (initializedFile.exists() && closedFile.exists()) {
                Files.delete(closedFile.toPath());
                if (!closedFile.exists()) {
                    result.setMessage("System works, deleted closed file in " + appName);
                    result.setSuccess(true);
                    logger.info("Delete the \".closed\" file in {}", (Object)appName);
                } else {
                    result.setMessage("Delete couldn't closed file in " + appName);
                    result.setSuccess(false);
                    logger.info("Not deleted the \".closed\" file in {}", (Object)appName);
                }
            } else if (initializedFile.exists() && !closedFile.exists()) {
                result.setMessage("Something wrong in " + appName);
                result.setSuccess(false);
                logger.error("Something wrong in {}", (Object)appName);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return result;
    }

    public void createShutdownFile(String appName) {
        String closedFilePath = WEBAPPS_PATH + appName + "/.closed";
        File closedFile = new File(closedFilePath);
        try {
            if (!closedFile.exists()) {
                if (closedFile.createNewFile()) {
                    logger.info("Closed file created in {}", (Object)appName);
                } else {
                    logger.error("Closed file couldn't create in {}", (Object)appName);
                }
            } else {
                logger.warn("Closed file already exists for app: {}", (Object)appName);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    public boolean isShutdownProperly() {
        return this.shutdownProperly;
    }

    public void setShutdownProperly(boolean shutdownProperly) {
        this.shutdownProperly = shutdownProperly;
    }

    public void muxAdaptorAdded(MuxAdaptor muxAdaptor) {
        this.getMuxAdaptors().add(muxAdaptor);
    }

    public void muxAdaptorRemoved(MuxAdaptor muxAdaptor) {
        this.getMuxAdaptors().remove(muxAdaptor);
    }

    public List<MuxAdaptor> getMuxAdaptors() {
        if (this.muxAdaptors == null) {
            this.muxAdaptors = Collections.synchronizedList(new ArrayList());
        }
        return this.muxAdaptors;
    }

    public IScope getScope() {
        return this.scope;
    }

    public void setScope(IScope scope) {
        this.scope = scope;
    }

    public int getNumberOfEncodersBlocked() {
        return this.encoderBlockedStreams.size();
    }

    public synchronized void encoderBlocked(String streamId, boolean blocked) {
        if (blocked) {
            this.encoderBlockedStreams.add(streamId);
        } else {
            this.encoderBlockedStreams.remove(streamId);
        }
    }

    public synchronized void incrementEncoderNotOpenedError() {
        ++this.numberOfEncoderNotOpenedErrors;
    }

    public int getNumberOfEncoderNotOpenedErrors() {
        return this.numberOfEncoderNotOpenedErrors;
    }

    public int getNumberOfPublishTimeoutError() {
        return this.publishTimeoutStreams;
    }

    public synchronized void publishTimeoutError(String streamId) {
        ++this.publishTimeoutStreams;
        this.publishTimeoutStreamsList.add(streamId);
    }

    public WebRTCAudioReceiveStats getWebRTCAudioReceiveStats() {
        return this.webRTCAudioReceiveStats;
    }

    public WebRTCVideoReceiveStats getWebRTCVideoReceiveStats() {
        return this.webRTCVideoReceiveStats;
    }

    public WebRTCAudioSendStats getWebRTCAudioSendStats() {
        return this.webRTCAudioSendStats;
    }

    public WebRTCVideoSendStats getWebRTCVideoSendStats() {
        return this.webRTCVideoSendStats;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public synchronized boolean updateSettings(AppSettings newSettings, boolean notifyCluster) {
        boolean result = false;
        List encoderSettingsList = newSettings.getEncoderSettings();
        if (encoderSettingsList != null) {
            for (EncoderSettings encoderSettings : encoderSettingsList) {
                if (encoderSettings.getHeight() > 0 && encoderSettings.getVideoBitrate() > 0 && encoderSettings.getAudioBitrate() > 0) continue;
                logger.error("Unexpected encoder parameter. None of the parameters(height:{}, video bitrate:{}, audio bitrate:{}) can be zero or less", new Object[]{encoderSettings.getHeight(), encoderSettings.getVideoBitrate(), encoderSettings.getAudioBitrate()});
                return false;
            }
        }
        newSettings.setEncoderSettings(encoderSettingsList);
        if (newSettings.getHlsListSize() == null || Integer.valueOf(newSettings.getHlsListSize()) < 5) {
            newSettings.setHlsListSize("5");
        }
        if (newSettings.getHlsTime() == null || Integer.valueOf(newSettings.getHlsTime()) < 1) {
            newSettings.setHlsTime("1");
        }
        if (this.updateAppSettingsFile(this.getScope().getName(), newSettings)) {
            AcceptOnlyStreamsInDataStore securityHandler = (AcceptOnlyStreamsInDataStore)this.getScope().getContext().getBean("acceptOnlyStreamsInDataStore");
            securityHandler.setEnabled(newSettings.isAcceptOnlyStreamsInDataStore());
            this.updateAppSettingsBean(this.appSettings, newSettings);
            if (notifyCluster && this.clusterNotifier != null) {
                this.clusterNotifier.getClusterStore().saveSettings(this.appSettings);
            }
            result = true;
        } else {
            logger.warn("Settings cannot be saved for {}", (Object)this.getScope().getName());
        }
        return result;
    }

    public void setClusterNotifier(IClusterNotifier clusterNotifier) {
        this.clusterNotifier = clusterNotifier;
    }

    private boolean updateAppSettingsFile(String appName, AppSettings newAppsettings) {
        PreferenceStore store = new PreferenceStore(WEBAPPS_PATH + appName + "/WEB-INF/red5-web.properties");
        store.put("settings.mp4MuxingEnabled", String.valueOf(newAppsettings.isMp4MuxingEnabled()));
        store.put("settings.webMMuxingEnabled", String.valueOf(newAppsettings.isWebMMuxingEnabled()));
        store.put("settings.addDateTimeToMp4FileName", String.valueOf(newAppsettings.isAddDateTimeToMp4FileName()));
        store.put("settings.hlsMuxingEnabled", String.valueOf(newAppsettings.isHlsMuxingEnabled()));
        store.put("settings.dashMuxingEnabled", String.valueOf(newAppsettings.isDashMuxingEnabled()));
        store.put("settings.deleteDASHFilesOnEnded", String.valueOf(newAppsettings.isDeleteDASHFilesOnEnded()));
        store.put("settings.acceptOnlyStreamsInDataStore", String.valueOf(newAppsettings.isAcceptOnlyStreamsInDataStore()));
        store.put("settings.objectDetectionEnabled", String.valueOf(newAppsettings.isObjectDetectionEnabled()));
        store.put("settings.publishTokenControlEnabled", String.valueOf(newAppsettings.isPublishTokenControlEnabled()));
        store.put("settings.playTokenControlEnabled", String.valueOf(newAppsettings.isPlayTokenControlEnabled()));
        store.put("settings.webRTCEnabled", String.valueOf(newAppsettings.isWebRTCEnabled()));
        store.put("settings.webRTCFrameRate", String.valueOf(newAppsettings.getWebRTCFrameRate()));
        store.put("settings.hashControlPublishEnabled", String.valueOf(newAppsettings.isHashControlPublishEnabled()));
        store.put("settings.hashControlPlayEnabled", String.valueOf(newAppsettings.isHashControlPlayEnabled()));
        store.put("settings.remoteAllowedCIDR", newAppsettings.getRemoteAllowedCIDR() != null ? newAppsettings.getRemoteAllowedCIDR() : DEFAULT_LOCALHOST);
        store.put("settings.vodFolder", newAppsettings.getVodFolder() != null ? newAppsettings.getVodFolder() : "");
        store.put("settings.hlsListSize", String.valueOf(newAppsettings.getHlsListSize()));
        store.put("settings.hlsTime", String.valueOf(newAppsettings.getHlsTime()));
        store.put("settings.hlsPlayListType", newAppsettings.getHlsPlayListType() != null ? newAppsettings.getHlsPlayListType() : "");
        store.put("settings.encoderSettingsString", AppSettings.encodersList2Str((List)newAppsettings.getEncoderSettings()));
        store.put("tokenHashSecret", newAppsettings.getTokenHashSecret() != null ? newAppsettings.getTokenHashSecret() : "");
        store.put("settings.previewOverwrite", String.valueOf(newAppsettings.isPreviewOverwrite()));
        store.put("settings.allowedPublisherCIDR", newAppsettings.getAllowedPublisherCIDR() != null ? String.valueOf(newAppsettings.getAllowedPublisherCIDR()) : "");
        store.put("settings.h264Enabled", String.valueOf(newAppsettings.isH264Enabled()));
        store.put("settings.vp8Enabled", String.valueOf(newAppsettings.isVp8Enabled()));
        store.put("settings.h265Enabled", String.valueOf(newAppsettings.isH265Enabled()));
        store.put("settings.dataChannelEnabled", String.valueOf(newAppsettings.isDataChannelEnabled()));
        store.put("settings.dataChannelPlayerDistrubution", String.valueOf(newAppsettings.getDataChannelPlayerDistribution()));
        store.put("settings.maxResolutionAccept", String.valueOf(newAppsettings.getMaxResolutionAccept()));
        store.put("settings.maxBitrateAccept", String.valueOf(newAppsettings.getMaxBitrateAccept()));
        store.put("settings.maxFpsAccept", String.valueOf(newAppsettings.getMaxFpsAccept()));
        store.put("settings.listenerHookURL", newAppsettings.getListenerHookURL() != null ? newAppsettings.getListenerHookURL() : "");
        store.put("settings.streamFetcherRestartPeriod", String.valueOf(newAppsettings.getRestartStreamFetcherPeriod()));
        return store.save();
    }

    private void updateAppSettingsBean(AppSettings appSettings, AppSettings newSettings) {
        appSettings.setMp4MuxingEnabled(newSettings.isMp4MuxingEnabled());
        appSettings.setWebMMuxingEnabled(newSettings.isWebMMuxingEnabled());
        appSettings.setAddDateTimeToMp4FileName(newSettings.isAddDateTimeToMp4FileName());
        appSettings.setHlsMuxingEnabled(newSettings.isHlsMuxingEnabled());
        appSettings.setDashMuxingEnabled(newSettings.isDashMuxingEnabled());
        appSettings.setDeleteDASHFilesOnEnded(newSettings.isDeleteDASHFilesOnEnded());
        appSettings.setObjectDetectionEnabled(Boolean.valueOf(newSettings.isObjectDetectionEnabled()));
        appSettings.setHlsListSize(String.valueOf(newSettings.getHlsListSize()));
        appSettings.setHlsTime(String.valueOf(newSettings.getHlsTime()));
        appSettings.setHlsPlayListType(newSettings.getHlsPlayListType());
        appSettings.setAcceptOnlyStreamsInDataStore(newSettings.isAcceptOnlyStreamsInDataStore());
        appSettings.setPublishTokenControlEnabled(newSettings.isPublishTokenControlEnabled());
        appSettings.setPlayTokenControlEnabled(newSettings.isPlayTokenControlEnabled());
        appSettings.setWebRTCEnabled(newSettings.isWebRTCEnabled());
        appSettings.setWebRTCFrameRate(newSettings.getWebRTCFrameRate());
        appSettings.setHashControlPublishEnabled(newSettings.isHashControlPublishEnabled());
        appSettings.setHashControlPlayEnabled(newSettings.isHashControlPlayEnabled());
        appSettings.setTokenHashSecret(newSettings.getTokenHashSecret());
        appSettings.setRemoteAllowedCIDR(newSettings.getRemoteAllowedCIDR());
        appSettings.setEncoderSettings(newSettings.getEncoderSettings());
        String oldVodFolder = appSettings.getVodFolder();
        appSettings.setAllowedPublisherCIDR(newSettings.getAllowedPublisherCIDR());
        appSettings.setVodFolder(newSettings.getVodFolder());
        appSettings.setPreviewOverwrite(newSettings.isPreviewOverwrite());
        this.synchUserVoDFolder(oldVodFolder, newSettings.getVodFolder());
        appSettings.setH264Enabled(newSettings.isH264Enabled());
        appSettings.setVp8Enabled(newSettings.isVp8Enabled());
        appSettings.setH265Enabled(newSettings.isH265Enabled());
        appSettings.setDataChannelEnabled(newSettings.isDataChannelEnabled());
        appSettings.setDataChannelPlayerDistribution(newSettings.getDataChannelPlayerDistribution());
        appSettings.setMaxBitrateAccept(newSettings.getMaxBitrateAccept());
        appSettings.setMaxFpsAccept(newSettings.getMaxFpsAccept());
        appSettings.setMaxResolutionAccept(newSettings.getMaxResolutionAccept());
        appSettings.setListenerHookURL(newSettings.getListenerHookURL());
        appSettings.setRestartStreamFetcherPeriod(newSettings.getRestartStreamFetcherPeriod());
        logger.warn("app settings updated for {}", (Object)this.getScope().getName());
    }

    public void setServerSettings(ServerSettings serverSettings) {
        this.serverSettings = serverSettings;
    }

    public RTMPToWebRTCStats getRTMPToWebRTCStats(String streamId) {
        return new RTMPToWebRTCStats(streamId);
    }

    public boolean isDataChannelEnabled() {
        return false;
    }

    public boolean isDataChannelMessagingSupported() {
        return false;
    }

    public boolean sendDataChannelMessage(String streamId, String message) {
        return false;
    }

    public boolean doesWebRTCStreamExist(String streamId) {
        return false;
    }

    private static class AuthCheckJob {
        private int count;
        private VideoServiceEndpoint videoServiceEndpoint;
        private int interval;
        private AntMediaApplicationAdapter appAdapter;

        public AuthCheckJob(int count, int interval, VideoServiceEndpoint videoServiceEndpoint, AntMediaApplicationAdapter adapter) {
            this.count = count;
            this.videoServiceEndpoint = videoServiceEndpoint;
            this.interval = interval;
            this.appAdapter = adapter;
        }

        public void execute() {
            try {
                if (!this.videoServiceEndpoint.askIfDeviceAuthenticated()) {
                    ++this.count;
                    if (this.count < 10) {
                        if (this.videoServiceEndpoint.getError() == null) {
                            this.appAdapter.getVertx().setTimer((long)this.interval, l -> new AuthCheckJob(this.count, this.interval, this.videoServiceEndpoint, this.appAdapter).execute());
                            logger.info("Asking authetnication for {}", (Object)this.videoServiceEndpoint.getName());
                        } else {
                            this.appAdapter.getVideoServiceEndpointsHavingError().add(this.videoServiceEndpoint);
                        }
                    } else {
                        this.videoServiceEndpoint.setError("AUTHENTICATION_TIMEOUT");
                        this.appAdapter.getVideoServiceEndpointsHavingError().add(this.videoServiceEndpoint);
                        logger.info("Not authenticated for {} and will not try again", (Object)this.videoServiceEndpoint.getName());
                    }
                } else {
                    logger.info("Authenticated, adding video service endpoint type: {} with id: {} to the app", (Object)this.videoServiceEndpoint.getName(), (Object)this.videoServiceEndpoint.getCredentials().getId());
                    this.appAdapter.getVideoServiceEndpoints().put(this.videoServiceEndpoint.getCredentials().getId(), this.videoServiceEndpoint);
                }
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }
}

