/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AppSettings;
import io.antmedia.filter.AbstractFilter;
import io.antmedia.filter.TokenGenerator;
import io.antmedia.security.ITokenService;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ConfigurableWebApplicationContext;

public class TokenFilterManager
extends AbstractFilter {
    private static final String REPLACE_CHARS_REGEX = "[\n|\r|\t]";
    protected static Logger logger = LoggerFactory.getLogger(TokenFilterManager.class);
    private ITokenService tokenService;

    /*
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String method = httpRequest.getMethod();
        String tokenId = ((HttpServletRequest)request).getParameter("token");
        if (tokenId != null) {
            tokenId = tokenId.replaceAll(REPLACE_CHARS_REGEX, "_");
        }
        String sessionId = httpRequest.getSession().getId();
        String streamId = TokenFilterManager.getStreamId(httpRequest.getRequestURI());
        String clientIP = httpRequest.getRemoteAddr().replaceAll(REPLACE_CHARS_REGEX, "_");
        AppSettings appSettings = this.getAppSettings();
        TokenGenerator tokenGenerator = this.getTokenGenerator();
        if (appSettings == null) {
            httpResponse.sendError(403, "Server is getting initialized.");
            logger.warn("AppSettings not initialized. Server is getting started for stream id:{} from request: {}", (Object)streamId, (Object)clientIP);
            return;
        }
        logger.debug("Client IP: {}, request url:  {}, token:  {}, sessionId: {},streamId:  {} ", new Object[]{clientIP, httpRequest.getRequestURI(), tokenId, sessionId, streamId});
        String clusterToken = (String)request.getAttribute("ClusterToken");
        if ("GET".equals(method) && (tokenGenerator == null || clusterToken == null || !clusterToken.equals(tokenGenerator.getGenetaredToken()))) {
            if (appSettings.isPlayTokenControlEnabled()) {
                ITokenService tokenServiceTmp = this.getTokenService();
                if (tokenServiceTmp == null) {
                    httpResponse.sendError(403, "Not initialized");
                    logger.warn("Token service is not initialized. Server is getting started for stream id:{} from request: {}", (Object)streamId, (Object)clientIP);
                    return;
                }
                if (!tokenServiceTmp.checkToken(tokenId, streamId, sessionId, "play")) {
                    httpResponse.sendError(403, "Invalid Token");
                    logger.warn("token {} is not valid", (Object)tokenId);
                    return;
                }
            } else if (appSettings.isHashControlPlayEnabled()) {
                ITokenService tokenServiceTmp = this.getTokenService();
                if (tokenServiceTmp == null) {
                    httpResponse.sendError(403, "Not initialized");
                    logger.warn("Token service is not initialized. Server is getting started for stream id:{} from request: {}", (Object)streamId, (Object)clientIP);
                    return;
                }
                if (!tokenServiceTmp.checkHash(tokenId, streamId, sessionId, "play")) {
                    httpResponse.sendError(403, "Invalid Hash");
                    logger.warn("hash {} is not valid", (Object)tokenId);
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    private TokenGenerator getTokenGenerator() {
        TokenGenerator tokenGenerator = null;
        ConfigurableWebApplicationContext context = this.getAppContext();
        if (context != null && context.containsBean("tokenGenerator")) {
            tokenGenerator = (TokenGenerator)context.getBean("tokenGenerator");
        }
        return tokenGenerator;
    }

    public ITokenService getTokenService() {
        ConfigurableWebApplicationContext context;
        if (this.tokenService == null && (context = this.getAppContext()) != null) {
            this.tokenService = (ITokenService)context.getBean(ITokenService.BeanName.TOKEN_SERVICE.toString());
        }
        return this.tokenService;
    }

    public void setTokenService(ITokenService tokenService) {
        this.tokenService = tokenService;
    }

    public static String getStreamId(String requestURI) {
        requestURI = requestURI.replaceAll(REPLACE_CHARS_REGEX, "_");
        int startIndex = requestURI.lastIndexOf(47);
        if (requestURI.contains("_")) {
            return requestURI.split("_")[0].substring(startIndex + 1);
        }
        int endIndex = requestURI.lastIndexOf(".mp4");
        if (endIndex != -1) {
            return requestURI.substring(startIndex + 1, endIndex);
        }
        endIndex = requestURI.lastIndexOf("_adaptive.m3u8");
        if (endIndex != -1) {
            return requestURI.substring(startIndex + 1, endIndex);
        }
        String regex = "_[0-9]+p\\.m3u8$";
        if (requestURI.matches(regex)) {
            endIndex = requestURI.lastIndexOf(95);
            return requestURI.substring(startIndex + 1, endIndex);
        }
        endIndex = requestURI.lastIndexOf(".m3u8");
        if (endIndex != -1) {
            return requestURI.substring(startIndex + 1, endIndex);
        }
        return null;
    }
}

