/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.logger;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import com.brsanthu.googleanalytics.GoogleAnalytics;
import com.brsanthu.googleanalytics.request.ExceptionHit;
import com.google.common.annotations.VisibleForTesting;
import io.antmedia.logger.GoogleAnalyticsLogger;
import io.antmedia.logger.LoggerUtils;
import io.antmedia.statistic.StatsCollector;
import java.io.File;
import java.util.UUID;
import org.red5.server.Launcher;

class GoogleAnalyticsLoggerImp
implements GoogleAnalyticsLogger {
    @VisibleForTesting
    String instanceId;
    GoogleAnalytics googleAnalytics;

    public GoogleAnalyticsLoggerImp(String path) {
        File idFile = new File(path);
        this.instanceId = null;
        if (idFile.exists()) {
            this.instanceId = LoggerUtils.getFileContent(idFile.getAbsolutePath());
        } else {
            this.instanceId = UUID.randomUUID().toString();
            LoggerUtils.writeToFile(idFile.getAbsolutePath(), this.instanceId);
        }
    }

    @Override
    public void log(IThrowableProxy throwableProxy) {
        String throwableStr = ThrowableProxyUtil.asString((IThrowableProxy)throwableProxy);
        GoogleAnalytics googleAnalytic = this.getGoogleAnalytic();
        ((ExceptionHit)googleAnalytic.exception().exceptionDescription(throwableStr).clientId(this.instanceId)).sendAsync();
    }

    @VisibleForTesting
    GoogleAnalytics getGoogleAnalytic() {
        if (this.googleAnalytics == null) {
            this.googleAnalytics = StatsCollector.getGoogleAnalyticInstance(Launcher.getVersion(), Launcher.getVersionType());
        }
        return this.googleAnalytics;
    }
}

