/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.statistic;

import io.antmedia.AppSettings;
import io.antmedia.datastore.db.DataStore;
import io.antmedia.datastore.db.DataStoreFactory;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.statistic.IStreamStats;
import io.vertx.core.Vertx;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class HlsViewerStats
implements IStreamStats,
ApplicationContextAware {
    protected static Logger logger = LoggerFactory.getLogger(HlsViewerStats.class);
    public static final String BEAN_NAME = "hls.viewerstats";
    private DataStore dataStore;
    private Vertx vertx;
    private DataStoreFactory dataStoreFactory;
    public static final int DEFAULT_TIME_PERIOD_FOR_VIEWER_COUNT = 10000;
    private int timePeriodMS = 10000;
    Map<String, Map<String, Long>> streamsViewerMap = new ConcurrentHashMap<String, Map<String, Long>>();
    Map<String, Integer> increaseCounterMap = new ConcurrentHashMap<String, Integer>();
    private Object lock = new Object();
    private int timeoutMS = 20000;

    @Override
    public void registerNewViewer(String streamId, String sessionId) {
        this.vertx.runOnContext(h -> {
            Object object = this.lock;
            synchronized (object) {
                Map<String, Long> viewerMap = this.streamsViewerMap.get(streamId);
                if (viewerMap == null) {
                    viewerMap = new ConcurrentHashMap<String, Long>();
                }
                if (!viewerMap.containsKey(sessionId)) {
                    int streamIncrementCounter = this.getIncreaseCounterMap(streamId);
                    this.increaseCounterMap.put(streamId, ++streamIncrementCounter);
                }
                viewerMap.put(sessionId, System.currentTimeMillis());
                this.streamsViewerMap.put(streamId, viewerMap);
            }
        });
    }

    public int getIncreaseCounterMap(String streamId) {
        Integer increaseCounter = this.increaseCounterMap.get(streamId);
        return increaseCounter != null ? increaseCounter : 0;
    }

    @Override
    public int getViewerCount(String streamId) {
        Map<String, Long> viewerMap = this.streamsViewerMap.get(streamId);
        int viewerCount = 0;
        if (viewerMap != null) {
            viewerCount = viewerMap.size();
        }
        return viewerCount;
    }

    public int getTotalViewerCount() {
        int viewerCount = 0;
        for (Map<String, Long> map : this.streamsViewerMap.values()) {
            viewerCount += map.size();
        }
        return viewerCount;
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.dataStoreFactory = (DataStoreFactory)applicationContext.getBean("dataStoreFactory");
        this.vertx = (Vertx)applicationContext.getBean("vertxCore");
        AppSettings settings = (AppSettings)applicationContext.getBean("app.settings");
        this.timeoutMS = HlsViewerStats.getTimeoutMSFromSettings(settings, this.timeoutMS);
        this.vertx.setPeriodic(10000L, yt -> {
            Object object = this.lock;
            synchronized (object) {
                Iterator<Map.Entry<String, Map<String, Long>>> streamIterator = this.streamsViewerMap.entrySet().iterator();
                long now = System.currentTimeMillis();
                while (streamIterator.hasNext()) {
                    Map.Entry<String, Map<String, Long>> streamViewerEntry = streamIterator.next();
                    String streamId = streamViewerEntry.getKey();
                    Broadcast broadcast = this.getDataStore().get(streamId);
                    boolean isBroadcasting = false;
                    if (broadcast != null) {
                        int numberOfDecrement = 0;
                        Map<String, Long> viewerMapEntry = streamViewerEntry.getValue();
                        Iterator<Map.Entry<String, Long>> viewerIterator = viewerMapEntry.entrySet().iterator();
                        while (viewerIterator.hasNext()) {
                            Map.Entry<String, Long> viewer = viewerIterator.next();
                            if (viewer.getValue() >= now - (long)this.getTimeoutMS()) continue;
                            viewerIterator.remove();
                            ++numberOfDecrement;
                        }
                        if (broadcast.getStatus().equals("broadcasting")) {
                            isBroadcasting = true;
                        }
                        numberOfDecrement = -1 * numberOfDecrement;
                        int numberOfIncrement = this.getIncreaseCounterMap(streamId);
                        if ((numberOfIncrement != 0 || numberOfDecrement != 0) && isBroadcasting) {
                            int hlsDiffCount = numberOfIncrement + numberOfDecrement;
                            logger.info("Update HLS viewer in stream ID:{} increment count:{} decrement count:{} diff:{}", new Object[]{streamId, numberOfIncrement, numberOfDecrement, hlsDiffCount});
                            this.getDataStore().updateHLSViewerCount(streamViewerEntry.getKey(), hlsDiffCount);
                            this.increaseCounterMap.put(streamId, 0);
                        }
                    }
                    if (isBroadcasting) continue;
                    streamIterator.remove();
                    this.increaseCounterMap.remove(streamId);
                }
            }
        });
    }

    public void resetHLSViewerMap(String streamID) {
        if (this.streamsViewerMap.get(streamID) != null) {
            this.streamsViewerMap.get(streamID).clear();
            this.streamsViewerMap.remove(streamID);
            logger.info("Reset HLS Stream ID: {} removed successfully", (Object)streamID);
        } else {
            logger.info("Reset HLS Stream ID: {} remove failed or null", (Object)streamID);
        }
    }

    public static int getTimeoutMSFromSettings(AppSettings settings, int defaultValue) {
        int newTimePeriodMS = defaultValue;
        String hlsTime = settings.getHlsTime();
        if (hlsTime != null && !hlsTime.isEmpty()) {
            try {
                newTimePeriodMS = Integer.valueOf(hlsTime) * 10 * 1000;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return newTimePeriodMS;
    }

    public void setTimePeriodMS(int timePeriodMS) {
        this.timePeriodMS = timePeriodMS;
    }

    public int getTimePeriodMS() {
        return this.timePeriodMS;
    }

    public int getTimeoutMS() {
        return this.timeoutMS;
    }

    public DataStore getDataStore() {
        if (this.dataStore == null) {
            this.dataStore = this.getDataStoreFactory().getDataStore();
        }
        return this.dataStore;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }

    public DataStoreFactory getDataStoreFactory() {
        return this.dataStoreFactory;
    }

    public void setDataStoreFactory(DataStoreFactory dataStoreFactory) {
        this.dataStoreFactory = dataStoreFactory;
    }
}

