/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtc.adaptor;

import io.antmedia.recorder.FFmpegFrameRecorder;
import io.antmedia.recorder.Frame;
import io.antmedia.recorder.FrameRecorder;
import io.antmedia.webrtc.adaptor.Adaptor;
import io.antmedia.webrtc.api.IAudioTrackListener;
import io.antmedia.websocket.WebSocketCommunityHandler;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc.VideoTrack;
import org.webrtc.WrappedNativeI420Buffer;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;
import org.webrtc.audio.WebRtcAudioTrack;

public class RTMPAdaptor
extends Adaptor {
    public static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    public static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    public static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    public static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    FFmpegFrameRecorder recorder;
    private long startTime;
    private static Logger logger = LoggerFactory.getLogger(RTMPAdaptor.class);
    private ExecutorService videoEncoderExecutor;
    private ExecutorService audioEncoderExecutor;
    private volatile boolean isStopped = false;
    private ScheduledExecutorService signallingExecutor;
    private boolean enableAudio = false;
    private volatile int audioFrameCount = 0;
    private boolean started = false;
    private ScheduledFuture<?> audioDataSchedulerFuture;
    private WebRtcAudioTrack webRtcAudioTrack;
    public static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";
    private String stunServerUri = "stun:stun1.l.google.com:19302";
    private int portRangeMin = 0;
    private int portRangeMax = 0;
    private boolean tcpCandidatesEnabled = true;
    private int height;
    private String outputURL;

    public static FFmpegFrameRecorder initRecorder(String outputURL, int width, int height) {
        FFmpegFrameRecorder recorder = new FFmpegFrameRecorder(outputURL, width, height, 1);
        recorder.setFormat("flv");
        recorder.setSampleRate(44100);
        recorder.setFrameRate(20.0);
        recorder.setPixelFormat(0);
        recorder.setVideoCodec(27);
        recorder.setAudioCodec(86018);
        recorder.setAudioChannels(2);
        recorder.setGopSize(40);
        recorder.setVideoQuality(29);
        return recorder;
    }

    public FFmpegFrameRecorder getNewRecorder(String outputURL, int width, int height) {
        FFmpegFrameRecorder recorder = RTMPAdaptor.initRecorder(outputURL, width, height);
        try {
            recorder.start();
        }
        catch (FrameRecorder.Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            this.webSocketCommunityHandler.sendServerError(this.getStreamId(), this.getSession());
            this.stop();
        }
        return recorder;
    }

    public RTMPAdaptor(String outputURL, WebSocketCommunityHandler webSocketHandler, int height) {
        super(webSocketHandler);
        this.outputURL = outputURL;
        this.height = height;
        this.setSdpMediaConstraints(new MediaConstraints());
        this.getSdpMediaConstraints().mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        this.getSdpMediaConstraints().mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
    }

    public VideoDecoderFactory getVideoDecoderFactory() {
        return null;
    }

    public PeerConnectionFactory createPeerConnectionFactory() {
        PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)PeerConnectionFactory.InitializationOptions.builder().createInitializationOptions());
        VideoEncoderFactory encoderFactory = null;
        VideoDecoderFactory decoderFactory = this.getVideoDecoderFactory();
        PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
        options.disableNetworkMonitor = true;
        options.networkIgnoreMask = 16;
        JavaAudioDeviceModule adm = (JavaAudioDeviceModule)JavaAudioDeviceModule.builder(null).setUseHardwareAcousticEchoCanceler(false).setUseHardwareNoiseSuppressor(false).setAudioRecordErrorCallback(null).setAudioTrackErrorCallback(null).setAudioTrackListener(new IAudioTrackListener(){

            public void playoutStopped() {
            }

            public void playoutStarted() {
                RTMPAdaptor.this.initAudioTrackExecutor();
            }
        }).createAudioDeviceModule();
        this.webRtcAudioTrack = adm.getAudioTrack();
        return PeerConnectionFactory.builder().setOptions(options).setAudioDeviceModule((AudioDeviceModule)adm).setVideoEncoderFactory(encoderFactory).setVideoDecoderFactory(decoderFactory).createPeerConnectionFactory();
    }

    @Override
    public void start() {
        this.videoEncoderExecutor = Executors.newSingleThreadExecutor();
        this.audioEncoderExecutor = Executors.newSingleThreadExecutor();
        this.signallingExecutor = Executors.newSingleThreadScheduledExecutor();
        this.signallingExecutor.execute(() -> {
            try {
                this.peerConnectionFactory = this.createPeerConnectionFactory();
                ArrayList<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
                iceServers.add(PeerConnection.IceServer.builder((String)this.getStunServerUri()).createIceServer());
                PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
                rtcConfig.enableDtlsSrtp = true;
                rtcConfig.minPort = this.portRangeMin;
                rtcConfig.maxPort = this.portRangeMax;
                rtcConfig.tcpCandidatePolicy = this.tcpCandidatesEnabled ? PeerConnection.TcpCandidatePolicy.ENABLED : PeerConnection.TcpCandidatePolicy.DISABLED;
                this.peerConnection = this.peerConnectionFactory.createPeerConnection(rtcConfig, (PeerConnection.Observer)this);
                this.webSocketCommunityHandler.sendStartMessage(this.getStreamId(), this.getSession());
                this.started = true;
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        });
    }

    @Override
    public void stop() {
        if (this.isStopped) {
            logger.info("Stopped already called. It's returning for stream: {}", (Object)this.getStreamId());
            return;
        }
        this.isStopped = true;
        if (this.audioDataSchedulerFuture != null) {
            this.audioDataSchedulerFuture.cancel(false);
        }
        logger.info("Scheduling stop procedure for stream: {}", (Object)this.getStreamId());
        this.signallingExecutor.execute(() -> {
            logger.info("Executing stop procedure for stream: {}", (Object)this.getStreamId());
            this.webSocketCommunityHandler.sendPublishFinishedMessage(this.getStreamId(), this.getSession());
            this.audioEncoderExecutor.shutdownNow();
            this.videoEncoderExecutor.shutdownNow();
            try {
                this.videoEncoderExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e1) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e1));
                Thread.currentThread().interrupt();
            }
            try {
                if (this.peerConnection != null) {
                    this.peerConnection.close();
                    this.recorder.stop();
                    this.peerConnection.dispose();
                    this.peerConnectionFactory.dispose();
                    this.peerConnection = null;
                }
            }
            catch (FrameRecorder.Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        });
        this.signallingExecutor.shutdown();
    }

    public ExecutorService getSignallingExecutor() {
        return this.signallingExecutor;
    }

    public void initAudioTrackExecutor() {
        this.audioDataSchedulerFuture = this.signallingExecutor.scheduleAtFixedRate(() -> {
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
            }
            if (this.audioEncoderExecutor == null || this.audioEncoderExecutor.isShutdown()) {
                return;
            }
            ++this.audioFrameCount;
            ByteBuffer playoutData = this.webRtcAudioTrack.getPlayoutData();
            this.audioEncoderExecutor.execute(() -> this.recordSamples(playoutData));
        }, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    public void recordSamples(ByteBuffer playoutData) {
        ShortBuffer audioBuffer = playoutData.asShortBuffer();
        try {
            boolean result;
            if (this.recorder != null && !(result = this.recorder.recordSamples(this.webRtcAudioTrack.getSampleRate(), this.webRtcAudioTrack.getChannels(), new Buffer[]{audioBuffer}))) {
                logger.info("could not audio sample for stream Id {}", (Object)this.getStreamId());
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void initializeRecorder(VideoFrame frame) {
        if (this.recorder == null) {
            int width = frame.getRotatedWidth() * this.height / frame.getRotatedHeight();
            if (width % 2 == 1) {
                ++width;
            }
            this.recorder = this.getNewRecorder(this.outputURL, width, this.height);
        }
    }

    @Override
    public void onAddStream(MediaStream stream) {
        log.warn("onAddStream for stream: {}", (Object)this.getStreamId());
        if (!stream.audioTracks.isEmpty()) {
            this.enableAudio = true;
        }
        if (!stream.videoTracks.isEmpty()) {
            VideoTrack videoTrack = (VideoTrack)stream.videoTracks.get(0);
            if (videoTrack != null) {
                videoTrack.addSink(new VideoSink(){
                    private int frameCount;
                    private int dropFrameCount = 0;
                    private long pts;
                    private int frameNumber;
                    private int videoFrameLogCounter = 0;
                    private int lastFrameNumber = -1;

                    public void onFrame(VideoFrame frame) {
                        if (RTMPAdaptor.this.startTime == 0L) {
                            RTMPAdaptor.this.startTime = System.currentTimeMillis();
                        }
                        if (RTMPAdaptor.this.videoEncoderExecutor == null || RTMPAdaptor.this.videoEncoderExecutor.isShutdown()) {
                            return;
                        }
                        frame.retain();
                        ++this.frameCount;
                        ++this.videoFrameLogCounter;
                        if (this.videoFrameLogCounter % 100 == 0) {
                            logger.info("Received total video frames: {}  received fps: {} frame rotated width:{} rotated height:{} width:{} height:{} rotation:{}", new Object[]{this.frameCount, (long)this.frameCount / ((System.currentTimeMillis() - RTMPAdaptor.this.startTime) / 1000L), frame.getRotatedWidth(), frame.getRotatedHeight(), frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation()});
                            this.videoFrameLogCounter = 0;
                        }
                        RTMPAdaptor.this.videoEncoderExecutor.execute(() -> {
                            if (RTMPAdaptor.this.enableAudio) {
                                this.pts = (long)RTMPAdaptor.this.audioFrameCount * 10L;
                                logger.trace("audio frame count: {}", (Object)RTMPAdaptor.this.audioFrameCount);
                            } else {
                                this.pts = System.currentTimeMillis() - RTMPAdaptor.this.startTime;
                            }
                            RTMPAdaptor.this.initializeRecorder(frame);
                            this.frameNumber = (int)((double)this.pts * RTMPAdaptor.this.recorder.getFrameRate() / 1000.0);
                            if (this.frameNumber > this.lastFrameNumber) {
                                RTMPAdaptor.this.recorder.setFrameNumber(this.frameNumber);
                                this.lastFrameNumber = this.frameNumber;
                                Frame frameCV = new Frame(frame.getRotatedWidth(), frame.getRotatedHeight(), 8, 2);
                                VideoFrame.Buffer buffer = frame.getBuffer();
                                int[] stride = new int[3];
                                if (buffer instanceof WrappedNativeI420Buffer) {
                                    WrappedNativeI420Buffer wrappedBuffer = (WrappedNativeI420Buffer)buffer;
                                    ((ByteBuffer)frameCV.image[0].position(0)).put(wrappedBuffer.getDataY());
                                    ((ByteBuffer)frameCV.image[0]).put(wrappedBuffer.getDataU());
                                    ((ByteBuffer)frameCV.image[0]).put(wrappedBuffer.getDataV());
                                    stride[0] = wrappedBuffer.getStrideY();
                                    stride[1] = wrappedBuffer.getStrideU();
                                    stride[2] = wrappedBuffer.getStrideV();
                                    try {
                                        RTMPAdaptor.this.recorder.recordImage(frameCV.imageWidth, frameCV.imageHeight, frameCV.imageDepth, frameCV.imageChannels, stride, 0, frameCV.image);
                                    }
                                    catch (FrameRecorder.Exception e) {
                                        logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                                    }
                                } else {
                                    logger.error("Buffer is not type of WrappedNativeI420Buffer for stream: {}", (Object)RTMPAdaptor.this.recorder.getFilename());
                                }
                            } else {
                                ++this.dropFrameCount;
                                logger.debug("dropping video, total drop count: {} frame number: {} recorder frame number: {}", new Object[]{this.dropFrameCount, this.frameNumber, this.lastFrameNumber});
                            }
                            frame.release();
                        });
                    }
                });
            }
        } else {
            logger.warn("There is no video track for stream: {}", (Object)this.getStreamId());
        }
        this.webSocketCommunityHandler.sendPublishStartedMessage(this.getStreamId(), this.getSession(), null);
    }

    @Override
    public void onSetSuccess() {
        this.peerConnection.createAnswer((SdpObserver)this, this.getSdpMediaConstraints());
    }

    public void setRemoteDescription(SessionDescription sdp) {
        this.signallingExecutor.execute(() -> this.peerConnection.setRemoteDescription((SdpObserver)this, sdp));
    }

    public void addIceCandidate(IceCandidate iceCandidate) {
        this.signallingExecutor.execute(() -> {
            if (!this.peerConnection.addIceCandidate(iceCandidate)) {
                log.error("Add ice candidate failed for {}", (Object)iceCandidate);
            }
        });
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public ScheduledFuture getAudioDataSchedulerFuture() {
        return this.audioDataSchedulerFuture;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getStunServerUri() {
        return this.stunServerUri;
    }

    public void setStunServerUri(String stunServerUri) {
        this.stunServerUri = stunServerUri;
    }

    public void setPortRange(int webRTCPortRangeMin, int webRTCPortRangeMax) {
        this.portRangeMin = webRTCPortRangeMin;
        this.portRangeMax = webRTCPortRangeMax;
    }

    public void setTcpCandidatesEnabled(boolean tcpCandidatesEnabled) {
        this.tcpCandidatesEnabled = tcpCandidatesEnabled;
    }

    public int getHeight() {
        return this.height;
    }

    public String getOutputURL() {
        return this.outputURL;
    }

    public void setRecorder(FFmpegFrameRecorder recorder) {
        this.recorder = recorder;
    }

    public void setWebRtcAudioTrack(WebRtcAudioTrack webRtcAudioTrack) {
        this.webRtcAudioTrack = webRtcAudioTrack;
    }
}

